﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/ec2/EC2_EXPORTS.h>
#include <aws/ec2/model/ResponseMetadata.h>
#include <aws/ec2/model/RouteServer.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Xml {
class XmlDocument;
}  // namespace Xml
}  // namespace Utils
namespace EC2 {
namespace Model {
class DescribeRouteServersResponse {
 public:
  AWS_EC2_API DescribeRouteServersResponse() = default;
  AWS_EC2_API DescribeRouteServersResponse(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);
  AWS_EC2_API DescribeRouteServersResponse& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Xml::XmlDocument>& result);

  ///@{
  /**
   * <p>Information about the described route servers.</p>
   */
  inline const Aws::Vector<RouteServer>& GetRouteServers() const { return m_routeServers; }
  template <typename RouteServersT = Aws::Vector<RouteServer>>
  void SetRouteServers(RouteServersT&& value) {
    m_routeServersHasBeenSet = true;
    m_routeServers = std::forward<RouteServersT>(value);
  }
  template <typename RouteServersT = Aws::Vector<RouteServer>>
  DescribeRouteServersResponse& WithRouteServers(RouteServersT&& value) {
    SetRouteServers(std::forward<RouteServersT>(value));
    return *this;
  }
  template <typename RouteServersT = RouteServer>
  DescribeRouteServersResponse& AddRouteServers(RouteServersT&& value) {
    m_routeServersHasBeenSet = true;
    m_routeServers.emplace_back(std::forward<RouteServersT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to retrieve the next page of results. This value is
   * <code>null</code> when there are no more results to return.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  DescribeRouteServersResponse& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const ResponseMetadata& GetResponseMetadata() const { return m_responseMetadata; }
  template <typename ResponseMetadataT = ResponseMetadata>
  void SetResponseMetadata(ResponseMetadataT&& value) {
    m_responseMetadataHasBeenSet = true;
    m_responseMetadata = std::forward<ResponseMetadataT>(value);
  }
  template <typename ResponseMetadataT = ResponseMetadata>
  DescribeRouteServersResponse& WithResponseMetadata(ResponseMetadataT&& value) {
    SetResponseMetadata(std::forward<ResponseMetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<RouteServer> m_routeServers;

  Aws::String m_nextToken;

  ResponseMetadata m_responseMetadata;
  bool m_routeServersHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_responseMetadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace EC2
}  // namespace Aws
