/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.variables;

import org.eclipse.core.internal.variables.StringVariable;
import org.eclipse.core.internal.variables.VariablesMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class DynamicVariable
extends StringVariable
implements IDynamicVariable {
    private IDynamicVariableResolver fResolver;

    @Override
    public String getValue(String argument) throws CoreException {
        if (!this.supportsArgument() && argument != null && argument.length() > 0) {
            throw new CoreException((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 120, NLS.bind((String)VariablesMessages.DynamicVariable_0, (Object)argument, (Object)this.getName()), null));
        }
        if (this.fResolver == null) {
            String name = this.getConfigurationElement().getAttribute("resolver");
            if (name == null) {
                throw new CoreException((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 120, NLS.bind((String)VariablesMessages.VarMissingResolver, (Object)this.getName()), null));
            }
            Object object = this.getConfigurationElement().createExecutableExtension("resolver");
            if (object instanceof IDynamicVariableResolver) {
                this.fResolver = (IDynamicVariableResolver)object;
            } else {
                throw new CoreException((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 120, NLS.bind((String)VariablesMessages.VarResolverNotIContextVariableResolver, (Object)this.getName()), null));
            }
        }
        try {
            return this.fResolver.resolveValue(this, argument);
        }
        catch (RuntimeException e) {
            throw new CoreException((IStatus)new Status(4, VariablesPlugin.getUniqueIdentifier(), 120, NLS.bind((String)VariablesMessages.VarEvalError, (Object)this.getName()), (Throwable)e));
        }
    }

    public DynamicVariable(String name, String description, IConfigurationElement configurationElement) {
        super(name, description, configurationElement);
    }

    @Override
    public boolean supportsArgument() {
        String arg = this.getConfigurationElement().getAttribute("supportsArgument");
        return arg == null || Boolean.parseBoolean(arg);
    }
}

