/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.core.domain;

import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.base.ChainableFunction;
import com.tngtech.archunit.core.domain.JavaClass;
import com.tngtech.archunit.core.domain.JavaCodeUnit;
import com.tngtech.archunit.core.domain.JavaType;
import com.tngtech.archunit.core.domain.SourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasOwner;
import com.tngtech.archunit.core.domain.properties.HasSourceCodeLocation;
import com.tngtech.archunit.core.domain.properties.HasType;
import com.tngtech.archunit.thirdparty.com.google.common.base.MoreObjects;
import com.tngtech.archunit.thirdparty.com.google.common.base.Preconditions;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public final class ReferencedClassObject
implements HasType,
HasOwner<JavaCodeUnit>,
HasSourceCodeLocation {
    private final JavaCodeUnit owner;
    private final JavaClass value;
    private final SourceCodeLocation sourceCodeLocation;
    private final boolean declaredInLambda;

    private ReferencedClassObject(JavaCodeUnit owner, JavaClass value, int lineNumber, boolean declaredInLambda) {
        this.owner = Preconditions.checkNotNull(owner);
        this.value = Preconditions.checkNotNull(value);
        this.sourceCodeLocation = SourceCodeLocation.of(owner.getOwner(), lineNumber);
        this.declaredInLambda = declaredInLambda;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaType getType() {
        return this.getRawType();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getRawType() {
        return this.value;
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaCodeUnit getOwner() {
        return this.owner;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public JavaClass getValue() {
        return this.value;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public int getLineNumber() {
        return this.sourceCodeLocation.getLineNumber();
    }

    @Override
    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public SourceCodeLocation getSourceCodeLocation() {
        return this.sourceCodeLocation;
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public boolean isDeclaredInLambda() {
        return this.declaredInLambda;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("owner", this.owner).add("value", this.value).add("sourceCodeLocation", this.sourceCodeLocation).add("declaredInLambda", this.declaredInLambda).toString();
    }

    static ReferencedClassObject from(JavaCodeUnit owner, JavaClass javaClass, int lineNumber, boolean declaredInLambda) {
        return new ReferencedClassObject(owner, javaClass, lineNumber, declaredInLambda);
    }

    @PublicAPI(usage=PublicAPI.Usage.ACCESS)
    public static final class Functions {
        @PublicAPI(usage=PublicAPI.Usage.ACCESS)
        public static final ChainableFunction<ReferencedClassObject, JavaClass> GET_VALUE = new ChainableFunction<ReferencedClassObject, JavaClass>(){

            @Override
            public JavaClass apply(ReferencedClassObject input) {
                return input.getValue();
            }
        };

        private Functions() {
        }
    }
}

