/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map.outline;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.FontMetrics;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.core.ui.components.DoubleTextIcon;
import org.freeplane.core.ui.components.StyledIcon;
import org.freeplane.core.ui.components.TextIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.core.util.ObjectRule;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.edge.AutomaticEdgeStyle;
import org.freeplane.view.swing.map.edge.EdgeColorContext;
import org.freeplane.view.swing.map.outline.MapAwareOutlinePane;
import org.freeplane.view.swing.map.outline.OutlinePane;
import org.freeplane.view.swing.map.outline.TreeNode;

class MapTreeNode
extends TreeNode
implements INodeView,
EdgeColorContext {
    private final NodeModel nodeModel;
    private final OutlinePane outlinePane;
    private final NodeStyleController styleController;
    private final Color mapBackground;

    MapTreeNode(NodeModel nodeModel, OutlinePane outlinePane, NodeStyleController styleController, Color mapBackground) {
        super(nodeModel.createID(), null);
        this.nodeModel = nodeModel;
        this.outlinePane = outlinePane;
        this.styleController = styleController;
        this.mapBackground = mapBackground;
        this.setTitleSupplier(this::getNodeText);
    }

    public MapTreeNode(MapTreeNode parent, NodeModel child) {
        this(child, parent.outlinePane, parent.styleController, parent.mapBackground);
        parent.addChild(this);
    }

    MapTreeNode createNode(NodeModel node) {
        return new MapTreeNode(node, this.outlinePane, this.styleController, this.mapBackground);
    }

    NodeModel getNodeModel() {
        return this.nodeModel;
    }

    private String getNodeText() {
        String shortPlainText = TextController.getController().getShortPlainText(this.nodeModel).trim();
        return shortPlainText.isEmpty() ? "--" : shortPlainText;
    }

    @Override
    public void nodeChanged(NodeChangeEvent event) {
        if (event.getNode() == this.nodeModel) {
            this.update();
            SwingUtilities.invokeLater(() -> this.outlinePane.updateNodeTitleLater(this));
        }
    }

    @Override
    public boolean hasStandardLayoutWithRootNode(NodeModel root) {
        return false;
    }

    @Override
    public boolean isTopOrLeft() {
        return true;
    }

    void cleanupListeners() {
        if (this.nodeModel != null) {
            this.nodeModel.removeViewer(this);
        }
        for (TreeNode child : this.getChildren()) {
            if (!(child instanceof MapTreeNode)) continue;
            ((MapTreeNode)child).cleanupListeners();
        }
    }

    boolean isContainedIn(MapAwareOutlinePane pane) {
        return pane == this.outlinePane;
    }

    public Icon createIcon(JComponent component, boolean usesColoredOutlineItems, boolean showsFoldingStatus) {
        StyledIcon icon;
        String text = this.getTitle();
        FontMetrics fontMetrics = component.getFontMetrics(component.getFont());
        if (showsFoldingStatus && this.nodeModel.hasChildren()) {
            ComponentOrientation componentOrientation = component.getComponentOrientation();
            String childrenHint = componentOrientation.isHorizontal() && !componentOrientation.isLeftToRight() ? (this.isExpanded() ? "- " : "+ ") : (this.isExpanded() ? " -" : " +");
            DoubleTextIcon doubleTextIcon = new DoubleTextIcon(childrenHint, text, fontMetrics);
            doubleTextIcon.setUnderlinePosition(DoubleTextIcon.UnderlinePosition.RIGHT);
            icon = doubleTextIcon;
        } else {
            TextIcon textIcon = new TextIcon(text, fontMetrics);
            textIcon.setBorderType(TextIcon.BorderType.UNDERLINE);
            icon = textIcon;
        }
        icon.setPaddingX((int)(3.0f * UITools.FONT_SCALE_FACTOR));
        icon.setBorderStroke(TextIcon.DEFAULT_STROKE);
        if (usesColoredOutlineItems) {
            Color color = this.styleController.getColor(this.nodeModel, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            Color backgroundColor = this.styleController.getBackgroundColor(this.nodeModel, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            if (backgroundColor != null) {
                if (backgroundColor.getAlpha() < 255) {
                    backgroundColor = ColorUtils.blendColors(backgroundColor, this.mapBackground);
                }
            } else {
                backgroundColor = this.mapBackground;
            }
            icon.setIconTextColor(color);
            icon.setIconBackgroundColor(backgroundColor);
            if (icon.getBorderStroke() != null) {
                icon.setIconBorderColor(this.determineBorderColor());
            }
        }
        return icon;
    }

    private Color determineBorderColor() {
        boolean borderMatchesEdgeColor;
        Boolean matches = this.styleController.getBorderColorMatchesEdgeColor(this.nodeModel, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        boolean bl = borderMatchesEdgeColor = matches != null && matches != false;
        if (!borderMatchesEdgeColor) {
            Color explicitBorderColor = this.styleController.getBorderColor(this.nodeModel, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            return explicitBorderColor != null ? explicitBorderColor : EdgeController.STANDARD_EDGE_COLOR;
        }
        return this.resolveEdgeColor();
    }

    private Color resolveEdgeColor() {
        ModeController modeController = this.styleController.getModeController();
        if (modeController == null) {
            return EdgeController.STANDARD_EDGE_COLOR;
        }
        EdgeController edgeController = modeController.getExtension(EdgeController.class);
        if (edgeController == null) {
            return EdgeController.STANDARD_EDGE_COLOR;
        }
        ObjectRule<Color, EdgeController.Rules> colorRule = edgeController.getColorRule(this.nodeModel, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
        AutomaticEdgeStyle edgeStyle = new AutomaticEdgeStyle(modeController, this.nodeModel.getMap(), this);
        return edgeStyle.resolve(colorRule);
    }

    private MapView findMapView() {
        if (this.outlinePane instanceof MapAwareOutlinePane) {
            return ((MapAwareOutlinePane)this.outlinePane).getCurrentMapView();
        }
        return null;
    }

    private NodeView findNodeView() {
        return this.findNodeView(this.nodeModel);
    }

    private NodeView findNodeView(NodeModel node) {
        MapView mapView = this.findMapView();
        if (mapView == null || node == null) {
            return null;
        }
        return mapView.getNodeView(node);
    }

    @Override
    public int computeColumnPaletteIndex() {
        NodeView nodeView = this.findNodeView();
        if (nodeView != null) {
            return nodeView.computeColumnPaletteIndex();
        }
        return this.getLevel();
    }

    @Override
    public int computeBranchPaletteIndex() {
        NodeView nodeView = this.findNodeView();
        if (nodeView != null) {
            return nodeView.computeBranchPaletteIndex();
        }
        NodeModel parentNode = this.nodeModel.getParentNode();
        if (parentNode == null || !parentNode.isRoot()) {
            return 0;
        }
        return parentNode.getIndex(this.nodeModel) + 1;
    }

    @Override
    public int computeLevelPaletteIndex() {
        NodeView nodeView = this.findNodeView();
        if (nodeView != null) {
            return nodeView.computeLevelPaletteIndex();
        }
        MapView mapView = this.findMapView();
        int baseLevel = mapView != null ? this.nodeModel.getNodeLevel(mapView.getFilter()) : this.nodeModel.getNodeLevel();
        return baseLevel + (this.nodeModel.isHiddenSummary() ? 1 : 0);
    }

    @Override
    public Color getParentEdgeColor() {
        NodeView nodeView = this.findNodeView();
        if (nodeView != null) {
            return nodeView.getParentEdgeColor();
        }
        NodeModel parentNode = this.nodeModel.getParentNode();
        if (parentNode == null) {
            return null;
        }
        NodeView parentView = this.findNodeView(parentNode);
        if (parentView != null) {
            return parentView.getEdgeColor();
        }
        TreeNode parentTreeNode = this.getParent();
        if (parentTreeNode instanceof MapTreeNode) {
            return ((MapTreeNode)parentTreeNode).resolveEdgeColor();
        }
        return null;
    }
}

