/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.os;

import com.jogamp.common.ExceptionUtils;
import com.jogamp.common.os.DynamicLinker;
import com.jogamp.common.os.DynamicLookupHelper;
import com.jogamp.common.os.Platform;
import com.jogamp.common.util.ArrayHashSet;
import com.jogamp.common.util.IOUtil;
import com.jogamp.common.util.SecurityUtil;
import com.jogamp.common.util.cache.TempJarCache;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.StringTokenizer;
import jogamp.common.os.BionicDynamicLinker32bitImpl;
import jogamp.common.os.BionicDynamicLinker64BitImpl;
import jogamp.common.os.DynamicLinkerImpl;
import jogamp.common.os.MacOSXDynamicLinkerImpl;
import jogamp.common.os.PlatformPropsImpl;
import jogamp.common.os.PosixDynamicLinkerImpl;
import jogamp.common.os.WindowsDynamicLinkerImpl;

public final class NativeLibrary
implements DynamicLookupHelper {
    private static final String[] prefixes;
    private static final String[] suffixes;
    private static final boolean isOSX;
    private static String sys_env_lib_path_varname;
    private final DynamicLinker dynLink;
    private long libraryHandle;
    private final LibPath libraryPath;
    private final String nativeLibraryPath;
    private final boolean global;
    private static boolean initializedFindLibraryMethod;
    private static Method findLibraryMethod;

    private NativeLibrary(DynamicLinker dynamicLinker, long l, LibPath libPath, boolean bl, String string) {
        this.dynLink = dynamicLinker;
        this.libraryHandle = l;
        this.libraryPath = libPath;
        this.nativeLibraryPath = dynamicLinker.lookupLibraryPathname(l, string);
        this.global = bl;
        if (DEBUG) {
            System.err.println("NativeLibrary.open(): Successfully loaded: " + this);
        }
    }

    public final String toString() {
        String string = null != this.nativeLibraryPath ? ", native '" + this.nativeLibraryPath + "'" : "";
        return "NativeLibrary[" + this.dynLink.getClass().getSimpleName() + ", path[given '" + this.libraryPath + "'" + string + "], 0x" + Long.toHexString(this.libraryHandle) + ", global " + this.global + "]";
    }

    public static final String getSystemEnvLibraryPathVarname() {
        return sys_env_lib_path_varname;
    }

    public static final String getSystemEnvLibraryPaths() {
        return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getenv(NativeLibrary.getSystemEnvLibraryPathVarname());
            }
        });
    }

    public static final String getJogAmpPrimaryLibraryPaths() {
        return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("jogamp.primary.library.path");
            }
        });
    }

    private static final String getJavaLibrarySystemPaths() {
        return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string = System.getProperty("sun.boot.library.path");
                if (null != string && !string.isEmpty()) {
                    return string;
                }
                return null;
            }
        });
    }

    private static final String getJavaLibraryUserPaths() {
        return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String string = System.getProperty("java.library.path");
                if (null != string && !string.isEmpty()) {
                    return string;
                }
                return null;
            }
        });
    }

    private static final String getJavaCurrentWorkingDir() {
        return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty("user.dir");
            }
        });
    }

    public static final NativeLibrary open(String string, boolean bl, boolean bl2, ClassLoader classLoader, boolean bl3) throws SecurityException {
        return NativeLibrary.open(string, string, string, bl, bl2, classLoader, bl3, null);
    }

    public static final NativeLibrary open(String string, boolean bl, boolean bl2, ClassLoader classLoader, boolean bl3, String string2) throws SecurityException {
        return NativeLibrary.open(string, string, string, bl, bl2, classLoader, bl3, string2);
    }

    public static final NativeLibrary open(String string, String string2, String string3, boolean bl, boolean bl2, ClassLoader classLoader, boolean bl3, String string4) throws SecurityException {
        List<LibPath> list = NativeLibrary.enumerateLibraryPaths(string, string2, string3, bl, bl2, classLoader);
        Platform.initSingleton();
        DynamicLinker dynamicLinker = NativeLibrary.getDynamicLinker();
        for (LibPath libPath : list) {
            String string5;
            long l;
            if (DEBUG) {
                System.err.println("NativeLibrary.open(global " + bl3 + "): Trying to load " + libPath);
            }
            Throwable throwable = null;
            try {
                l = bl3 ? dynamicLinker.openLibraryGlobal(libPath, DEBUG) : dynamicLinker.openLibraryLocal(libPath, DEBUG);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                l = 0L;
            }
            if (0L != l) {
                return new NativeLibrary(dynamicLinker, l, libPath, bl3, string4);
            }
            if (!DEBUG) continue;
            if (null != throwable) {
                System.err.println("NativeLibrary.open: Caught " + throwable.getClass().getSimpleName() + ": " + throwable.getMessage());
            }
            try {
                string5 = dynamicLinker.getLastError();
            }
            catch (Throwable throwable3) {
                string5 = null;
            }
            System.err.println("NativeLibrary.open: Last error " + string5);
            if (null == throwable) continue;
            throwable.printStackTrace();
        }
        if (DEBUG) {
            System.err.println("NativeLibrary.open(global " + bl3 + "): Did not succeed in loading (" + string + ", " + string2 + ", " + string3 + ")");
        }
        return null;
    }

    @Override
    public final void claimAllLinkPermission() throws SecurityException {
        this.dynLink.claimAllLinkPermission();
    }

    @Override
    public final void releaseAllLinkPermission() throws SecurityException {
        this.dynLink.releaseAllLinkPermission();
    }

    @Override
    public final long dynamicLookupFunction(String string) throws SecurityException {
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library is not open");
        }
        return this.dynLink.lookupSymbol(this.libraryHandle, string);
    }

    @Override
    public final boolean isFunctionAvailable(String string) throws SecurityException {
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library is not open");
        }
        return 0L != this.dynLink.lookupSymbol(this.libraryHandle, string);
    }

    public final long dynamicLookupFunctionGlobal(String string) throws SecurityException {
        return this.dynLink.lookupSymbolGlobal(string);
    }

    final DynamicLinker dynamicLinker() {
        return this.dynLink;
    }

    static DynamicLinker getDynamicLinker() {
        DynamicLinkerImpl dynamicLinkerImpl;
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                dynamicLinkerImpl = new WindowsDynamicLinkerImpl();
                break;
            }
            case MACOS: 
            case IOS: {
                dynamicLinkerImpl = new MacOSXDynamicLinkerImpl();
                break;
            }
            case ANDROID: {
                if (PlatformPropsImpl.CPU_ARCH.is32Bit) {
                    dynamicLinkerImpl = new BionicDynamicLinker32bitImpl();
                    break;
                }
                dynamicLinkerImpl = new BionicDynamicLinker64BitImpl();
                break;
            }
            default: {
                dynamicLinkerImpl = new PosixDynamicLinkerImpl();
            }
        }
        return dynamicLinkerImpl;
    }

    public final long getLibraryHandle() {
        return this.libraryHandle;
    }

    @Override
    public final boolean isOpen() {
        return 0L != this.libraryHandle;
    }

    public final String getLibraryPath() {
        return this.libraryPath.path;
    }

    public final LibPath getLibPath() {
        return this.libraryPath;
    }

    public final String getNativeLibraryPath() {
        return this.nativeLibraryPath;
    }

    public final void close() throws SecurityException {
        if (DEBUG) {
            System.err.println("NativeLibrary.close(): closing " + this);
        }
        if (0L == this.libraryHandle) {
            throw new RuntimeException("Library already closed");
        }
        long l = this.libraryHandle;
        this.libraryHandle = 0L;
        this.dynLink.closeLibrary(l, DEBUG);
        if (DEBUG) {
            System.err.println("NativeLibrary.close(): Successfully closed " + this);
            ExceptionUtils.dumpStack(System.err);
        }
    }

    public static final String isValidNativeLibraryName(String string, boolean bl) {
        int n;
        String string2;
        try {
            string2 = IOUtil.getBasename(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        String string3 = bl ? string2 : string2.toLowerCase();
        int n2 = -1;
        for (n = 0; n < prefixes.length && 0 > n2; ++n) {
            if (!string3.startsWith(prefixes[n])) continue;
            n2 = n;
        }
        if (0 <= n2) {
            for (n = 0; n < suffixes.length; ++n) {
                if (!string3.endsWith(suffixes[n])) continue;
                int n3 = prefixes[n2].length();
                int n4 = suffixes[n].length();
                return string2.substring(n3, string2.length() - n4);
            }
        }
        return null;
    }

    public static final List<LibPath> enumerateLibraryPaths(String string, String string2, String string3, ClassLoader classLoader) {
        return NativeLibrary.enumerateLibraryPaths(string, string2, string3, false, false, classLoader);
    }

    public static final List<LibPath> enumerateLibraryPaths(String string, String string2, String string3, boolean bl, ClassLoader classLoader) {
        return NativeLibrary.enumerateLibraryPaths(string, string2, string3, true, bl, classLoader);
    }

    private static final List<LibPath> enumerateLibraryPaths(String string, String string2, String string3, boolean bl, boolean bl2, ClassLoader classLoader) {
        Object object;
        File file;
        ArrayHashSet<LibPath> arrayHashSet = new ArrayHashSet<LibPath>(false, 16, 0.75f);
        String string4 = NativeLibrary.selectName(string, string2, string3);
        if (string4 == null || string4.isEmpty()) {
            if (DEBUG) {
                System.err.println("NativeLibrary.enumerateLibraryPaths: empty, no libName selected");
            }
            return arrayHashSet.getData();
        }
        if (DEBUG) {
            System.err.println("NativeLibrary.enumerateLibraryPaths: libName '" + string4 + "'");
        }
        if ((file = new File(string4)).isAbsolute()) {
            try {
                object = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                System.err.println("NativeLibrary.enumerateLibraryPaths: absolute path: Exception " + iOException.getMessage() + ", from path '" + string4 + "'");
                return arrayHashSet.getData();
            }
            if (((File)object).exists()) {
                LibPath libPath = LibPath.createExtra(((File)object).getPath(), ((File)object).getParent());
                if (arrayHashSet.add(libPath) && DEBUG) {
                    System.err.println("NativeLibrary.enumerateLibraryPaths: absolute path: Done, found '" + libPath + "'");
                }
                return arrayHashSet.getData();
            }
        }
        object = NativeLibrary.buildNames(string4);
        if (DEBUG) {
            System.err.println("NativeLibrary.enumerateLibraryPaths: baseNames: " + Arrays.toString((Object[])object));
        }
        NativeLibrary.addMultiLibPathsLibraries("jogamp.primary.library", NativeLibrary.getJogAmpPrimaryLibraryPaths(), string4, (String[])object, arrayHashSet, true);
        if (bl2) {
            if (bl) {
                NativeLibrary.addOSSystemLibraryPaths(string4, (String[])object, arrayHashSet);
            }
            NativeLibrary.addClassLoaderPaths(string4, arrayHashSet, classLoader);
            NativeLibrary.addMultiLibPathsLibraries("sun.boot.library", NativeLibrary.getJavaLibrarySystemPaths(), string4, (String[])object, arrayHashSet, true);
        }
        NativeLibrary.addMultiLibPathsLibraries("java.library", NativeLibrary.getJavaLibraryUserPaths(), string4, (String[])object, arrayHashSet, true);
        String string5 = NativeLibrary.getJavaCurrentWorkingDir();
        if (null != string5 && !string5.isEmpty()) {
            NativeLibrary.addCanonicalPaths("add.user.dir.std", string5, (String[])object, arrayHashSet, true);
            NativeLibrary.addCanonicalPaths("add.user.dir.fat", string5 + File.separator + "natives" + File.separator + PlatformPropsImpl.os_and_arch, (String[])object, arrayHashSet, true);
        }
        if (!bl2) {
            NativeLibrary.addMultiLibPathsLibraries("sun.boot.library", NativeLibrary.getJavaLibrarySystemPaths(), string4, (String[])object, arrayHashSet, true);
            NativeLibrary.addClassLoaderPaths(string4, arrayHashSet, classLoader);
            if (bl) {
                NativeLibrary.addOSSystemLibraryPaths(string4, (String[])object, arrayHashSet);
            }
        }
        if (DEBUG) {
            System.err.println("NativeLibrary.enumerateLibraryPaths: done: " + arrayHashSet.toString());
        }
        return arrayHashSet.getData();
    }

    private static final void addOSSystemLibraryPaths(String string, String[] stringArray, List<LibPath> list) {
        NativeLibrary.addMultiLibPathsLibraries("system", NativeLibrary.getSystemEnvLibraryPaths(), string, stringArray, list, false);
        for (int i = 0; i < stringArray.length; ++i) {
            LibPath libPath = LibPath.createRelative(stringArray[i]);
            if (!list.add(libPath) || !DEBUG) continue;
            System.err.println("NativeLibrary.enumerateLibraryPaths: add.ssp_default: " + libPath);
        }
        if (isOSX) {
            NativeLibrary.addCanonicalPaths("add.ssp_1st_macos_old", "/Library/Frameworks/" + string + ".framework", stringArray, list, false);
            NativeLibrary.addCanonicalPaths("add.ssp_1st_macos_cur", "/System/Library/Frameworks/" + string + ".framework", stringArray, list, false);
        }
    }

    private static final void addClassLoaderPaths(String string, List<LibPath> list, ClassLoader classLoader) {
        LibPath libPath;
        String string2 = NativeLibrary.findLibrary(string, classLoader);
        if (string2 != null && list.add(libPath = LibPath.createAbsolute(string2)) && DEBUG) {
            System.err.println("NativeLibrary.enumerateLibraryPaths: add.clp: " + string2);
        }
    }

    private static final void addMultiLibPathsLibraries(String string, String string2, String string3, String[] stringArray, List<LibPath> list, boolean bl) {
        if (null == string2 || string2.isEmpty()) {
            return;
        }
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            NativeLibrary.addAbstractPaths("add." + string + ".path_" + n, stringTokenizer.nextToken(), stringArray, list, bl);
            ++n;
        }
    }

    private static final void addAbstractPaths(String string, String string2, String[] stringArray, List<LibPath> list, boolean bl) {
        if (null == string2 || string2.isEmpty()) {
            return;
        }
        NativeLibrary.addCanonicalPaths(string, new File(string2), stringArray, list, bl);
    }

    private static final void addCanonicalPaths(String string, String string2, String[] stringArray, List<LibPath> list, boolean bl) {
        if (null == string2 || string2.isEmpty()) {
            return;
        }
        NativeLibrary.addCanonicalPaths(string, new File(string2), stringArray, list, bl);
    }

    private static final void addCanonicalPaths(String string, File file, String[] stringArray, List<LibPath> list, boolean bl) {
        for (int i = 0; i < stringArray.length; ++i) {
            LibPath libPath;
            File file2;
            String string2 = file.getPath() + File.separator + stringArray[i];
            try {
                file2 = new File(string2).getCanonicalFile();
            }
            catch (IOException iOException) {
                System.err.println("NativeLibrary.addCanonicalPaths: " + string + ": Exception " + iOException.getMessage() + ", from path '" + string2 + "'");
                return;
            }
            if (!file2.exists()) continue;
            LibPath libPath2 = libPath = bl ? LibPath.createExtra(file2.getPath(), file2.getParent()) : LibPath.createAbsolute(file2.getPath());
            if (!list.add(libPath) || !DEBUG) continue;
            System.err.println("NativeLibrary.addCanonicalPaths: " + string + ": Added " + libPath + ", from path '" + string2 + "'");
        }
    }

    private static final String selectName(String string, String string2, String string3) {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                return string;
            }
            case MACOS: 
            case IOS: {
                return string3;
            }
        }
        return string2;
    }

    private static final String[] buildNames(String string) {
        int n;
        int n2;
        int n3;
        int n4;
        String string2;
        try {
            string2 = IOUtil.getBasename(string).toLowerCase();
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException(uRISyntaxException);
        }
        int n5 = -1;
        for (n4 = 0; n4 < prefixes.length && 0 > n5; ++n4) {
            if (!string2.startsWith(prefixes[n4])) continue;
            n5 = n4;
        }
        if (0 <= n5) {
            for (n4 = 0; n4 < suffixes.length; ++n4) {
                if (!string2.endsWith(suffixes[n4])) continue;
                return new String[]{string};
            }
            n4 = -1;
            for (n3 = 0; n3 < suffixes.length && 0 > n4; ++n3) {
                n4 = string2.indexOf(suffixes[n3]);
            }
            n3 = 1;
            if (n4 >= 0) {
                for (n2 = n4 + suffixes[0].length(); n2 < string.length(); ++n2) {
                    n = string.charAt(n2);
                    if (n == 46 || n >= 48 && n <= 57) continue;
                    n3 = 0;
                    break;
                }
                if (n3 != 0) {
                    return new String[]{string};
                }
            }
        }
        String[] stringArray = new String[prefixes.length * suffixes.length + (isOSX ? 1 : 0)];
        n3 = 0;
        for (n2 = 0; n2 < prefixes.length; ++n2) {
            for (n = 0; n < suffixes.length; ++n) {
                stringArray[n3++] = prefixes[n2] + string + suffixes[n];
            }
        }
        if (isOSX) {
            stringArray[n3++] = string;
        }
        return stringArray;
    }

    private static final String findLibraryImpl(final String string, final ClassLoader classLoader) {
        block6: {
            if (PlatformPropsImpl.JAVA_9) {
                return null;
            }
            if (classLoader == null) {
                return null;
            }
            if (!initializedFindLibraryMethod) {
                SecurityUtil.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        try {
                            findLibraryMethod = ClassLoader.class.getDeclaredMethod("findLibrary", String.class);
                            findLibraryMethod.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        initializedFindLibraryMethod = true;
                        return null;
                    }
                });
            }
            if (findLibraryMethod != null) {
                try {
                    return SecurityUtil.doPrivileged(new PrivilegedAction<String>(){

                        @Override
                        public String run() {
                            try {
                                return (String)findLibraryMethod.invoke((Object)classLoader, string);
                            }
                            catch (Exception exception) {
                                throw new RuntimeException(exception);
                            }
                        }
                    });
                }
                catch (Exception exception) {
                    if (!DEBUG) break block6;
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    public static final String findLibrary(String string, ClassLoader classLoader) {
        String string2 = null;
        if (TempJarCache.isInitialized(true)) {
            string2 = TempJarCache.findLibrary(string);
            if (DEBUG) {
                System.err.println("NativeLibrary.findLibrary(<" + string + ">) (TempJarCache): " + string2);
            }
        }
        if (null == string2) {
            string2 = NativeLibrary.findLibraryImpl(string, classLoader);
            if (DEBUG) {
                System.err.println("NativeLibrary.findLibrary(<" + string + ">, " + classLoader + ") (CL): " + string2);
            }
        }
        return string2;
    }

    static {
        switch (PlatformPropsImpl.OS_TYPE) {
            case WINDOWS: {
                prefixes = new String[]{""};
                suffixes = new String[]{".dll"};
                sys_env_lib_path_varname = "PATH";
                isOSX = false;
                break;
            }
            case MACOS: 
            case IOS: {
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".dylib"};
                sys_env_lib_path_varname = "DYLD_LIBRARY_PATH";
                isOSX = true;
                break;
            }
            default: {
                prefixes = new String[]{"lib"};
                suffixes = new String[]{".so"};
                sys_env_lib_path_varname = "LD_LIBRARY_PATH";
                isOSX = false;
            }
        }
        initializedFindLibraryMethod = false;
        findLibraryMethod = null;
    }

    public static class LibPath {
        public final String path;
        public final boolean isAbsolute;
        public final boolean addToSearchPath;
        public final String searchPathPrepend;
        private final int fixedHashCode;

        public static LibPath createRelative(String string) {
            return new LibPath(string, false, false, null);
        }

        public static LibPath createAbsolute(String string) {
            return new LibPath(string, true, false, null);
        }

        public static LibPath createExtra(String string, String string2) {
            return new LibPath(string, true, true, string2);
        }

        private LibPath(String string, boolean bl, boolean bl2, String string2) {
            this.path = string;
            this.isAbsolute = bl;
            this.addToSearchPath = bl2;
            this.searchPathPrepend = string2;
            this.fixedHashCode = this.calcHashCode();
        }

        private int calcHashCode() {
            int n = this.path.hashCode();
            if (null != this.searchPathPrepend) {
                n = (n << 5) - n + this.searchPathPrepend.hashCode();
            }
            n = (n << 5) - n + (this.isAbsolute ? 1 : 0);
            n = (n << 5) - n + (this.addToSearchPath ? 1 : 0);
            return n;
        }

        public int hashCode() {
            return this.fixedHashCode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof LibPath)) {
                return false;
            }
            LibPath libPath = (LibPath)object;
            return this.path.equals(libPath.path) && this.isAbsolute == libPath.isAbsolute && this.addToSearchPath == libPath.addToSearchPath && (this.searchPathPrepend == null && libPath.searchPathPrepend == null || this.searchPathPrepend != null && libPath.searchPathPrepend != null && this.searchPathPrepend.equals(libPath.searchPathPrepend));
        }

        public String toString() {
            return "LibPath['" + this.path + "', " + (this.isAbsolute ? "abs" : "rel") + ", " + (this.addToSearchPath ? "xsp " + this.searchPathPrepend : "sys") + "]";
        }
    }
}

