/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Merges several Label Maps.


This filter takes one or more input Label Map and merges them.

SetMethod() can be used to change how the filter manage the labels from the
different label maps. KEEP (0): MergeLabelMapFilter do its best to keep the label unchanged, but if a label is already
used in a previous label map, a new label is assigned. AGGREGATE (1):
If the same label is found several times in the label maps, the label
objects with the same label are merged. PACK (2): MergeLabelMapFilter relabel all the label objects by order of processing. No conflict can
occur. STRICT (3): MergeLabelMapFilter keeps the labels unchanged and raises an exception if the same label
is found in several images.

This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , RelabelComponentImageFilter

 itk::simple::MergeLabelMapFilter for the procedural interface


C++ includes: sitkMergeLabelMapFilter.h
*/
public class MergeLabelMapFilter extends ImageFilter {
  private transient long swigCPtr;

  protected MergeLabelMapFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.MergeLabelMapFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MergeLabelMapFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MergeLabelMapFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::MergeLabelMapFilter::~MergeLabelMapFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_MergeLabelMapFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::MergeLabelMapFilter::MergeLabelMapFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  MergeLabelMapFilter() {
    this(SimpleITKJNI.new_MergeLabelMapFilter(), true);
  }

  /**
Self&amp; itk::simple::MergeLabelMapFilter::SetMethod(MethodType Method)

Set/Get the method used to merge the label maps

*/
public  void setMethod(MergeLabelMapFilter.MethodType Method) {
    SimpleITKJNI.MergeLabelMapFilter_setMethod(swigCPtr, this, Method.swigValue());
  }

  /**
MethodType itk::simple::MergeLabelMapFilter::GetMethod() const

Set/Get the method used to merge the label maps

*/
public  MergeLabelMapFilter.MethodType getMethod() {
    return MergeLabelMapFilter.MethodType.swigToEnum(SimpleITKJNI.MergeLabelMapFilter_getMethod(swigCPtr, this));
  }

  /**
std::string itk::simple::MergeLabelMapFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.MergeLabelMapFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::MergeLabelMapFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.MergeLabelMapFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::MergeLabelMapFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(VectorOfImage images) {
    return new Image(SimpleITKJNI.MergeLabelMapFilter_execute__SWIG_0(swigCPtr, this, VectorOfImage.getCPtr(images), images), true);
  }

  /**
Image itk::simple::MergeLabelMapFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.MergeLabelMapFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::MergeLabelMapFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.MergeLabelMapFilter_execute__SWIG_2(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::MergeLabelMapFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.MergeLabelMapFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  /**
Image itk::simple::MergeLabelMapFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.MergeLabelMapFilter_execute__SWIG_4(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  /**
Image itk::simple::MergeLabelMapFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.MergeLabelMapFilter_execute__SWIG_5(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

  public final static class MethodType {
    public final static MergeLabelMapFilter.MethodType Keep = new MergeLabelMapFilter.MethodType("Keep");
    public final static MergeLabelMapFilter.MethodType Aggregate = new MergeLabelMapFilter.MethodType("Aggregate");
    public final static MergeLabelMapFilter.MethodType Pack = new MergeLabelMapFilter.MethodType("Pack");
    public final static MergeLabelMapFilter.MethodType Strict = new MergeLabelMapFilter.MethodType("Strict");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static MethodType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + MethodType.class + " with value " + swigValue);
    }

    private MethodType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private MethodType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private MethodType(String swigName, MethodType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static MethodType[] swigValues = { Keep, Aggregate, Pack, Strict };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
