/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import org.keycloak.models.ClientScopeModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.protocol.LoginProtocol;
import org.keycloak.protocol.LoginProtocolFactory;

public class DefaultClientScopes {
    public static void createDefaultClientScopes(KeycloakSession session, RealmModel realm, boolean addScopesToExistingClients) {
        session.getKeycloakSessionFactory().getProviderFactoriesStream(LoginProtocol.class).map(LoginProtocolFactory.class::cast).forEach(lpf -> lpf.createDefaultClientScopes(realm, addScopesToExistingClients));
    }

    public static void createOfflineAccessClientScope(RealmModel newRealm, RoleModel offlineRole) {
        ClientScopeModel offlineAccessScope = newRealm.addClientScope("offline_access");
        offlineAccessScope.setDescription("OpenID Connect built-in scope: offline_access");
        offlineAccessScope.setDisplayOnConsentScreen(true);
        offlineAccessScope.setConsentScreenText("${offlineAccessScopeConsentText}");
        offlineAccessScope.setProtocol("openid-connect");
        offlineAccessScope.addScopeMapping(offlineRole);
        newRealm.addDefaultClientScope(offlineAccessScope, false);
    }
}

