/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.quarkus.gizmo2.Const;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.creator.BlockCreator;
import io.quarkus.gizmo2.creator.CaseCreator;
import io.quarkus.gizmo2.creator.SwitchCreator;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.constant.ConstImpl;
import io.quarkus.gizmo2.impl.constant.VoidConst;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class SwitchCreatorImpl<C extends ConstImpl>
extends Item
implements SwitchCreator {
    static final double TABLESWITCH_DENSITY = 0.9;
    final BlockCreatorImpl enclosing;
    final Item switchVal;
    final ClassDesc type;
    final Class<C> constantType;
    final Map<C, CaseCreatorImpl> casesByConstant = new LinkedHashMap<C, CaseCreatorImpl>();
    final List<CaseCreatorImpl> cases = new ArrayList<CaseCreatorImpl>();
    BlockCreatorImpl default_;
    int min;
    int max;
    boolean fallThrough;
    boolean done;

    SwitchCreatorImpl(BlockCreatorImpl enclosing, Expr switchVal, ClassDesc type, Class<C> constantType) {
        this.enclosing = enclosing;
        this.switchVal = (Item)switchVal;
        this.type = type;
        this.constantType = constantType;
        if (!type.equals(ConstantDescs.CD_void)) {
            this.fallThrough = true;
        }
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.switchVal.process(node.prev(), op);
    }

    public BlockCreatorImpl enclosing() {
        return this.enclosing;
    }

    public Expr switchVal() {
        return this.switchVal;
    }

    @Override
    public boolean mayFallThrough() {
        return this.fallThrough;
    }

    @Override
    public final ClassDesc type() {
        return this.type;
    }

    abstract int staticHash(C var1);

    abstract void hash(CodeBuilder var1);

    void accept(Consumer<? super SwitchCreatorImpl<C>> builder) {
        try {
            builder.accept(this);
            if (this.default_ == null) {
                if (!this.type.equals(ConstantDescs.CD_void)) {
                    throw new IllegalStateException("Missing default branch on switch expression");
                }
                this.fallThrough = true;
                if (this.cases.isEmpty()) {
                    throw new IllegalStateException("No case branch and no default branch on switch");
                }
            }
        }
        finally {
            this.done = true;
        }
    }

    @Override
    public void default_(Consumer<BlockCreator> body) {
        if (this.done) {
            throw new IllegalStateException("Cannot add new cases");
        }
        if (this.default_ != null) {
            throw new IllegalStateException("Default case was already added");
        }
        this.default_ = new BlockCreatorImpl(this.enclosing, VoidConst.INSTANCE, this.type());
        body.accept(this.default_);
        if (this.default_.mayFallThrough()) {
            this.fallThrough = true;
        }
    }

    @Override
    public void case_(Consumer<CaseCreator> builder) {
        if (this.done) {
            throw new IllegalStateException("Cannot add new cases");
        }
        CaseCreatorImpl cci = new CaseCreatorImpl(this.enclosing, this.type);
        builder.accept(cci);
        if (cci.state < 3) {
            throw new IllegalStateException("Case does not have a body");
        }
        this.cases.add(cci);
    }

    CaseCreatorImpl findCase(Const val) {
        return this.constantType.isInstance(val) ? this.casesByConstant.get(this.constantType.cast(val)) : null;
    }

    BlockCreatorImpl findDefault() {
        return this.default_;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean contains(BlockCreatorImpl block) {
        if (this.default_ != null) {
            if (this.default_.contains(block)) return true;
        }
        if (!this.cases.stream().map(CaseCreatorImpl.class::cast).map(CaseCreatorImpl::body).anyMatch(b -> b.contains(block))) return false;
        return true;
    }

    public final class CaseCreatorImpl
    implements CaseCreator {
        private static final int ST_INITIAL = 0;
        private static final int ST_CASE_VALS = 1;
        private static final int ST_BODY = 2;
        private static final int ST_DONE = 3;
        final BlockCreatorImpl body;
        int state = 0;

        CaseCreatorImpl(BlockCreatorImpl parent, ClassDesc outputType) {
            this.body = new BlockCreatorImpl(parent, ConstImpl.ofVoid(), outputType);
        }

        @Override
        public void of(Const val) {
            ConstImpl castVal = (ConstImpl)SwitchCreatorImpl.this.constantType.cast(val);
            if (this.state > 1) {
                throw new IllegalStateException("No more case values may be added");
            }
            this.state = 1;
            int hc = SwitchCreatorImpl.this.staticHash(castVal);
            if (SwitchCreatorImpl.this.casesByConstant.isEmpty()) {
                SwitchCreatorImpl.this.min = SwitchCreatorImpl.this.max = hc;
            } else {
                if (hc < SwitchCreatorImpl.this.min) {
                    SwitchCreatorImpl.this.min = hc;
                }
                if (hc > SwitchCreatorImpl.this.max) {
                    SwitchCreatorImpl.this.max = hc;
                }
            }
            CaseCreatorImpl existing = SwitchCreatorImpl.this.casesByConstant.putIfAbsent(castVal, this);
            if (existing != null) {
                throw new IllegalArgumentException("Duplicate case for constant " + String.valueOf(val));
            }
        }

        BlockCreatorImpl body() {
            return this.body;
        }

        @Override
        public void body(Consumer<BlockCreator> builder) {
            if (this.state >= 2) {
                throw new IllegalStateException("Body already created");
            }
            if (this.state == 0) {
                throw new IllegalStateException("No values given for this switch case");
            }
            this.state = 2;
            try {
                this.body.accept(builder);
                if (this.body.mayFallThrough()) {
                    SwitchCreatorImpl.this.fallThrough = true;
                }
            }
            finally {
                this.state = 3;
            }
        }
    }
}

