/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.util;

import java.security.AccessController;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import oracle.ucp.diagnostics.DiagnosticsCollectorImpl;
import oracle.ucp.util.TimerHandle;
import oracle.ucp.util.TimerManager;
import oracle.ucp.util.TimerTask;

public class UCPTimerManagerImpl
implements TimerManager {
    static final String CLASS_NAME = UCPTimerManagerImpl.class.getName();
    private static final int NUMBER_OF_THREADS = 5;
    private final ReentrantLock startStopLock = new ReentrantLock();
    private ScheduledThreadPoolExecutor scheduler;
    private final ReentrantLock timerManagerLock = new ReentrantLock();
    private Set<ScheduledFuture<?>> setScheduledFutures = new LinkedHashSet();

    private ScheduledThreadPoolExecutor buildExecutor() {
        return AccessController.doPrivileged(() -> {
            ThreadFactory tf = new ThreadFactory(){
                private final AtomicInteger numCreatedThreads = new AtomicInteger(0);
                private static final String THREAD_NAME_PREFIX = "UCP-ScheduledThreadPoolExecutor-Thread-";

                @Override
                public Thread newThread(Runnable r) {
                    Thread newT = new Thread(null, r, THREAD_NAME_PREFIX + this.numCreatedThreads.incrementAndGet());
                    newT.setPriority(5);
                    newT.setDaemon(true);
                    return newT;
                }
            };
            return new ScheduledThreadPoolExecutor(5, tf);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerHandle scheduleHelper(TimerTask task, long delay, long interval) {
        this.timerManagerLock.lock();
        try {
            if (Objects.isNull(task)) {
                throw new NullPointerException("task is null");
            }
            if (delay < 0L) {
                throw new IllegalArgumentException("negative delay");
            }
            if (interval < 0L) {
                throw new IllegalArgumentException("negative interval");
            }
            ScheduledThreadPoolExecutor scheduler = this.scheduler;
            if (null == scheduler) {
                throw new IllegalStateException("ScheduledThreadPoolExecutor not started");
            }
            final ScheduledFuture<?> future = interval > 0L ? scheduler.scheduleAtFixedRate(task, delay, interval, TimeUnit.MILLISECONDS) : scheduler.schedule(task, delay, TimeUnit.MILLISECONDS);
            this.setScheduledFutures.add(future);
            UCPTimerManagerImpl timerManagerThis = this;
            TimerHandle timerHandle = new TimerHandle(){

                @Override
                public void cancel() {
                    UCPTimerManagerImpl.this.timerManagerLock.lock();
                    try {
                        if (UCPTimerManagerImpl.this.setScheduledFutures.remove(future)) {
                            future.cancel(true);
                        }
                    }
                    finally {
                        UCPTimerManagerImpl.this.timerManagerLock.unlock();
                    }
                }
            };
            return timerHandle;
        }
        finally {
            this.timerManagerLock.unlock();
        }
    }

    @Override
    public boolean isRunning() {
        return null != this.scheduler;
    }

    @Override
    public TimerHandle schedule(TimerTask task, long delay, long interval) {
        return this.scheduleHelper(task, delay, interval);
    }

    @Override
    public TimerHandle scheduleAtFixedRate(TimerTask task, long delay, long interval) {
        return this.scheduleHelper(task, delay, interval);
    }

    @Override
    public void start() {
        try {
            this.startStopLock.lock();
            if (null != this.scheduler) {
                return;
            }
            this.scheduler = this.buildExecutor();
        }
        finally {
            this.startStopLock.unlock();
        }
    }

    @Override
    public void stop() {
        try {
            this.startStopLock.lock();
            if (null == this.scheduler) {
                return;
            }
            this.scheduler.shutdown();
            try {
                if (this.scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.FINEST, CLASS_NAME, "stop", "ScheduledThreadPoolExecutoer successful shutdown", null, null, new Object[0]);
                } else {
                    DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "stop", "Waited ScheduledThreadPoolExecutoer shutdown for 5 seconds, did not end up", null, null, new Object[0]);
                }
            }
            catch (InterruptedException e) {
                DiagnosticsCollectorImpl.getCommon().trace(Level.WARNING, CLASS_NAME, "stop", "", null, e, new Object[0]);
            }
            this.scheduler = null;
        }
        finally {
            this.startStopLock.unlock();
        }
    }
}

