/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.VersionType;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class LikeDocument
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, LikeDocument> {
    @Nullable
    private final JsonData doc;
    @Nonnull
    private final List<String> fields;
    @Nullable
    private final String id;
    @Nullable
    private final String index;
    @Nonnull
    private final Map<String, String> perFieldAnalyzer;
    @Nullable
    private final String routing;
    @Nullable
    private final Long version;
    @Nullable
    private final VersionType versionType;
    public static final JsonpDeserializer<LikeDocument> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, LikeDocument::setupLikeDocumentDeserializer);

    private LikeDocument(Builder builder) {
        this.doc = builder.doc;
        this.fields = ApiTypeHelper.unmodifiable(builder.fields);
        this.id = builder.id;
        this.index = builder.index;
        this.perFieldAnalyzer = ApiTypeHelper.unmodifiable(builder.perFieldAnalyzer);
        this.routing = builder.routing;
        this.version = builder.version;
        this.versionType = builder.versionType;
    }

    public static LikeDocument of(Function<Builder, ObjectBuilder<LikeDocument>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final JsonData doc() {
        return this.doc;
    }

    @Nonnull
    public final List<String> fields() {
        return this.fields;
    }

    @Nullable
    public final String id() {
        return this.id;
    }

    @Nullable
    public final String index() {
        return this.index;
    }

    @Nonnull
    public final Map<String, String> perFieldAnalyzer() {
        return this.perFieldAnalyzer;
    }

    @Nullable
    public final String routing() {
        return this.routing;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Nullable
    public final VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.doc != null) {
            generator.writeKey("doc");
            this.doc.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (this.id != null) {
            generator.writeKey("_id");
            generator.write(this.id);
        }
        if (this.index != null) {
            generator.writeKey("_index");
            generator.write(this.index);
        }
        if (ApiTypeHelper.isDefined(this.perFieldAnalyzer)) {
            generator.writeKey("per_field_analyzer");
            generator.writeStartObject();
            for (Map.Entry entry : this.perFieldAnalyzer.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (this.routing != null) {
            generator.writeKey("routing");
            generator.write(this.routing);
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
        if (this.versionType != null) {
            generator.writeKey("version_type");
            this.versionType.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupLikeDocumentDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::doc, JsonData._DESERIALIZER, "doc");
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "_id");
        op.add(Builder::index, JsonpDeserializer.stringDeserializer(), "_index");
        op.add(Builder::perFieldAnalyzer, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "per_field_analyzer");
        op.add(Builder::routing, JsonpDeserializer.stringDeserializer(), "routing");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
        op.add(Builder::versionType, VersionType._DESERIALIZER, "version_type");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.doc);
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.id);
        result = 31 * result + Objects.hashCode(this.index);
        result = 31 * result + Objects.hashCode(this.perFieldAnalyzer);
        result = 31 * result + Objects.hashCode(this.routing);
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + Objects.hashCode(this.versionType);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LikeDocument other = (LikeDocument)o;
        return Objects.equals(this.doc, other.doc) && Objects.equals(this.fields, other.fields) && Objects.equals(this.id, other.id) && Objects.equals(this.index, other.index) && Objects.equals(this.perFieldAnalyzer, other.perFieldAnalyzer) && Objects.equals(this.routing, other.routing) && Objects.equals(this.version, other.version) && Objects.equals(this.versionType, other.versionType);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, LikeDocument> {
        @Nullable
        private JsonData doc;
        @Nullable
        private List<String> fields;
        @Nullable
        private String id;
        @Nullable
        private String index;
        @Nullable
        private Map<String, String> perFieldAnalyzer;
        @Nullable
        private String routing;
        @Nullable
        private Long version;
        @Nullable
        private VersionType versionType;

        public Builder() {
        }

        private Builder(LikeDocument o) {
            this.doc = o.doc;
            this.fields = Builder._listCopy(o.fields);
            this.id = o.id;
            this.index = o.index;
            this.perFieldAnalyzer = Builder._mapCopy(o.perFieldAnalyzer);
            this.routing = o.routing;
            this.version = o.version;
            this.versionType = o.versionType;
        }

        private Builder(Builder o) {
            this.doc = o.doc;
            this.fields = Builder._listCopy(o.fields);
            this.id = o.id;
            this.index = o.index;
            this.perFieldAnalyzer = Builder._mapCopy(o.perFieldAnalyzer);
            this.routing = o.routing;
            this.version = o.version;
            this.versionType = o.versionType;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder doc(@Nullable JsonData value) {
            this.doc = value;
            return this;
        }

        @Nonnull
        public final Builder fields(List<String> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        @Nonnull
        public final Builder fields(String value, String ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        @Nonnull
        public final Builder id(@Nullable String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder index(@Nullable String value) {
            this.index = value;
            return this;
        }

        @Nonnull
        public final Builder perFieldAnalyzer(Map<String, String> map) {
            this.perFieldAnalyzer = Builder._mapPutAll(this.perFieldAnalyzer, map);
            return this;
        }

        @Nonnull
        public final Builder perFieldAnalyzer(String key, String value) {
            this.perFieldAnalyzer = Builder._mapPut(this.perFieldAnalyzer, key, value);
            return this;
        }

        @Nonnull
        public final Builder routing(@Nullable String value) {
            this.routing = value;
            return this;
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Nonnull
        public final Builder versionType(@Nullable VersionType value) {
            this.versionType = value;
            return this;
        }

        @Override
        @Nonnull
        public LikeDocument build() {
            this._checkSingleUse();
            return new LikeDocument(this);
        }
    }
}

