/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.auth;

import org.ldaptive.LdapException;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.auth.AbstractSearchEntryResolver;
import org.ldaptive.auth.AuthenticationCriteria;
import org.ldaptive.auth.AuthenticationHandlerResponse;
import org.ldaptive.control.AuthorizationIdentityResponseControl;

public class AuthorizationIdentityEntryResolver
extends AbstractSearchEntryResolver {
    @Override
    protected SearchResult performLdapSearch(AuthenticationCriteria criteria, AuthenticationHandlerResponse response) throws LdapException {
        AuthorizationIdentityResponseControl ctrl = (AuthorizationIdentityResponseControl)response.getControl("2.16.840.1.113730.3.4.15");
        if (ctrl == null) {
            throw new IllegalStateException("Authorization Identity Response Control not found");
        }
        this.logger.debug("found authorization identity response control {}", (Object)ctrl);
        String authzId = ctrl.getAuthorizationId();
        String dn = authzId.split(":", 2)[1].trim();
        SearchOperation search = this.createSearchOperation(response.getConnection());
        return (SearchResult)search.execute(this.createSearchRequest(criteria, dn)).getResult();
    }

    protected SearchRequest createSearchRequest(AuthenticationCriteria ac, String dn) {
        SearchRequest request = SearchRequest.newObjectScopeSearchRequest(dn, ac.getAuthenticationRequest().getReturnAttributes());
        request.setDerefAliases(this.getDerefAliases());
        request.setReferralHandler(this.getReferralHandler());
        request.setSearchEntryHandlers(this.getSearchEntryHandlers());
        return request;
    }
}

