# This file has been autogenerated by the pywayland scanner

# Copyright © 2023 Valve Corporation
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

import enum

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class WpCommitTimerV1(Interface):
    """Surface commit timer

    An object to set a time constraint for a content update on a surface.
    """

    name = "wp_commit_timer_v1"
    version = 1

    class error(enum.IntEnum):
        invalid_timestamp = 0
        timestamp_exists = 1
        surface_destroyed = 2


class WpCommitTimerV1Proxy(Proxy[WpCommitTimerV1]):
    interface = WpCommitTimerV1

    @WpCommitTimerV1.request(
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
        Argument(ArgumentType.Uint),
    )
    def set_timestamp(self, tv_sec_hi: int, tv_sec_lo: int, tv_nsec: int) -> None:
        """Specify time the following commit takes effect

        Provide a timing constraint for a surface content update.

        A set_timestamp request may be made before a :func:`WlSurface.commit()
        <pywayland.protocol.wayland.WlSurface.commit>` to tell the compositor
        that the content is intended to be presented as closely as possible to,
        but not before, the specified time. The time is in the domain of the
        compositor's presentation clock.

        An invalid_timestamp error will be generated for invalid tv_nsec.

        If a timestamp already exists on the surface, a timestamp_exists error
        is generated.

        Requesting set_timestamp after the commit_timer object's surface is
        destroyed will generate a "surface_destroyed" error.

        :param tv_sec_hi:
            high 32 bits of the seconds part of target time
        :type tv_sec_hi:
            `ArgumentType.Uint`
        :param tv_sec_lo:
            low 32 bits of the seconds part of target time
        :type tv_sec_lo:
            `ArgumentType.Uint`
        :param tv_nsec:
            nanoseconds part of target time
        :type tv_nsec:
            `ArgumentType.Uint`
        """
        self._marshal(0, tv_sec_hi, tv_sec_lo, tv_nsec)

    @WpCommitTimerV1.request()
    def destroy(self) -> None:
        """Destroy the timer

        Informs the server that the client will no longer be using this
        protocol object.

        Existing timing constraints are not affected by the destruction.
        """
        self._marshal(1)
        self._destroy()


class WpCommitTimerV1Resource(Resource):
    interface = WpCommitTimerV1


class WpCommitTimerV1Global(Global):
    interface = WpCommitTimerV1


WpCommitTimerV1._gen_c()
WpCommitTimerV1.proxy_class = WpCommitTimerV1Proxy
WpCommitTimerV1.resource_class = WpCommitTimerV1Resource
WpCommitTimerV1.global_class = WpCommitTimerV1Global
