# This file has been autogenerated by the pywayland scanner

# Copyright © 2015-2016 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)


class ZxdgExportedV1(Interface):
    """An exported surface handle

    An xdg_exported object represents an exported reference to a surface. The
    exported surface may be referenced as long as the xdg_exported object not
    destroyed. Destroying the xdg_exported invalidates any relationship the
    importer may have established using xdg_imported.
    """

    name = "zxdg_exported_v1"
    version = 1


class ZxdgExportedV1Proxy(Proxy[ZxdgExportedV1]):
    interface = ZxdgExportedV1

    @ZxdgExportedV1.request()
    def destroy(self) -> None:
        """Unexport the exported surface

        Revoke the previously exported surface. This invalidates any
        relationship the importer may have set up using the xdg_imported
        created given the handle sent via xdg_exported.handle.
        """
        self._marshal(0)
        self._destroy()


class ZxdgExportedV1Resource(Resource):
    interface = ZxdgExportedV1

    @ZxdgExportedV1.event(
        Argument(ArgumentType.String),
    )
    def handle(self, handle: str) -> None:
        """The exported surface handle

        The handle event contains the unique handle of this exported surface
        reference. It may be shared with any client, which then can use it to
        import the surface by calling xdg_importer.import. A handle may be used
        to import the surface multiple times.

        :param handle:
            the exported surface handle
        :type handle:
            `ArgumentType.String`
        """
        self._post_event(0, handle)


class ZxdgExportedV1Global(Global):
    interface = ZxdgExportedV1


ZxdgExportedV1._gen_c()
ZxdgExportedV1.proxy_class = ZxdgExportedV1Proxy
ZxdgExportedV1.resource_class = ZxdgExportedV1Resource
ZxdgExportedV1.global_class = ZxdgExportedV1Global
