# This file has been autogenerated by the pywayland scanner

# Copyright © 2024 Xaver Hugl
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from __future__ import annotations

from pywayland.protocol_core import (
    Argument,
    ArgumentType,
    Global,
    Interface,
    Proxy,
    Resource,
)

from ..xdg_shell import XdgToplevel


class XdgToplevelTagManagerV1(Interface):
    """Protocol for setting toplevel tags

    In order to make some window properties like position, size, "always on
    top" or user defined rules for window behavior persistent, the compositor
    needs some way to identify windows even after the application has been
    restarted. This protocol allows clients to make this possible by setting a
    tag for toplevels.

    Warning! The protocol described in this file is currently in the testing
    phase. Backward compatible changes may be added together with the
    corresponding interface version bump. Backward incompatible changes can
    only be done by creating a new major version of the extension.
    """

    name = "xdg_toplevel_tag_manager_v1"
    version = 1


class XdgToplevelTagManagerV1Proxy(Proxy[XdgToplevelTagManagerV1]):
    interface = XdgToplevelTagManagerV1

    @XdgToplevelTagManagerV1.request()
    def destroy(self) -> None:
        """Destroy toplevel tag object

        Destroy this toplevel tag manager object. This request has no other
        effects.
        """
        self._marshal(0)
        self._destroy()

    @XdgToplevelTagManagerV1.request(
        Argument(ArgumentType.Object, interface=XdgToplevel),
        Argument(ArgumentType.String),
    )
    def set_toplevel_tag(self, toplevel: XdgToplevel, tag: str) -> None:
        """Set tag

        Set a tag for a toplevel. The tag may be shown to the user in UI, so
        it's preferable for it to be human readable, but it must be suitable
        for configuration files and should not be translated. Suitable tags
        would for example be "main window", "settings", "e-mail composer" or
        similar.

        The tag does not need to be unique across applications, and the client
        may set the same tag for multiple windows, for example if the user has
        opened the same UI twice. How the potentially resulting conflicts are
        handled is compositor policy.

        The client should set the tag as part of the initial commit on the
        associated toplevel, but it may set it at any time afterwards as well,
        for example if the purpose of the toplevel changes.

        :param toplevel:
        :type toplevel:
            :class:`~pywayland.protocol.xdg_shell.XdgToplevel`
        :param tag:
            untranslated tag
        :type tag:
            `ArgumentType.String`
        """
        self._marshal(1, toplevel, tag)

    @XdgToplevelTagManagerV1.request(
        Argument(ArgumentType.Object, interface=XdgToplevel),
        Argument(ArgumentType.String),
    )
    def set_toplevel_description(self, toplevel: XdgToplevel, description: str) -> None:
        """Set description

        Set a description for a toplevel. This description may be shown to the
        user in UI or read by a screen reader for accessibility purposes, and
        should be translated. It is recommended to make the description the
        translation of the tag.

        The client should set the description as part of the initial commit on
        the associated toplevel, but it may set it at any time afterwards as
        well, for example if the purpose of the toplevel changes.

        :param toplevel:
        :type toplevel:
            :class:`~pywayland.protocol.xdg_shell.XdgToplevel`
        :param description:
            translated description
        :type description:
            `ArgumentType.String`
        """
        self._marshal(2, toplevel, description)


class XdgToplevelTagManagerV1Resource(Resource):
    interface = XdgToplevelTagManagerV1


class XdgToplevelTagManagerV1Global(Global):
    interface = XdgToplevelTagManagerV1


XdgToplevelTagManagerV1._gen_c()
XdgToplevelTagManagerV1.proxy_class = XdgToplevelTagManagerV1Proxy
XdgToplevelTagManagerV1.resource_class = XdgToplevelTagManagerV1Resource
XdgToplevelTagManagerV1.global_class = XdgToplevelTagManagerV1Global
