\name{BinaryProjectionImageFilter}
\alias{BinaryProjectionImageFilter}
\title{BinaryProjectionImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Binary projection.
BinaryProjectionImageFilter}
\details{
This class was contributed to the Insight Journal by Gaetan Lehmann.
The original paper can be found at https://www.insight-journal.org/browse/publication/71
Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
See:
ProjectionImageFilter
MedianProjectionImageFilter
MeanProjectionImageFilter
MeanProjectionImageFilter
MaximumProjectionImageFilter
MinimumProjectionImageFilter
StandardDeviationProjectionImageFilter
SumProjectionImageFilter
BinaryProjection for the procedural interface
itk::BinaryProjectionImageFilter for the Doxygen on the original ITK class.
BinaryProjectionImageFilter}
%C++ includes: sitkBinaryProjectionImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryProjectionImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Get the value used as "background". Any pixel value which is not
DilateValue is considered background. BackgroundValue is used for
defining boundary conditions. Defaults to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{double GetForegroundValue() const:}{
Get the value in the image considered as "foreground". Defaults to
maximum value of PixelType.
}
\item{std::string GetName() const:}{
Name of this class
}
\item{unsigned int GetProjectionDimension() const:}{}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set the value used as "background". Any pixel value which is not
DilateValue is considered background. BackgroundValue is used for
defining boundary conditions. Defaults to NumericTraits<PixelType>::NonpositiveMin() .
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set the value in the image to consider as "foreground". Defaults to
maximum value of PixelType. Subclasses may alias this to DilateValue
or ErodeValue.
}
\item{Self SetProjectionDimension(unsigned int ProjectionDimension):}{}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryProjectionImageFilter():}{
Destructor
}
}
}
