\name{ImageSeriesWriter}
\alias{ImageSeriesWriter}
\title{ImageSeriesWriter}
\Rdversion{1.1}
\docType{class}
\description{
Writer series of image from a SimpleITK image.
ImageSeriesWriter}
\details{
The ImageSeriesWriter is for writing a 3D image as a series of 2D images. A list of names
for the series of 2D images must be provided, and an exception will be
generated if the number of file names does not match the size of the
image in the z-direction.
DICOM series cannot be written with this class, as an exception will
be generated. To write a DICOM series the individual slices must be
extracted, proper DICOM tags must be added to the dictionaries, then
written with the ImageFileWriter.
See:
WriteImage for the procedural interface
ImageSeriesWriter}
%C++ includes: sitkImageSeriesWriter.h
\section{Methods}{
\describe{
\item{Self Execute(const Image &):}{}
\item{Self Execute(const Image &image, const std::vector< std::string > &inFileNames, bool useCompression, int compressionLevel):}{}
\item{std::vector< std::string > GetRegisteredImageIOs() const:}{
Get a vector of the names of registered itk ImageIOs.
}
\item{ ImageSeriesWriter():}{}
\item{std::string ToString() const override:}{
Print ourselves to string
}
\item{ ~ImageSeriesWriter() override:}{}
}
}
