/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.schemacrawler;

import schemacrawler.schemacrawler.FilterOptions;
import schemacrawler.schemacrawler.OptionsBuilder;

public final class FilterOptionsBuilder
implements OptionsBuilder<FilterOptionsBuilder, FilterOptions> {
    private int childTableFilterDepth;
    private int parentTableFilterDepth;

    public static FilterOptionsBuilder builder() {
        return new FilterOptionsBuilder();
    }

    public static FilterOptions newFilterOptions() {
        return FilterOptionsBuilder.builder().toOptions();
    }

    private FilterOptionsBuilder() {
    }

    public FilterOptionsBuilder childTableFilterDepth(int childTableFilterDepth) {
        this.childTableFilterDepth = Math.max(childTableFilterDepth, 0);
        return this;
    }

    public FilterOptionsBuilder fromOptions(FilterOptions options) {
        if (options == null) {
            return this;
        }
        this.childTableFilterDepth = options.childTableFilterDepth();
        this.parentTableFilterDepth = options.parentTableFilterDepth();
        return this;
    }

    public FilterOptionsBuilder parentTableFilterDepth(int parentTableFilterDepth) {
        this.parentTableFilterDepth = Math.max(parentTableFilterDepth, 0);
        return this;
    }

    @Override
    public FilterOptions toOptions() {
        return new FilterOptions(this.childTableFilterDepth, this.parentTableFilterDepth);
    }
}

