/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.range;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.range.PRange;
import com.oracle.truffle.api.CompilerDirectives;
import java.math.BigInteger;

public class PBigRange
extends PRange {
    private final PInt start;
    private final PInt stop;
    private final PInt step;
    protected final PInt length;

    public PBigRange(PythonLanguage lang, PInt start, PInt stop, PInt step, PInt length) {
        super(lang);
        this.start = start;
        this.stop = stop;
        this.step = step;
        this.length = length;
    }

    @Override
    public Object getStart() {
        return this.start;
    }

    @Override
    public Object getStep() {
        return this.step;
    }

    @Override
    public Object getStop() {
        return this.stop;
    }

    @Override
    public Object getLength() {
        return this.length;
    }

    public PInt getPIntStart() {
        return this.start;
    }

    public PInt getPIntStop() {
        return this.stop;
    }

    public PInt getPIntStep() {
        return this.step;
    }

    public PInt getPIntLength() {
        return this.length;
    }

    public BigInteger getBigIntegerStart() {
        return this.start.getValue();
    }

    public BigInteger getBigIntegerStop() {
        return this.stop.getValue();
    }

    public BigInteger getBigIntegerStep() {
        return this.step.getValue();
    }

    public BigInteger getBigIntegerLength() {
        return this.length.getValue();
    }

    @CompilerDirectives.TruffleBoundary
    public BigInteger getBigIntItemNormalized(BigInteger index) {
        assert (index.compareTo(this.length.getValue()) < 0);
        return this.step.multiply(index).add(this.start.getValue());
    }

    @Override
    protected boolean withStep() {
        return !this.step.isOne();
    }
}

