/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNodeGen;
import com.oracle.graal.python.nodes.util.CastToJavaIntNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class CastToJavaIntExactNode
extends CastToJavaIntNode {
    public final int executeWithThrowSystemError(Node inliningTarget, Object x, PRaiseNode raiseNode) {
        return this.executeWithThrow(inliningTarget, x, raiseNode, PythonBuiltinClassType.SystemError);
    }

    public final int executeWithThrow(Node inliningTarget, Object x, PRaiseNode raiseNode, PythonBuiltinClassType errType) {
        try {
            return this.execute(inliningTarget, x);
        }
        catch (CannotCastException cce) {
            throw raiseNode.raise(inliningTarget, errType, ErrorMessages.MUST_BE_S_NOT_P, "an int", x);
        }
    }

    public static int executeUncached(long x) {
        return CastToJavaIntExactNodeGen.getUncached().execute((Node)null, x);
    }

    public static int executeUncached(Object x) {
        return CastToJavaIntExactNodeGen.getUncached().execute(null, x);
    }

    public final int executeCached(long x) {
        return this.execute((Node)this, x);
    }

    public final int executeCached(Object x) {
        return this.execute((Node)this, x);
    }

    @NeverDefault
    public static CastToJavaIntExactNode create() {
        return CastToJavaIntExactNodeGen.create();
    }

    @NeverDefault
    public static CastToJavaIntExactNode getUncached() {
        return CastToJavaIntExactNodeGen.getUncached();
    }

    @Specialization(rewriteOn={OverflowException.class})
    static int longToInt(long x) throws OverflowException {
        return PInt.intValueExact(x);
    }

    @Specialization(rewriteOn={OverflowException.class})
    static int pIntToInt(PInt x) throws OverflowException {
        return x.intValueExact();
    }

    @Specialization(replaces={"longToInt"})
    static int longToIntOverflow(Node inliningTarget, long x, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
        try {
            return PInt.intValueExact(x);
        }
        catch (OverflowException e) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "int");
        }
    }

    @Specialization(replaces={"pIntToInt"})
    static int pIntToIntOverflow(Node inliningTarget, PInt x, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
        try {
            return x.intValueExact();
        }
        catch (OverflowException e) {
            throw raiseNode.raise(inliningTarget, PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "int");
        }
    }
}

