/*
 * Decompiled with CFR 0.152.
 */
package jakarta.websocket;

import jakarta.websocket.Decoder;
import jakarta.websocket.DefaultClientEndpointConfig;
import jakarta.websocket.Encoder;
import jakarta.websocket.EndpointConfig;
import jakarta.websocket.Extension;
import jakarta.websocket.HandshakeResponse;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;

public interface ClientEndpointConfig
extends EndpointConfig {
    public List<String> getPreferredSubprotocols();

    public List<Extension> getExtensions();

    public SSLContext getSSLContext();

    public Configurator getConfigurator();

    public static class Configurator {
        public void beforeRequest(Map<String, List<String>> map) {
        }

        public void afterResponse(HandshakeResponse handshakeResponse) {
        }
    }

    public static final class Builder {
        private static final Configurator DEFAULT_CONFIGURATOR = new Configurator(){};
        private Configurator configurator = DEFAULT_CONFIGURATOR;
        private List<String> preferredSubprotocols = Collections.emptyList();
        private List<Extension> extensions = Collections.emptyList();
        private List<Class<? extends Encoder>> encoders = Collections.emptyList();
        private List<Class<? extends Decoder>> decoders = Collections.emptyList();
        private SSLContext sslContext = null;

        public static Builder create() {
            return new Builder();
        }

        private Builder() {
        }

        public ClientEndpointConfig build() {
            return new DefaultClientEndpointConfig(this.preferredSubprotocols, this.extensions, this.encoders, this.decoders, this.sslContext, this.configurator);
        }

        public Builder configurator(Configurator configurator) {
            this.configurator = configurator == null ? DEFAULT_CONFIGURATOR : configurator;
            return this;
        }

        public Builder preferredSubprotocols(List<String> list) {
            this.preferredSubprotocols = list == null || list.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder extensions(List<Extension> list) {
            this.extensions = list == null || list.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder encoders(List<Class<? extends Encoder>> list) {
            this.encoders = list == null || list.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder decoders(List<Class<? extends Decoder>> list) {
            this.decoders = list == null || list.size() == 0 ? Collections.emptyList() : Collections.unmodifiableList(list);
            return this;
        }

        public Builder sslContext(SSLContext sSLContext) {
            this.sslContext = sSLContext;
            return this;
        }
    }
}

