/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.apache.coyote.ActionCode;
import org.apache.coyote.CloseNowException;
import org.apache.coyote.Constants;
import org.apache.coyote.InputBuffer;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.HttpOutputBuffer;
import org.apache.coyote.http11.OutputFilter;
import org.apache.coyote.http11.filters.SavedRequestInputFilter;
import org.apache.coyote.http11.filters.VoidOutputFilter;
import org.apache.coyote.http2.AbstractNonZeroStream;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.HpackException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Http2OutputBuffer;
import org.apache.coyote.http2.Http2UpgradeHandler;
import org.apache.coyote.http2.RecycledStream;
import org.apache.coyote.http2.StreamException;
import org.apache.coyote.http2.StreamProcessor;
import org.apache.coyote.http2.WindowAllocationManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.http.parser.Host;
import org.apache.tomcat.util.http.parser.Priority;
import org.apache.tomcat.util.net.ApplicationBufferHandler;
import org.apache.tomcat.util.net.WriteBuffer;
import org.apache.tomcat.util.res.StringManager;

class Stream
extends AbstractNonZeroStream
implements HpackDecoder.HeaderEmitter {
    private static final Log log = LogFactory.getLog(Stream.class);
    private static final StringManager sm = StringManager.getManager(Stream.class);
    private static final int HEADER_STATE_START = 0;
    private static final int HEADER_STATE_PSEUDO = 1;
    private static final int HEADER_STATE_REGULAR = 2;
    private static final int HEADER_STATE_TRAILER = 3;
    private static final MimeHeaders ACK_HEADERS;
    private static final Integer HTTP_UPGRADE_STREAM;
    private static final Set<String> HTTP_CONNECTION_SPECIFIC_HEADERS;
    private volatile long contentLengthReceived = 0L;
    private final Http2UpgradeHandler handler;
    private final WindowAllocationManager allocationManager = new WindowAllocationManager(this);
    private final Request coyoteRequest;
    private final Response coyoteResponse;
    private final StreamInputBuffer inputBuffer;
    private final StreamOutputBuffer streamOutputBuffer = new StreamOutputBuffer();
    private final Http2OutputBuffer http2OutputBuffer;
    private final AtomicBoolean removedFromActiveCount = new AtomicBoolean(false);
    private int headerState = 0;
    private StreamException headerException = null;
    private volatile StringBuilder cookieHeader = null;
    private volatile boolean hostHeaderSeen = false;
    private final Object pendingWindowUpdateForStreamLock = new Object();
    private int pendingWindowUpdateForStream = 0;
    private volatile int urgency = 3;
    private volatile boolean incremental = false;
    private final Object recycledLock = new Object();
    private volatile boolean recycled = false;

    Stream(Integer n, Http2UpgradeHandler http2UpgradeHandler) {
        this(n, http2UpgradeHandler, null);
    }

    Stream(Integer n, Http2UpgradeHandler http2UpgradeHandler, Request request) {
        super(http2UpgradeHandler.getConnectionId(), n);
        this.handler = http2UpgradeHandler;
        this.setWindowSize(http2UpgradeHandler.getRemoteSettings().getInitialWindowSize());
        if (request == null) {
            this.coyoteRequest = http2UpgradeHandler.getProtocol().popRequestAndResponse();
            this.coyoteResponse = this.coyoteRequest.getResponse();
            this.inputBuffer = new StandardStreamInputBuffer();
            this.coyoteRequest.setInputBuffer(this.inputBuffer);
        } else {
            this.coyoteRequest = request;
            this.coyoteResponse = new Response();
            this.coyoteRequest.setResponse(this.coyoteResponse);
            this.inputBuffer = new SavedRequestStreamInputBuffer((SavedRequestInputFilter)this.coyoteRequest.getInputBuffer());
            this.state.receivedStartOfHeaders();
            if (HTTP_UPGRADE_STREAM.equals(n)) {
                try {
                    this.prepareRequest();
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.coyoteResponse.setStatus(400);
                    this.coyoteResponse.setError();
                }
            }
            this.state.receivedEndOfStream();
        }
        this.coyoteRequest.setSendfile(http2UpgradeHandler.hasAsyncIO() && http2UpgradeHandler.getProtocol().getUseSendfile());
        this.http2OutputBuffer = new Http2OutputBuffer(this.coyoteResponse, this.streamOutputBuffer);
        this.coyoteResponse.setOutputBuffer(this.http2OutputBuffer);
        this.coyoteRequest.setResponse(this.coyoteResponse);
        this.coyoteRequest.protocol().setString("HTTP/2.0");
        this.coyoteRequest.markStartTime();
    }

    private void prepareRequest() {
        int n;
        MessageBytes messageBytes;
        if (this.coyoteRequest.scheme().isNull()) {
            if (this.handler.getProtocol().getHttp11Protocol().isSSLEnabled()) {
                this.coyoteRequest.scheme().setString("https");
            } else {
                this.coyoteRequest.scheme().setString("http");
            }
        }
        if ((messageBytes = this.coyoteRequest.getMimeHeaders().getUniqueValue("host")) == null) {
            throw new IllegalArgumentException();
        }
        messageBytes.toBytes();
        ByteChunk byteChunk = messageBytes.getByteChunk();
        byte[] byArray = byteChunk.getBytes();
        int n2 = byteChunk.getLength();
        int n3 = byteChunk.getStart();
        int n4 = Host.parse(messageBytes);
        if (n4 != -1) {
            int n5 = 0;
            for (n = n4 + 1; n < n2; ++n) {
                char c = (char)byArray[n + n3];
                if (c < '0' || c > '9') {
                    throw new IllegalArgumentException();
                }
                n5 = n5 * 10 + c - 48;
            }
            this.coyoteRequest.setServerPort(n5);
            n2 = n4;
        }
        char[] cArray = new char[n2];
        for (n = 0; n < n2; ++n) {
            cArray[n] = (char)byArray[n + n3];
        }
        this.coyoteRequest.serverName().setChars(cArray, 0, n2);
    }

    final void receiveReset(long l) {
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("stream.reset.receive", new Object[]{this.getConnectionId(), this.getIdAsString(), Long.toString(l)}));
        }
        this.state.receivedReset();
        this.inputBuffer.receiveReset();
        this.cancelAllocationRequests();
    }

    final void cancelAllocationRequests() {
        this.allocationManager.notifyAny();
    }

    @Override
    final void incrementWindowSize(int n) throws Http2Exception {
        this.windowAllocationLock.lock();
        try {
            boolean bl = this.getWindowSize() < 1L;
            super.incrementWindowSize(n);
            if (bl && this.getWindowSize() > 0L) {
                this.allocationManager.notifyStream();
            }
        }
        finally {
            this.windowAllocationLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int reserveWindowSize(int n, boolean bl) throws IOException {
        this.windowAllocationLock.lock();
        try {
            long l = this.getWindowSize();
            while (l < 1L) {
                if (!this.canWrite()) {
                    throw new CloseNowException(sm.getString("stream.notWritable", new Object[]{this.getConnectionId(), this.getIdAsString()}));
                }
                if (bl) {
                    try {
                        long l2 = this.handler.getProtocol().getStreamWriteTimeout();
                        this.allocationManager.waitForStream(l2);
                        l = this.getWindowSize();
                        if (l != 0L) continue;
                        this.doStreamCancel(sm.getString("stream.writeTimeout"), Http2Error.ENHANCE_YOUR_CALM);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException);
                    }
                }
                this.allocationManager.waitForStreamNonBlocking();
                int n2 = 0;
                return n2;
            }
            int n3 = l < (long)n ? (int)l : n;
            this.decrementWindowSize(n3);
            int n4 = n3;
            return n4;
        }
        finally {
            this.windowAllocationLock.unlock();
        }
    }

    void doStreamCancel(String string, Http2Error http2Error) throws CloseNowException {
        StreamException streamException = new StreamException(string, http2Error, this.getIdAsInt());
        this.streamOutputBuffer.closed = true;
        this.coyoteResponse.setError();
        this.coyoteResponse.setErrorReported();
        this.streamOutputBuffer.reset = streamException;
        throw new CloseNowException(string, streamException);
    }

    void waitForConnectionAllocation(long l) throws InterruptedException {
        this.allocationManager.waitForConnection(l);
    }

    void waitForConnectionAllocationNonBlocking() {
        this.allocationManager.waitForConnectionNonBlocking();
    }

    void notifyConnection() {
        this.allocationManager.notifyConnection();
    }

    @Override
    public final void emitHeader(String string, String string2) throws HpackException {
        boolean bl;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("stream.header.debug", new Object[]{this.getConnectionId(), this.getIdAsString(), string, string2}));
        }
        if (!string.toLowerCase(Locale.US).equals(string)) {
            throw new HpackException(sm.getString("stream.header.case", new Object[]{this.getConnectionId(), this.getIdAsString(), string}));
        }
        if (HTTP_CONNECTION_SPECIFIC_HEADERS.contains(string)) {
            throw new HpackException(sm.getString("stream.header.connection", new Object[]{this.getConnectionId(), this.getIdAsString(), string}));
        }
        if ("te".equals(string) && !"trailers".equals(string2)) {
            throw new HpackException(sm.getString("stream.header.te", new Object[]{this.getConnectionId(), this.getIdAsString(), string2}));
        }
        if (this.headerException != null) {
            return;
        }
        if (string.isEmpty()) {
            throw new HpackException(sm.getString("stream.header.empty", new Object[]{this.getConnectionId(), this.getIdAsString()}));
        }
        boolean bl2 = bl = string.charAt(0) == ':';
        if (bl && this.headerState != 1) {
            this.headerException = new StreamException(sm.getString("stream.header.unexpectedPseudoHeader", new Object[]{this.getConnectionId(), this.getIdAsString(), string}), Http2Error.PROTOCOL_ERROR, this.getIdAsInt());
            return;
        }
        if (this.headerState == 1 && !bl) {
            this.headerState = 2;
        }
        switch (string) {
            case ":method": {
                if (this.coyoteRequest.getMethod() == null) {
                    this.coyoteRequest.setMethod(string2);
                    if (!"HEAD".equals(string2)) break;
                    this.configureVoidOutputFilter();
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), ":method"}));
            }
            case ":scheme": {
                if (this.coyoteRequest.scheme().isNull()) {
                    this.coyoteRequest.scheme().setString(string2);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), ":scheme"}));
            }
            case ":path": {
                Object object;
                String string3;
                if (!this.coyoteRequest.requestURI().isNull()) {
                    throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), ":path"}));
                }
                if (string2.isEmpty()) {
                    throw new HpackException(sm.getString("stream.header.noPath", new Object[]{this.getConnectionId(), this.getIdAsString()}));
                }
                int n = string2.indexOf(63);
                if (n == -1) {
                    string3 = string2;
                } else {
                    string3 = string2.substring(0, n);
                    object = string2.substring(n + 1);
                    this.coyoteRequest.queryString().setString((String)object);
                }
                object = string3.getBytes(StandardCharsets.ISO_8859_1);
                this.coyoteRequest.requestURI().setBytes(object, 0, ((byte[])object).length);
                break;
            }
            case ":authority": {
                if (this.coyoteRequest.serverName().isNull()) {
                    this.parseAuthority(string2, false);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), ":authority"}));
            }
            case "cookie": {
                if (this.cookieHeader == null) {
                    this.cookieHeader = new StringBuilder();
                } else {
                    this.cookieHeader.append("; ");
                }
                this.cookieHeader.append(string2);
                break;
            }
            case "host": {
                if (this.coyoteRequest.serverName().isNull()) {
                    this.hostHeaderSeen = true;
                    this.parseAuthority(string2, true);
                    break;
                }
                if (!this.hostHeaderSeen) {
                    this.hostHeaderSeen = true;
                    this.compareAuthority(string2);
                    break;
                }
                throw new HpackException(sm.getString("stream.header.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString(), "host"}));
            }
            case "priority": {
                try {
                    Priority priority = Priority.parsePriority(new StringReader(string2));
                    this.setUrgency(priority.getUrgency());
                    this.setIncremental(priority.getIncremental());
                }
                catch (IOException iOException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)sm.getString("http2Parser.processFramePriorityUpdate.invalid", new Object[]{this.getConnectionId(), this.getIdAsString()}), (Throwable)illegalArgumentException);
                }
                break;
            }
            default: {
                if (this.headerState == 3 && !this.handler.getProtocol().isTrailerHeaderAllowed(string)) break;
                if ("expect".equals(string) && "100-continue".equals(string2)) {
                    this.coyoteRequest.setExpectation(true);
                }
                if (bl) {
                    this.headerException = new StreamException(sm.getString("stream.header.unknownPseudoHeader", new Object[]{this.getConnectionId(), this.getIdAsString(), string}), Http2Error.PROTOCOL_ERROR, this.getIdAsInt());
                }
                if (this.headerState == 3) {
                    this.coyoteRequest.getMimeTrailerFields().addValue(string).setString(string2);
                    break;
                }
                this.coyoteRequest.getMimeHeaders().addValue(string).setString(string2);
            }
        }
    }

    void configureVoidOutputFilter() {
        this.addOutputFilter(new VoidOutputFilter());
        this.streamOutputBuffer.closed = true;
    }

    private void parseAuthority(String string, boolean bl) throws HpackException {
        int n;
        try {
            n = Host.parse(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HpackException(sm.getString("stream.header.invalid", new Object[]{this.getConnectionId(), this.getIdAsString(), bl ? "host" : ":authority", string}));
        }
        if (n > -1) {
            this.coyoteRequest.serverName().setString(string.substring(0, n));
            this.coyoteRequest.setServerPort(Integer.parseInt(string.substring(n + 1)));
        } else {
            this.coyoteRequest.serverName().setString(string);
        }
        if (!this.handler.getProtocol().getHttp11Protocol().checkSni(this.handler.getSniHostName(), this.coyoteRequest.serverName().getString())) {
            throw new HpackException(sm.getString("stream.host.sni", new Object[]{this.getConnectionId(), this.getIdAsString(), string, this.handler.getSniHostName()}));
        }
    }

    private void compareAuthority(String string) throws HpackException {
        int n;
        try {
            n = Host.parse(string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new HpackException(sm.getString("stream.header.invalid", new Object[]{this.getConnectionId(), this.getIdAsString(), "host", string}));
        }
        if (n == -1 && (!string.equals(this.coyoteRequest.serverName().getString()) || this.coyoteRequest.getServerPort() != -1) || n > -1 && (!string.substring(0, n).equals(this.coyoteRequest.serverName().getString()) || Integer.parseInt(string.substring(n + 1)) != this.coyoteRequest.getServerPort())) {
            throw new HpackException(sm.getString("stream.host.inconsistent", new Object[]{this.getConnectionId(), this.getIdAsString(), string, this.coyoteRequest.serverName().getString(), Integer.toString(this.coyoteRequest.getServerPort())}));
        }
    }

    @Override
    public void setHeaderException(StreamException streamException) {
        if (this.headerException == null) {
            this.headerException = streamException;
        }
    }

    @Override
    public void validateHeaders() throws StreamException {
        if (this.headerException == null) {
            return;
        }
        this.handler.getHpackDecoder().setHeaderEmitter(Http2UpgradeHandler.HEADER_SINK);
        throw this.headerException;
    }

    final boolean receivedEndOfHeaders() throws ConnectionException {
        if (this.coyoteRequest.getMethod() == null || this.coyoteRequest.scheme().isNull() || !"CONNECT".equals(this.coyoteRequest.getMethod()) && this.coyoteRequest.requestURI().isNull()) {
            throw new ConnectionException(sm.getString("stream.header.required", new Object[]{this.getConnectionId(), this.getIdAsString()}), Http2Error.PROTOCOL_ERROR);
        }
        if (this.cookieHeader != null) {
            this.coyoteRequest.getMimeHeaders().addValue("cookie").setString(this.cookieHeader.toString());
        }
        return this.headerState == 2 || this.headerState == 1;
    }

    final void writeHeaders() throws IOException {
        boolean bl = this.streamOutputBuffer.hasNoBody() && this.coyoteResponse.getTrailerFields() == null;
        this.handler.writeHeaders(this, 0, this.coyoteResponse.getMimeHeaders(), bl, 1024);
    }

    final void addOutputFilter(OutputFilter outputFilter) {
        this.http2OutputBuffer.addFilter(outputFilter);
    }

    final void writeTrailers() throws IOException {
        Supplier<Map<String, String>> supplier = this.coyoteResponse.getTrailerFields();
        if (supplier == null) {
            return;
        }
        MimeHeaders mimeHeaders = new MimeHeaders();
        Map<String, String> map = supplier.get();
        if (map == null) {
            map = Collections.emptyMap();
        }
        for (Map.Entry<String, String> entry : map.entrySet()) {
            MessageBytes messageBytes = mimeHeaders.addValue(entry.getKey());
            messageBytes.setString(entry.getValue());
        }
        this.handler.writeHeaders(this, 0, mimeHeaders, true, 1024);
    }

    final void writeAck() throws IOException {
        this.handler.writeHeaders(this, 0, ACK_HEADERS, false, 64);
    }

    final void writeEarlyHints() throws IOException {
        MimeHeaders mimeHeaders = this.coyoteResponse.getMimeHeaders();
        String string = mimeHeaders.getHeader(":status");
        mimeHeaders.setValue(":status").setString("103");
        try {
            this.handler.writeHeaders(this, 0, mimeHeaders, false, 1024);
        }
        finally {
            if (string == null) {
                mimeHeaders.removeHeader(":status");
            } else {
                mimeHeaders.setValue(":status").setString(string);
            }
        }
    }

    @Override
    final String getConnectionId() {
        return this.handler.getConnectionId();
    }

    final Request getCoyoteRequest() {
        return this.coyoteRequest;
    }

    final Response getCoyoteResponse() {
        return this.coyoteResponse;
    }

    @Override
    final ByteBuffer getInputByteBuffer(boolean bl) {
        return this.inputBuffer.getInBuffer(bl);
    }

    final void receivedStartOfHeaders(boolean bl) throws Http2Exception {
        if (this.headerState == 0) {
            this.headerState = 1;
            this.handler.getHpackDecoder().setMaxHeaderCount(this.handler.getProtocol().getMaxHeaderCount());
            this.handler.getHpackDecoder().setMaxHeaderSize(this.handler.getProtocol().getMaxHeaderSize());
        } else if (this.headerState == 1 || this.headerState == 2) {
            if (bl) {
                this.headerState = 3;
                this.handler.getHpackDecoder().setMaxHeaderCount(this.handler.getProtocol().getMaxTrailerCount());
                this.handler.getHpackDecoder().setMaxHeaderSize(this.handler.getProtocol().getMaxTrailerSize());
            } else {
                throw new ConnectionException(sm.getString("stream.trailerHeader.noEndOfStream", new Object[]{this.getConnectionId(), this.getIdAsString()}), Http2Error.PROTOCOL_ERROR);
            }
        }
        this.state.receivedStartOfHeaders();
    }

    @Override
    final void receivedData(int n) throws Http2Exception {
        this.contentLengthReceived += (long)n;
        long l = this.coyoteRequest.getContentLengthLong();
        if (l > -1L && this.contentLengthReceived > l) {
            throw new ConnectionException(sm.getString("stream.header.contentLength", new Object[]{this.getConnectionId(), this.getIdAsString(), l, this.contentLengthReceived}), Http2Error.PROTOCOL_ERROR);
        }
    }

    final void receivedEndOfStream() throws ConnectionException {
        if (this.isContentLengthInconsistent()) {
            throw new ConnectionException(sm.getString("stream.header.contentLength", new Object[]{this.getConnectionId(), this.getIdAsString(), this.coyoteRequest.getContentLengthLong(), this.contentLengthReceived}), Http2Error.PROTOCOL_ERROR);
        }
        this.state.receivedEndOfStream();
        this.inputBuffer.notifyEof();
    }

    final boolean isContentLengthInconsistent() {
        long l = this.coyoteRequest.getContentLengthLong();
        return l > -1L && this.contentLengthReceived != l;
    }

    final void sentHeaders() {
        this.state.sentHeaders();
    }

    final void sentEndOfStream() {
        this.streamOutputBuffer.endOfStreamSent = true;
        this.state.sentEndOfStream();
    }

    final boolean isReadyForWrite() {
        return this.streamOutputBuffer.isReady();
    }

    final boolean flush(boolean bl) throws IOException {
        return this.streamOutputBuffer.flush(bl);
    }

    final StreamInputBuffer getInputBuffer() {
        return this.inputBuffer;
    }

    final HttpOutputBuffer getOutputBuffer() {
        return this.http2OutputBuffer;
    }

    final void sentPushPromise() {
        this.state.sentPushPromise();
    }

    final boolean isActive() {
        return this.state.isActive();
    }

    final boolean canWrite() {
        return this.state.canWrite();
    }

    final void closeIfIdle() {
        this.state.closeIfIdle();
    }

    final boolean isInputFinished() {
        return !this.state.isFrameTypePermitted(FrameType.DATA);
    }

    final void close(Http2Exception http2Exception) {
        if (http2Exception instanceof StreamException) {
            try {
                StreamException streamException = (StreamException)http2Exception;
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("stream.reset.send", new Object[]{this.getConnectionId(), this.getIdAsString(), streamException.getError()}));
                }
                this.handler.sendStreamReset(this.state, streamException);
                this.cancelAllocationRequests();
                this.inputBuffer.swallowUnread();
            }
            catch (IOException iOException) {
                ConnectionException connectionException = new ConnectionException(sm.getString("stream.reset.fail", new Object[]{this.getConnectionId(), this.getIdAsString()}), Http2Error.PROTOCOL_ERROR, iOException);
                this.handler.closeConnection(connectionException);
            }
        } else {
            this.handler.closeConnection(http2Exception);
        }
        this.replace();
    }

    final void replace() {
        ByteBuffer byteBuffer = this.getInputByteBuffer(false);
        int n = byteBuffer == null ? 0 : byteBuffer.remaining();
        this.handler.replaceStream(this, new RecycledStream(this.getConnectionId(), this.getIdentifier(), this.state, n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void recycle() {
        if (this.recycled) {
            log.warn((Object)sm.getString("stream.recycle.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString()}));
            return;
        }
        Object object = this.recycledLock;
        synchronized (object) {
            if (this.recycled) {
                log.warn((Object)sm.getString("stream.recycle.duplicate", new Object[]{this.getConnectionId(), this.getIdAsString()}));
                return;
            }
            this.recycled = true;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("stream.recycle.first", new Object[]{this.getConnectionId(), this.getIdAsString()}));
        }
        this.coyoteRequest.recycle();
        this.coyoteResponse.recycle();
        this.handler.getProtocol().pushRequestAndResponse(this.coyoteRequest);
    }

    final boolean isPushSupported() {
        return this.handler.getRemoteSettings().getEnablePush();
    }

    final void push(Request request) throws IOException {
        if (!this.isPushSupported() || this.getIdAsInt() % 2 == 0) {
            return;
        }
        request.getMimeHeaders().addValue(":method").setString(request.getMethod());
        request.getMimeHeaders().addValue(":scheme").duplicate(request.scheme());
        StringBuilder stringBuilder = new StringBuilder(request.requestURI().toString());
        if (!request.queryString().isNull()) {
            stringBuilder.append('?');
            stringBuilder.append(request.queryString().toString());
        }
        request.getMimeHeaders().addValue(":path").setString(stringBuilder.toString());
        if (!(request.scheme().equals("http") && request.getServerPort() == 80 || request.scheme().equals("https") && request.getServerPort() == 443)) {
            request.getMimeHeaders().addValue(":authority").setString(request.serverName().getString() + ":" + request.getServerPort());
        } else {
            request.getMimeHeaders().addValue(":authority").duplicate(request.serverName());
        }
        Stream.push(this.handler, request, this);
    }

    boolean isTrailerFieldsReady() {
        return !this.state.canRead();
    }

    boolean isTrailerFieldsSupported() {
        return !this.streamOutputBuffer.endOfStreamSent;
    }

    StreamException getResetException() {
        return this.streamOutputBuffer.reset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getWindowUpdateSizeToWrite(int n) {
        int n2;
        int n3 = this.handler.getProtocol().getOverheadWindowUpdateThreshold();
        Object object = this.pendingWindowUpdateForStreamLock;
        synchronized (object) {
            if (n > n3) {
                n2 = n + this.pendingWindowUpdateForStream;
                this.pendingWindowUpdateForStream = 0;
            } else {
                this.pendingWindowUpdateForStream += n;
                if (this.pendingWindowUpdateForStream > n3) {
                    n2 = this.pendingWindowUpdateForStream;
                    this.pendingWindowUpdateForStream = 0;
                } else {
                    n2 = 0;
                }
            }
        }
        return n2;
    }

    public int getUrgency() {
        return this.urgency;
    }

    public void setUrgency(int n) {
        this.urgency = n;
    }

    public boolean getIncremental() {
        return this.incremental;
    }

    public void setIncremental(boolean bl) {
        this.incremental = bl;
    }

    int decrementAndGetActiveRemoteStreamCount() {
        if (this.removedFromActiveCount.compareAndSet(false, true)) {
            return this.handler.activeRemoteStreamCount.decrementAndGet();
        }
        return this.handler.activeRemoteStreamCount.get();
    }

    private static void push(Http2UpgradeHandler http2UpgradeHandler, Request request, Stream stream) throws IOException {
        if (Constants.IS_SECURITY_ENABLED) {
            try {
                AccessController.doPrivileged(new PrivilegedPush(http2UpgradeHandler, request, stream));
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                throw new IOException(privilegedActionException);
            }
        } else {
            http2UpgradeHandler.push(request, stream);
        }
    }

    static {
        HTTP_UPGRADE_STREAM = 1;
        HTTP_CONNECTION_SPECIFIC_HEADERS = new HashSet<String>();
        Response response = new Response();
        response.setStatus(100);
        StreamProcessor.prepareHeaders(null, response, true, null, null);
        ACK_HEADERS = response.getMimeHeaders();
        HTTP_CONNECTION_SPECIFIC_HEADERS.add("connection");
        HTTP_CONNECTION_SPECIFIC_HEADERS.add("proxy-connection");
        HTTP_CONNECTION_SPECIFIC_HEADERS.add("keep-alive");
        HTTP_CONNECTION_SPECIFIC_HEADERS.add("transfer-encoding");
        HTTP_CONNECTION_SPECIFIC_HEADERS.add("upgrade");
    }

    class StreamOutputBuffer
    implements HttpOutputBuffer,
    WriteBuffer.Sink {
        private final Lock writeLock = new ReentrantLock();
        private final ByteBuffer buffer = ByteBuffer.allocate(8192);
        private final WriteBuffer writeBuffer = new WriteBuffer(32768);
        private boolean dataLeft;
        private volatile long written = 0L;
        private int streamReservation = 0;
        private volatile boolean closed = false;
        private volatile StreamException reset = null;
        private volatile boolean endOfStreamSent = false;

        StreamOutputBuffer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int doWrite(ByteBuffer byteBuffer) throws IOException {
            this.writeLock.lock();
            try {
                int n;
                if (this.closed) {
                    throw new IOException(sm.getString("stream.closed", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdAsString()}));
                }
                int n2 = byteBuffer.remaining();
                if (this.writeBuffer.isEmpty()) {
                    n = byteBuffer.limit();
                    while (byteBuffer.remaining() > 0) {
                        int n3 = Math.min(this.buffer.remaining(), byteBuffer.remaining());
                        byteBuffer.limit(byteBuffer.position() + n3);
                        this.buffer.put(byteBuffer);
                        byteBuffer.limit(n);
                        if (byteBuffer.remaining() <= 0 || this.buffer.hasRemaining() || !this.flush(true, Stream.this.coyoteResponse.getWriteListener() == null)) continue;
                        this.writeBuffer.add(byteBuffer);
                        this.dataLeft = true;
                        break;
                    }
                } else {
                    this.writeBuffer.add(byteBuffer);
                }
                this.written += (long)n2;
                n = n2;
                return n;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean flush(boolean bl) throws IOException {
            this.writeLock.lock();
            try {
                boolean bl2 = this.buffer.position() > 0;
                boolean bl3 = false;
                if (bl2) {
                    bl2 = this.flush(false, bl);
                    bl3 = true;
                }
                this.dataLeft = bl2 ? true : (this.writeBuffer.isEmpty() ? (bl3 ? false : this.flush(false, bl)) : this.writeBuffer.write(this, bl));
                boolean bl4 = this.dataLeft;
                return bl4;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean flush(boolean bl, boolean bl2) throws IOException {
            this.writeLock.lock();
            try {
                int n;
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("stream.outputBuffer.flush.debug", new Object[]{Stream.this.getConnectionId(), Stream.this.getIdAsString(), Integer.toString(this.buffer.position()), Boolean.toString(bl), Boolean.toString(this.closed)}));
                }
                if (this.buffer.position() == 0) {
                    if (this.closed && !this.endOfStreamSent) {
                        Stream.this.handler.writeBody(Stream.this, this.buffer, 0, Stream.this.coyoteResponse.getTrailerFields() == null);
                    }
                    boolean bl3 = false;
                    return bl3;
                }
                this.buffer.flip();
                int n2 = this.buffer.remaining();
                while (n2 > 0) {
                    if (this.streamReservation == 0) {
                        this.streamReservation = Stream.this.reserveWindowSize(n2, bl2);
                        if (this.streamReservation == 0) {
                            this.buffer.compact();
                            n = 1;
                            return n != 0;
                        }
                    }
                    while (this.streamReservation > 0) {
                        n = Stream.this.handler.reserveWindowSize(Stream.this, this.streamReservation, bl2);
                        if (n == 0) {
                            this.buffer.compact();
                            boolean bl4 = true;
                            return bl4;
                        }
                        Stream.this.handler.writeBody(Stream.this, this.buffer, n, !bl && this.closed && n2 == n && Stream.this.coyoteResponse.getTrailerFields() == null);
                        this.streamReservation -= n;
                        n2 -= n;
                    }
                }
                this.buffer.clear();
                n = 0;
                return n != 0;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        final boolean isReady() {
            this.writeLock.lock();
            try {
                boolean bl = !(Stream.this.getWindowSize() > 0L && Stream.this.allocationManager.isWaitingForStream() || Stream.this.handler.getWindowSize() > 0L && Stream.this.allocationManager.isWaitingForConnection() || this.dataLeft);
                return bl;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @Override
        public final long getBytesWritten() {
            return this.written;
        }

        @Override
        public final void end() throws IOException {
            if (this.reset != null) {
                throw new CloseNowException(this.reset);
            }
            if (!this.closed) {
                this.closed = true;
                this.flush(true);
                Stream.this.writeTrailers();
            }
        }

        final boolean hasNoBody() {
            return this.written == 0L && this.closed;
        }

        @Override
        public void flush() throws IOException {
            this.flush(Stream.this.getCoyoteResponse().getWriteListener() == null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean writeFromBuffer(ByteBuffer byteBuffer, boolean bl) throws IOException {
            this.writeLock.lock();
            try {
                int n;
                int n2 = byteBuffer.limit();
                while (byteBuffer.remaining() > 0) {
                    n = Math.min(this.buffer.remaining(), byteBuffer.remaining());
                    byteBuffer.limit(byteBuffer.position() + n);
                    this.buffer.put(byteBuffer);
                    byteBuffer.limit(n2);
                    if (!this.flush(false, bl)) continue;
                    boolean bl2 = true;
                    return bl2;
                }
                n = 0;
                return n != 0;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }

    class StandardStreamInputBuffer
    extends StreamInputBuffer {
        private final Lock readStateLock;
        private byte[] outBuffer;
        private volatile ByteBuffer inBuffer;
        private volatile boolean readInterest;
        private volatile long readTimeoutExpiry;
        private volatile boolean closed;
        private volatile boolean resetReceived;

        StandardStreamInputBuffer() {
            this.readStateLock = new ReentrantLock();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
            int n;
            this.ensureBuffersExist();
            ByteBuffer byteBuffer = this.inBuffer;
            if (byteBuffer == null) {
                return -1;
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                if (this.inBuffer == null) {
                    return -1;
                }
                boolean bl = false;
                while (this.inBuffer.position() == 0 && (bl = Stream.this.isActive() && !Stream.this.isInputFinished())) {
                    try {
                        long l;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)sm.getString("stream.inputBuffer.empty"));
                        }
                        if ((l = Stream.this.handler.getProtocol().getStreamReadTimeout()) < 0L) {
                            this.inBuffer.wait();
                        } else {
                            this.inBuffer.wait(l);
                        }
                        if (this.resetReceived) {
                            throw new IOException(sm.getString("stream.inputBuffer.reset"));
                        }
                        if (this.inBuffer.position() != 0 || !Stream.this.isActive() || Stream.this.isInputFinished()) continue;
                        String string = sm.getString("stream.inputBuffer.readTimeout");
                        StreamException streamException = new StreamException(string, Http2Error.ENHANCE_YOUR_CALM, Stream.this.getIdAsInt());
                        Stream.this.coyoteResponse.setError();
                        Stream.this.streamOutputBuffer.reset = streamException;
                        throw new CloseNowException(string, streamException);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new IOException(interruptedException);
                    }
                }
                if (this.inBuffer.position() > 0) {
                    this.inBuffer.flip();
                    n = this.inBuffer.remaining();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)sm.getString("stream.inputBuffer.copy", new Object[]{Integer.toString(n)}));
                    }
                } else {
                    if (!bl) {
                        return -1;
                    }
                    throw new IllegalStateException();
                }
                this.inBuffer.get(this.outBuffer, 0, n);
                this.inBuffer.clear();
            }
            applicationBufferHandler.setByteBuffer(ByteBuffer.wrap(this.outBuffer, 0, n));
            Stream.this.handler.writeWindowUpdate(Stream.this, n, true);
            return n;
        }

        @Override
        final boolean isReadyForRead() {
            this.ensureBuffersExist();
            this.readStateLock.lock();
            try {
                if (this.available() > 0) {
                    boolean bl = true;
                    return bl;
                }
                if (this.resetReceived) {
                    Stream.this.getCoyoteRequest().setAttribute("jakarta.servlet.error.exception", new IOException(sm.getString("stream.clientResetRequest")));
                    Stream.this.coyoteRequest.action(ActionCode.DISPATCH_ERROR, null);
                    Stream.this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
                    boolean bl = false;
                    return bl;
                }
                if (!this.isRequestBodyFullyRead()) {
                    this.readInterest = true;
                    long l = Stream.this.handler.getProtocol().getStreamReadTimeout();
                    this.readTimeoutExpiry = l > 0L ? System.currentTimeMillis() + l : Long.MAX_VALUE;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                this.readStateLock.unlock();
            }
        }

        @Override
        final boolean isRequestBodyFullyRead() {
            this.readStateLock.lock();
            try {
                boolean bl = (this.inBuffer == null || this.inBuffer.position() == 0) && Stream.this.isInputFinished();
                return bl;
            }
            finally {
                this.readStateLock.unlock();
            }
        }

        @Override
        public final int available() {
            this.readStateLock.lock();
            try {
                if (this.inBuffer == null) {
                    int n = 0;
                    return n;
                }
                int n = this.inBuffer.position();
                return n;
            }
            finally {
                this.readStateLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void onDataAvailable() throws IOException {
            block10: {
                this.readStateLock.lock();
                try {
                    if (this.closed) {
                        this.swallowUnread();
                        break block10;
                    }
                    if (this.readInterest) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)sm.getString("stream.inputBuffer.dispatch"));
                        }
                        this.readInterest = false;
                        Stream.this.coyoteRequest.action(ActionCode.DISPATCH_READ, null);
                        Stream.this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
                        break block10;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)sm.getString("stream.inputBuffer.signal"));
                    }
                    ByteBuffer byteBuffer = this.inBuffer;
                    synchronized (byteBuffer) {
                        this.inBuffer.notifyAll();
                    }
                }
                finally {
                    this.readStateLock.unlock();
                }
            }
        }

        @Override
        final ByteBuffer getInBuffer(boolean bl) {
            if (bl) {
                this.ensureBuffersExist();
            }
            return this.inBuffer;
        }

        @Override
        final void insertReplayedBody(ByteChunk byteChunk) {
            this.readStateLock.lock();
            try {
                this.inBuffer = ByteBuffer.wrap(byteChunk.getBytes(), byteChunk.getStart(), byteChunk.getLength());
            }
            finally {
                this.readStateLock.unlock();
            }
        }

        private void ensureBuffersExist() {
            if (this.inBuffer == null && !this.closed) {
                int n = Stream.this.handler.getLocalSettings().getInitialWindowSize();
                this.readStateLock.lock();
                try {
                    if (this.inBuffer == null && !this.closed) {
                        this.inBuffer = ByteBuffer.allocate(n);
                        this.outBuffer = new byte[n];
                    }
                }
                finally {
                    this.readStateLock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void receiveReset() {
            Object object;
            if (this.inBuffer != null) {
                object = this.inBuffer;
                synchronized (object) {
                    this.resetReceived = true;
                    this.inBuffer.notifyAll();
                }
            }
            this.readStateLock.lock();
            try {
                if (this.readInterest) {
                    this.readInterest = false;
                }
            }
            finally {
                this.readStateLock.unlock();
            }
            if (!Stream.this.recycled) {
                object = Stream.this.recycledLock;
                synchronized (object) {
                    if (!Stream.this.recycled) {
                        Stream.this.getCoyoteRequest().setAttribute("jakarta.servlet.error.exception", new IOException(sm.getString("stream.clientResetRequest")));
                        Stream.this.coyoteRequest.action(ActionCode.DISPATCH_ERROR, null);
                        Stream.this.coyoteRequest.action(ActionCode.DISPATCH_EXECUTE, null);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void notifyEof() {
            if (this.inBuffer != null) {
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    this.inBuffer.notifyAll();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void swallowUnread() throws IOException {
            this.readStateLock.lock();
            try {
                this.closed = true;
            }
            finally {
                this.readStateLock.unlock();
            }
            if (this.inBuffer != null) {
                int n;
                ByteBuffer byteBuffer = this.inBuffer;
                synchronized (byteBuffer) {
                    n = this.inBuffer.position();
                    if (log.isTraceEnabled()) {
                        log.trace((Object)sm.getString("stream.inputBuffer.swallowUnread", new Object[]{n}));
                    }
                    if (n > 0) {
                        this.inBuffer.position(0);
                        this.inBuffer.limit(this.inBuffer.limit() - n);
                    }
                }
                if (n > 0) {
                    Stream.this.handler.onSwallowedDataFramePayload(Stream.this.getIdAsInt(), n);
                }
            }
        }

        @Override
        protected boolean timeoutRead(long l) {
            return this.readInterest && l > this.readTimeoutExpiry;
        }
    }

    abstract class StreamInputBuffer
    implements InputBuffer {
        StreamInputBuffer() {
        }

        abstract void receiveReset();

        abstract void swallowUnread() throws IOException;

        abstract void notifyEof();

        @Deprecated
        ByteBuffer getInBuffer() {
            return this.getInBuffer(true);
        }

        abstract ByteBuffer getInBuffer(boolean var1);

        abstract void onDataAvailable() throws IOException;

        abstract boolean isReadyForRead();

        abstract boolean isRequestBodyFullyRead();

        abstract void insertReplayedBody(ByteChunk var1);

        protected abstract boolean timeoutRead(long var1);
    }

    class SavedRequestStreamInputBuffer
    extends StreamInputBuffer {
        private final SavedRequestInputFilter inputFilter;

        SavedRequestStreamInputBuffer(SavedRequestInputFilter savedRequestInputFilter) {
            this.inputFilter = savedRequestInputFilter;
        }

        @Override
        public int doRead(ApplicationBufferHandler applicationBufferHandler) throws IOException {
            return this.inputFilter.doRead(applicationBufferHandler);
        }

        @Override
        public int available() {
            return this.inputFilter.available();
        }

        @Override
        void receiveReset() {
        }

        @Override
        void swallowUnread() throws IOException {
        }

        @Override
        void notifyEof() {
        }

        @Override
        ByteBuffer getInBuffer(boolean bl) {
            return null;
        }

        @Override
        void onDataAvailable() throws IOException {
        }

        @Override
        boolean isReadyForRead() {
            return true;
        }

        @Override
        boolean isRequestBodyFullyRead() {
            return this.inputFilter.isFinished();
        }

        @Override
        void insertReplayedBody(ByteChunk byteChunk) {
        }

        @Override
        protected boolean timeoutRead(long l) {
            return false;
        }
    }

    private static class PrivilegedPush
    implements PrivilegedExceptionAction<Void> {
        private final Http2UpgradeHandler handler;
        private final Request request;
        private final Stream stream;

        PrivilegedPush(Http2UpgradeHandler http2UpgradeHandler, Request request, Stream stream) {
            this.handler = http2UpgradeHandler;
            this.request = request;
            this.stream = stream;
        }

        @Override
        public Void run() throws IOException {
            this.handler.push(this.request, this.stream);
            return null;
        }
    }
}

