/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.util;

import java.security.SecureRandom;
import java.util.Random;
import org.apache.catalina.tribes.util.StringManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class UUIDGenerator {
    private static final Log log = LogFactory.getLog(UUIDGenerator.class);
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.tribes.util");
    public static final int UUID_LENGTH = 16;
    public static final int UUID_VERSION = 4;
    public static final int BYTES_PER_INT = 4;
    public static final int BITS_PER_BYTE = 8;
    protected static final SecureRandom secrand;
    protected static final Random rand;

    public static byte[] randomUUID(boolean bl) {
        byte[] byArray = new byte[16];
        return UUIDGenerator.randomUUID(bl, byArray, 0);
    }

    public static byte[] randomUUID(boolean bl, byte[] byArray, int n) {
        if (n + 16 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException(sm.getString("uuidGenerator.unable.fit", Integer.toString(16), Integer.toString(byArray.length), Integer.toString(n + 16)));
        }
        Random random = bl && secrand != null ? secrand : rand;
        UUIDGenerator.nextBytes(byArray, n, 16, random);
        int n2 = 6 + n;
        byArray[n2] = (byte)(byArray[n2] & 0xF);
        int n3 = 6 + n;
        byArray[n3] = (byte)(byArray[n3] | 0x40);
        int n4 = 8 + n;
        byArray[n4] = (byte)(byArray[n4] & 0x3F);
        int n5 = 8 + n;
        byArray[n5] = (byte)(byArray[n5] | 0xFFFFFF80);
        return byArray;
    }

    public static void nextBytes(byte[] byArray, int n, int n2, Random random) {
        int n3 = 0;
        int n4 = 0;
        block0: while (true) {
            int n5 = 0;
            while (true) {
                if (n5 >= 4) continue block0;
                if (n3 == n2) {
                    return;
                }
                n4 = n5 == 0 ? random.nextInt() : n4 >> 8;
                byArray[n + n3] = (byte)n4;
                ++n3;
                ++n5;
            }
            break;
        }
    }

    static {
        rand = new Random();
        long l = System.currentTimeMillis();
        secrand = new SecureRandom();
        secrand.nextInt();
        long l2 = System.currentTimeMillis() - l;
        if (l2 > 100L) {
            log.info((Object)sm.getString("uuidGenerator.createRandom", secrand.getAlgorithm(), l2));
        }
    }
}

