/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.realm;

import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.catalina.realm.DigestCredentialHandlerBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.buf.HexUtils;

public class SecretKeyCredentialHandler
extends DigestCredentialHandlerBase {
    private static final Log log = LogFactory.getLog(SecretKeyCredentialHandler.class);
    public static final String DEFAULT_ALGORITHM = "PBKDF2WithHmacSHA1";
    public static final int DEFAULT_KEY_LENGTH = 160;
    public static final int DEFAULT_ITERATIONS = 20000;
    private SecretKeyFactory secretKeyFactory;
    private int keyLength = 160;

    public SecretKeyCredentialHandler() throws NoSuchAlgorithmException {
        this.setAlgorithm(DEFAULT_ALGORITHM);
    }

    @Override
    public String getAlgorithm() {
        return this.secretKeyFactory.getAlgorithm();
    }

    @Override
    public void setAlgorithm(String string) throws NoSuchAlgorithmException {
        this.secretKeyFactory = SecretKeyFactory.getInstance(string);
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public void setKeyLength(int n) {
        this.keyLength = n;
    }

    @Override
    public boolean matches(String string, String string2) {
        return this.matchesSaltIterationsEncoded(string, string2);
    }

    @Override
    protected String mutate(String string, byte[] byArray, int n) {
        return this.mutate(string, byArray, n, this.getKeyLength());
    }

    @Override
    protected String mutate(String string, byte[] byArray, int n, int n2) {
        try {
            PBEKeySpec pBEKeySpec = new PBEKeySpec(string.toCharArray(), byArray, n, n2);
            return HexUtils.toHexString((byte[])this.secretKeyFactory.generateSecret(pBEKeySpec).getEncoded());
        }
        catch (IllegalArgumentException | InvalidKeySpecException exception) {
            log.warn((Object)sm.getString("pbeCredentialHandler.invalidKeySpec"), (Throwable)exception);
            return null;
        }
    }

    @Override
    protected int getDefaultIterations() {
        return 20000;
    }

    @Override
    protected Log getLog() {
        return log;
    }
}

