// Generated by `wit-bindgen` 0.51.0. DO NOT EDIT!
#ifndef __BINDINGS_WASIP2_H
#define __BINDINGS_WASIP2_H
#ifdef __cplusplus
extern "C" {
#endif

#include <stdint.h>
#include <stdbool.h>
#include <stddef.h>

typedef struct wasip2_string_t {
  uint8_t*ptr;
  size_t len;
} wasip2_string_t;

typedef struct {
  wasip2_string_t f0;
  wasip2_string_t f1;
} wasip2_tuple2_string_string_t;

typedef struct {
  wasip2_tuple2_string_string_t *ptr;
  size_t len;
} wasip2_list_tuple2_string_string_t;

typedef struct {
  wasip2_string_t *ptr;
  size_t len;
} wasip2_list_string_t;

typedef struct {
  bool is_some;
  wasip2_string_t val;
} wasip2_option_string_t;

typedef struct {
  bool is_err;
} exit_result_void_void_t;

typedef struct io_error_own_error_t {
  int32_t __handle;
} io_error_own_error_t;

typedef struct io_error_borrow_error_t {
  int32_t __handle;
} io_error_borrow_error_t;

typedef struct poll_own_pollable_t {
  int32_t __handle;
} poll_own_pollable_t;

typedef struct poll_borrow_pollable_t {
  int32_t __handle;
} poll_borrow_pollable_t;

typedef struct {
  poll_borrow_pollable_t *ptr;
  size_t len;
} poll_list_borrow_pollable_t;

typedef struct {
  uint32_t *ptr;
  size_t len;
} wasip2_list_u32_t;

typedef io_error_own_error_t streams_own_error_t;

// An error for input-stream and output-stream operations.
typedef struct streams_stream_error_t {
  uint8_t tag;
  union {
    streams_own_error_t     last_operation_failed;
  } val;
} streams_stream_error_t;

// The last operation (a write or flush) failed before completion.
// 
// More information is available in the `error` payload.
#define STREAMS_STREAM_ERROR_LAST_OPERATION_FAILED 0
// The stream is closed: no more input will be accepted by the
// stream. A closed output-stream will return this error on all
// future operations.
#define STREAMS_STREAM_ERROR_CLOSED 1

typedef struct streams_own_input_stream_t {
  int32_t __handle;
} streams_own_input_stream_t;

typedef struct streams_borrow_input_stream_t {
  int32_t __handle;
} streams_borrow_input_stream_t;

typedef struct streams_own_output_stream_t {
  int32_t __handle;
} streams_own_output_stream_t;

typedef struct streams_borrow_output_stream_t {
  int32_t __handle;
} streams_borrow_output_stream_t;

typedef struct {
  uint8_t *ptr;
  size_t len;
} wasip2_list_u8_t;

typedef struct {
  bool is_err;
  union {
    wasip2_list_u8_t ok;
    streams_stream_error_t err;
  } val;
} streams_result_list_u8_stream_error_t;

typedef struct {
  bool is_err;
  union {
    uint64_t ok;
    streams_stream_error_t err;
  } val;
} streams_result_u64_stream_error_t;

typedef poll_own_pollable_t streams_own_pollable_t;

typedef struct {
  bool is_err;
  union {
    streams_stream_error_t err;
  } val;
} streams_result_void_stream_error_t;

typedef streams_own_input_stream_t stdin_own_input_stream_t;

typedef streams_own_output_stream_t stdout_own_output_stream_t;

typedef streams_own_output_stream_t stderr_own_output_stream_t;

typedef struct terminal_input_own_terminal_input_t {
  int32_t __handle;
} terminal_input_own_terminal_input_t;

typedef struct terminal_input_borrow_terminal_input_t {
  int32_t __handle;
} terminal_input_borrow_terminal_input_t;

typedef struct terminal_output_own_terminal_output_t {
  int32_t __handle;
} terminal_output_own_terminal_output_t;

typedef struct terminal_output_borrow_terminal_output_t {
  int32_t __handle;
} terminal_output_borrow_terminal_output_t;

typedef terminal_input_own_terminal_input_t terminal_stdin_own_terminal_input_t;

typedef struct {
  bool is_some;
  terminal_stdin_own_terminal_input_t val;
} terminal_stdin_option_own_terminal_input_t;

typedef terminal_output_own_terminal_output_t terminal_stdout_own_terminal_output_t;

typedef struct {
  bool is_some;
  terminal_stdout_own_terminal_output_t val;
} terminal_stdout_option_own_terminal_output_t;

typedef terminal_output_own_terminal_output_t terminal_stderr_own_terminal_output_t;

typedef struct {
  bool is_some;
  terminal_stderr_own_terminal_output_t val;
} terminal_stderr_option_own_terminal_output_t;

// An instant in time, in nanoseconds. An instant is relative to an
// unspecified initial value, and can only be compared to instances from
// the same monotonic-clock.
typedef uint64_t monotonic_clock_instant_t;

// A duration of time, in nanoseconds.
typedef uint64_t monotonic_clock_duration_t;

typedef poll_own_pollable_t monotonic_clock_own_pollable_t;

// A time and date in seconds plus nanoseconds.
typedef struct wall_clock_datetime_t {
  uint64_t   seconds;
  uint32_t   nanoseconds;
} wall_clock_datetime_t;

typedef wall_clock_datetime_t filesystem_datetime_t;

// File size or length of a region within a file.
typedef uint64_t filesystem_filesize_t;

// The type of a filesystem object referenced by a descriptor.
// 
// Note: This was called `filetype` in earlier versions of WASI.
typedef uint8_t filesystem_descriptor_type_t;

// The type of the descriptor or file is unknown or is different from
// any of the other types specified.
#define FILESYSTEM_DESCRIPTOR_TYPE_UNKNOWN 0
// The descriptor refers to a block device inode.
#define FILESYSTEM_DESCRIPTOR_TYPE_BLOCK_DEVICE 1
// The descriptor refers to a character device inode.
#define FILESYSTEM_DESCRIPTOR_TYPE_CHARACTER_DEVICE 2
// The descriptor refers to a directory inode.
#define FILESYSTEM_DESCRIPTOR_TYPE_DIRECTORY 3
// The descriptor refers to a named pipe.
#define FILESYSTEM_DESCRIPTOR_TYPE_FIFO 4
// The file refers to a symbolic link inode.
#define FILESYSTEM_DESCRIPTOR_TYPE_SYMBOLIC_LINK 5
// The descriptor refers to a regular file inode.
#define FILESYSTEM_DESCRIPTOR_TYPE_REGULAR_FILE 6
// The descriptor refers to a socket.
#define FILESYSTEM_DESCRIPTOR_TYPE_SOCKET 7

// Descriptor flags.
// 
// Note: This was called `fdflags` in earlier versions of WASI.
typedef uint8_t filesystem_descriptor_flags_t;

// Read mode: Data can be read.
#define FILESYSTEM_DESCRIPTOR_FLAGS_READ (1 << 0)
// Write mode: Data can be written to.
#define FILESYSTEM_DESCRIPTOR_FLAGS_WRITE (1 << 1)
// Request that writes be performed according to synchronized I/O file
// integrity completion. The data stored in the file and the file's
// metadata are synchronized. This is similar to `O_SYNC` in POSIX.
// 
// The precise semantics of this operation have not yet been defined for
// WASI. At this time, it should be interpreted as a request, and not a
// requirement.
#define FILESYSTEM_DESCRIPTOR_FLAGS_FILE_INTEGRITY_SYNC (1 << 2)
// Request that writes be performed according to synchronized I/O data
// integrity completion. Only the data stored in the file is
// synchronized. This is similar to `O_DSYNC` in POSIX.
// 
// The precise semantics of this operation have not yet been defined for
// WASI. At this time, it should be interpreted as a request, and not a
// requirement.
#define FILESYSTEM_DESCRIPTOR_FLAGS_DATA_INTEGRITY_SYNC (1 << 3)
// Requests that reads be performed at the same level of integrety
// requested for writes. This is similar to `O_RSYNC` in POSIX.
// 
// The precise semantics of this operation have not yet been defined for
// WASI. At this time, it should be interpreted as a request, and not a
// requirement.
#define FILESYSTEM_DESCRIPTOR_FLAGS_REQUESTED_WRITE_SYNC (1 << 4)
// Mutating directories mode: Directory contents may be mutated.
// 
// When this flag is unset on a descriptor, operations using the
// descriptor which would create, rename, delete, modify the data or
// metadata of filesystem objects, or obtain another handle which
// would permit any of those, shall fail with `error-code::read-only` if
// they would otherwise succeed.
// 
// This may only be set on directories.
#define FILESYSTEM_DESCRIPTOR_FLAGS_MUTATE_DIRECTORY (1 << 5)

// Flags determining the method of how paths are resolved.
typedef uint8_t filesystem_path_flags_t;

// As long as the resolved path corresponds to a symbolic link, it is
// expanded.
#define FILESYSTEM_PATH_FLAGS_SYMLINK_FOLLOW (1 << 0)

// Open flags used by `open-at`.
typedef uint8_t filesystem_open_flags_t;

// Create file if it does not exist, similar to `O_CREAT` in POSIX.
#define FILESYSTEM_OPEN_FLAGS_CREATE (1 << 0)
// Fail if not a directory, similar to `O_DIRECTORY` in POSIX.
#define FILESYSTEM_OPEN_FLAGS_DIRECTORY (1 << 1)
// Fail if file already exists, similar to `O_EXCL` in POSIX.
#define FILESYSTEM_OPEN_FLAGS_EXCLUSIVE (1 << 2)
// Truncate file to size 0, similar to `O_TRUNC` in POSIX.
#define FILESYSTEM_OPEN_FLAGS_TRUNCATE (1 << 3)

// Number of hard links to an inode.
typedef uint64_t filesystem_link_count_t;

typedef struct {
  bool is_some;
  filesystem_datetime_t val;
} filesystem_option_datetime_t;

// File attributes.
// 
// Note: This was called `filestat` in earlier versions of WASI.
typedef struct filesystem_descriptor_stat_t {
  // File type.
  filesystem_descriptor_type_t   type;
  // Number of hard links to the file.
  filesystem_link_count_t   link_count;
  // For regular files, the file size in bytes. For symbolic links, the
  // length in bytes of the pathname contained in the symbolic link.
  filesystem_filesize_t   size;
  // Last data access timestamp.
  // 
  // If the `option` is none, the platform doesn't maintain an access
  // timestamp for this file.
  filesystem_option_datetime_t   data_access_timestamp;
  // Last data modification timestamp.
  // 
  // If the `option` is none, the platform doesn't maintain a
  // modification timestamp for this file.
  filesystem_option_datetime_t   data_modification_timestamp;
  // Last file status-change timestamp.
  // 
  // If the `option` is none, the platform doesn't maintain a
  // status-change timestamp for this file.
  filesystem_option_datetime_t   status_change_timestamp;
} filesystem_descriptor_stat_t;

// When setting a timestamp, this gives the value to set it to.
typedef struct filesystem_new_timestamp_t {
  uint8_t tag;
  union {
    filesystem_datetime_t     timestamp;
  } val;
} filesystem_new_timestamp_t;

// Leave the timestamp set to its previous value.
#define FILESYSTEM_NEW_TIMESTAMP_NO_CHANGE 0
// Set the timestamp to the current time of the system clock associated
// with the filesystem.
#define FILESYSTEM_NEW_TIMESTAMP_NOW 1
// Set the timestamp to the given value.
#define FILESYSTEM_NEW_TIMESTAMP_TIMESTAMP 2

// A directory entry.
typedef struct filesystem_directory_entry_t {
  // The type of the file referred to by this directory entry.
  filesystem_descriptor_type_t   type;
  // The name of the object.
  wasip2_string_t   name;
} filesystem_directory_entry_t;

// Error codes returned by functions, similar to `errno` in POSIX.
// Not all of these error codes are returned by the functions provided by this
// API; some are used in higher-level library layers, and others are provided
// merely for alignment with POSIX.
typedef uint8_t filesystem_error_code_t;

// Permission denied, similar to `EACCES` in POSIX.
#define FILESYSTEM_ERROR_CODE_ACCESS 0
// Resource unavailable, or operation would block, similar to `EAGAIN` and `EWOULDBLOCK` in POSIX.
#define FILESYSTEM_ERROR_CODE_WOULD_BLOCK 1
// Connection already in progress, similar to `EALREADY` in POSIX.
#define FILESYSTEM_ERROR_CODE_ALREADY 2
// Bad descriptor, similar to `EBADF` in POSIX.
#define FILESYSTEM_ERROR_CODE_BAD_DESCRIPTOR 3
// Device or resource busy, similar to `EBUSY` in POSIX.
#define FILESYSTEM_ERROR_CODE_BUSY 4
// Resource deadlock would occur, similar to `EDEADLK` in POSIX.
#define FILESYSTEM_ERROR_CODE_DEADLOCK 5
// Storage quota exceeded, similar to `EDQUOT` in POSIX.
#define FILESYSTEM_ERROR_CODE_QUOTA 6
// File exists, similar to `EEXIST` in POSIX.
#define FILESYSTEM_ERROR_CODE_EXIST 7
// File too large, similar to `EFBIG` in POSIX.
#define FILESYSTEM_ERROR_CODE_FILE_TOO_LARGE 8
// Illegal byte sequence, similar to `EILSEQ` in POSIX.
#define FILESYSTEM_ERROR_CODE_ILLEGAL_BYTE_SEQUENCE 9
// Operation in progress, similar to `EINPROGRESS` in POSIX.
#define FILESYSTEM_ERROR_CODE_IN_PROGRESS 10
// Interrupted function, similar to `EINTR` in POSIX.
#define FILESYSTEM_ERROR_CODE_INTERRUPTED 11
// Invalid argument, similar to `EINVAL` in POSIX.
#define FILESYSTEM_ERROR_CODE_INVALID 12
// I/O error, similar to `EIO` in POSIX.
#define FILESYSTEM_ERROR_CODE_IO 13
// Is a directory, similar to `EISDIR` in POSIX.
#define FILESYSTEM_ERROR_CODE_IS_DIRECTORY 14
// Too many levels of symbolic links, similar to `ELOOP` in POSIX.
#define FILESYSTEM_ERROR_CODE_LOOP 15
// Too many links, similar to `EMLINK` in POSIX.
#define FILESYSTEM_ERROR_CODE_TOO_MANY_LINKS 16
// Message too large, similar to `EMSGSIZE` in POSIX.
#define FILESYSTEM_ERROR_CODE_MESSAGE_SIZE 17
// Filename too long, similar to `ENAMETOOLONG` in POSIX.
#define FILESYSTEM_ERROR_CODE_NAME_TOO_LONG 18
// No such device, similar to `ENODEV` in POSIX.
#define FILESYSTEM_ERROR_CODE_NO_DEVICE 19
// No such file or directory, similar to `ENOENT` in POSIX.
#define FILESYSTEM_ERROR_CODE_NO_ENTRY 20
// No locks available, similar to `ENOLCK` in POSIX.
#define FILESYSTEM_ERROR_CODE_NO_LOCK 21
// Not enough space, similar to `ENOMEM` in POSIX.
#define FILESYSTEM_ERROR_CODE_INSUFFICIENT_MEMORY 22
// No space left on device, similar to `ENOSPC` in POSIX.
#define FILESYSTEM_ERROR_CODE_INSUFFICIENT_SPACE 23
// Not a directory or a symbolic link to a directory, similar to `ENOTDIR` in POSIX.
#define FILESYSTEM_ERROR_CODE_NOT_DIRECTORY 24
// Directory not empty, similar to `ENOTEMPTY` in POSIX.
#define FILESYSTEM_ERROR_CODE_NOT_EMPTY 25
// State not recoverable, similar to `ENOTRECOVERABLE` in POSIX.
#define FILESYSTEM_ERROR_CODE_NOT_RECOVERABLE 26
// Not supported, similar to `ENOTSUP` and `ENOSYS` in POSIX.
#define FILESYSTEM_ERROR_CODE_UNSUPPORTED 27
// Inappropriate I/O control operation, similar to `ENOTTY` in POSIX.
#define FILESYSTEM_ERROR_CODE_NO_TTY 28
// No such device or address, similar to `ENXIO` in POSIX.
#define FILESYSTEM_ERROR_CODE_NO_SUCH_DEVICE 29
// Value too large to be stored in data type, similar to `EOVERFLOW` in POSIX.
#define FILESYSTEM_ERROR_CODE_OVERFLOW 30
// Operation not permitted, similar to `EPERM` in POSIX.
#define FILESYSTEM_ERROR_CODE_NOT_PERMITTED 31
// Broken pipe, similar to `EPIPE` in POSIX.
#define FILESYSTEM_ERROR_CODE_PIPE 32
// Read-only file system, similar to `EROFS` in POSIX.
#define FILESYSTEM_ERROR_CODE_READ_ONLY 33
// Invalid seek, similar to `ESPIPE` in POSIX.
#define FILESYSTEM_ERROR_CODE_INVALID_SEEK 34
// Text file busy, similar to `ETXTBSY` in POSIX.
#define FILESYSTEM_ERROR_CODE_TEXT_FILE_BUSY 35
// Cross-device link, similar to `EXDEV` in POSIX.
#define FILESYSTEM_ERROR_CODE_CROSS_DEVICE 36

// File or memory access pattern advisory information.
typedef uint8_t filesystem_advice_t;

// The application has no advice to give on its behavior with respect
// to the specified data.
#define FILESYSTEM_ADVICE_NORMAL 0
// The application expects to access the specified data sequentially
// from lower offsets to higher offsets.
#define FILESYSTEM_ADVICE_SEQUENTIAL 1
// The application expects to access the specified data in a random
// order.
#define FILESYSTEM_ADVICE_RANDOM 2
// The application expects to access the specified data in the near
// future.
#define FILESYSTEM_ADVICE_WILL_NEED 3
// The application expects that it will not access the specified data
// in the near future.
#define FILESYSTEM_ADVICE_DONT_NEED 4
// The application expects to access the specified data once and then
// not reuse it thereafter.
#define FILESYSTEM_ADVICE_NO_REUSE 5

// A 128-bit hash value, split into parts because wasm doesn't have a
// 128-bit integer type.
typedef struct filesystem_metadata_hash_value_t {
  // 64 bits of a 128-bit hash value.
  uint64_t   lower;
  // Another 64 bits of a 128-bit hash value.
  uint64_t   upper;
} filesystem_metadata_hash_value_t;

typedef struct filesystem_own_descriptor_t {
  int32_t __handle;
} filesystem_own_descriptor_t;

typedef struct filesystem_borrow_descriptor_t {
  int32_t __handle;
} filesystem_borrow_descriptor_t;

typedef struct filesystem_own_directory_entry_stream_t {
  int32_t __handle;
} filesystem_own_directory_entry_stream_t;

typedef struct filesystem_borrow_directory_entry_stream_t {
  int32_t __handle;
} filesystem_borrow_directory_entry_stream_t;

typedef streams_own_input_stream_t filesystem_own_input_stream_t;

typedef struct {
  bool is_err;
  union {
    filesystem_own_input_stream_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_own_input_stream_error_code_t;

typedef streams_own_output_stream_t filesystem_own_output_stream_t;

typedef struct {
  bool is_err;
  union {
    filesystem_own_output_stream_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_own_output_stream_error_code_t;

typedef struct {
  bool is_err;
  union {
    filesystem_error_code_t err;
  } val;
} filesystem_result_void_error_code_t;

typedef struct {
  bool is_err;
  union {
    filesystem_descriptor_flags_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_descriptor_flags_error_code_t;

typedef struct {
  bool is_err;
  union {
    filesystem_descriptor_type_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_descriptor_type_error_code_t;

typedef struct {
  wasip2_list_u8_t f0;
  bool f1;
} wasip2_tuple2_list_u8_bool_t;

typedef struct {
  bool is_err;
  union {
    wasip2_tuple2_list_u8_bool_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_tuple2_list_u8_bool_error_code_t;

typedef struct {
  bool is_err;
  union {
    filesystem_filesize_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_filesize_error_code_t;

typedef struct {
  bool is_err;
  union {
    filesystem_own_directory_entry_stream_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_own_directory_entry_stream_error_code_t;

typedef struct {
  bool is_err;
  union {
    filesystem_descriptor_stat_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_descriptor_stat_error_code_t;

typedef struct {
  bool is_err;
  union {
    filesystem_own_descriptor_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_own_descriptor_error_code_t;

typedef struct {
  bool is_err;
  union {
    wasip2_string_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_string_error_code_t;

typedef struct {
  bool is_err;
  union {
    filesystem_metadata_hash_value_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_metadata_hash_value_error_code_t;

typedef struct {
  bool is_some;
  filesystem_directory_entry_t val;
} filesystem_option_directory_entry_t;

typedef struct {
  bool is_err;
  union {
    filesystem_option_directory_entry_t ok;
    filesystem_error_code_t err;
  } val;
} filesystem_result_option_directory_entry_error_code_t;

typedef io_error_borrow_error_t filesystem_borrow_error_t;

typedef struct {
  bool is_some;
  filesystem_error_code_t val;
} filesystem_option_error_code_t;

typedef filesystem_own_descriptor_t filesystem_preopens_own_descriptor_t;

typedef struct {
  filesystem_preopens_own_descriptor_t f0;
  wasip2_string_t f1;
} filesystem_preopens_tuple2_own_descriptor_string_t;

typedef struct {
  filesystem_preopens_tuple2_own_descriptor_string_t *ptr;
  size_t len;
} filesystem_preopens_list_tuple2_own_descriptor_string_t;

typedef struct network_own_network_t {
  int32_t __handle;
} network_own_network_t;

typedef struct network_borrow_network_t {
  int32_t __handle;
} network_borrow_network_t;

// Error codes.
// 
// In theory, every API can return any error code.
// In practice, API's typically only return the errors documented per API
// combined with a couple of errors that are always possible:
// - `unknown`
// - `access-denied`
// - `not-supported`
// - `out-of-memory`
// - `concurrency-conflict`
// 
// See each individual API for what the POSIX equivalents are. They sometimes differ per API.
typedef uint8_t network_error_code_t;

// Unknown error
#define NETWORK_ERROR_CODE_UNKNOWN 0
// Access denied.
// 
// POSIX equivalent: EACCES, EPERM
#define NETWORK_ERROR_CODE_ACCESS_DENIED 1
// The operation is not supported.
// 
// POSIX equivalent: EOPNOTSUPP
#define NETWORK_ERROR_CODE_NOT_SUPPORTED 2
// One of the arguments is invalid.
// 
// POSIX equivalent: EINVAL
#define NETWORK_ERROR_CODE_INVALID_ARGUMENT 3
// Not enough memory to complete the operation.
// 
// POSIX equivalent: ENOMEM, ENOBUFS, EAI_MEMORY
#define NETWORK_ERROR_CODE_OUT_OF_MEMORY 4
// The operation timed out before it could finish completely.
#define NETWORK_ERROR_CODE_TIMEOUT 5
// This operation is incompatible with another asynchronous operation that is already in progress.
// 
// POSIX equivalent: EALREADY
#define NETWORK_ERROR_CODE_CONCURRENCY_CONFLICT 6
// Trying to finish an asynchronous operation that:
// - has not been started yet, or:
// - was already finished by a previous `finish-*` call.
// 
// Note: this is scheduled to be removed when `future`s are natively supported.
#define NETWORK_ERROR_CODE_NOT_IN_PROGRESS 7
// The operation has been aborted because it could not be completed immediately.
// 
// Note: this is scheduled to be removed when `future`s are natively supported.
#define NETWORK_ERROR_CODE_WOULD_BLOCK 8
// The operation is not valid in the socket's current state.
#define NETWORK_ERROR_CODE_INVALID_STATE 9
// A new socket resource could not be created because of a system limit.
#define NETWORK_ERROR_CODE_NEW_SOCKET_LIMIT 10
// A bind operation failed because the provided address is not an address that the `network` can bind to.
#define NETWORK_ERROR_CODE_ADDRESS_NOT_BINDABLE 11
// A bind operation failed because the provided address is already in use or because there are no ephemeral ports available.
#define NETWORK_ERROR_CODE_ADDRESS_IN_USE 12
// The remote address is not reachable
#define NETWORK_ERROR_CODE_REMOTE_UNREACHABLE 13
// The TCP connection was forcefully rejected
#define NETWORK_ERROR_CODE_CONNECTION_REFUSED 14
// The TCP connection was reset.
#define NETWORK_ERROR_CODE_CONNECTION_RESET 15
// A TCP connection was aborted.
#define NETWORK_ERROR_CODE_CONNECTION_ABORTED 16
// The size of a datagram sent to a UDP socket exceeded the maximum
// supported size.
#define NETWORK_ERROR_CODE_DATAGRAM_TOO_LARGE 17
// Name does not exist or has no suitable associated IP addresses.
#define NETWORK_ERROR_CODE_NAME_UNRESOLVABLE 18
// A temporary failure in name resolution occurred.
#define NETWORK_ERROR_CODE_TEMPORARY_RESOLVER_FAILURE 19
// A permanent failure in name resolution occurred.
#define NETWORK_ERROR_CODE_PERMANENT_RESOLVER_FAILURE 20

typedef uint8_t network_ip_address_family_t;

// Similar to `AF_INET` in POSIX.
#define NETWORK_IP_ADDRESS_FAMILY_IPV4 0
// Similar to `AF_INET6` in POSIX.
#define NETWORK_IP_ADDRESS_FAMILY_IPV6 1

typedef struct network_ipv4_address_t {
  uint8_t   f0;
  uint8_t   f1;
  uint8_t   f2;
  uint8_t   f3;
} network_ipv4_address_t;

typedef struct network_ipv6_address_t {
  uint16_t   f0;
  uint16_t   f1;
  uint16_t   f2;
  uint16_t   f3;
  uint16_t   f4;
  uint16_t   f5;
  uint16_t   f6;
  uint16_t   f7;
} network_ipv6_address_t;

typedef struct network_ip_address_t {
  uint8_t tag;
  union {
    network_ipv4_address_t     ipv4;
    network_ipv6_address_t     ipv6;
  } val;
} network_ip_address_t;

#define NETWORK_IP_ADDRESS_IPV4 0
#define NETWORK_IP_ADDRESS_IPV6 1

typedef struct network_ipv4_socket_address_t {
  // sin_port
  uint16_t   port;
  // sin_addr
  network_ipv4_address_t   address;
} network_ipv4_socket_address_t;

typedef struct network_ipv6_socket_address_t {
  // sin6_port
  uint16_t   port;
  // sin6_flowinfo
  uint32_t   flow_info;
  // sin6_addr
  network_ipv6_address_t   address;
  // sin6_scope_id
  uint32_t   scope_id;
} network_ipv6_socket_address_t;

typedef struct network_ip_socket_address_t {
  uint8_t tag;
  union {
    network_ipv4_socket_address_t     ipv4;
    network_ipv6_socket_address_t     ipv6;
  } val;
} network_ip_socket_address_t;

#define NETWORK_IP_SOCKET_ADDRESS_IPV4 0
#define NETWORK_IP_SOCKET_ADDRESS_IPV6 1

typedef network_own_network_t instance_network_own_network_t;

typedef network_error_code_t udp_error_code_t;

typedef network_ip_socket_address_t udp_ip_socket_address_t;

typedef network_ip_address_family_t udp_ip_address_family_t;

// A received datagram.
typedef struct udp_incoming_datagram_t {
  // The payload.
  // 
  // Theoretical max size: ~64 KiB. In practice, typically less than 1500 bytes.
  wasip2_list_u8_t   data;
  // The source address.
  // 
  // This field is guaranteed to match the remote address the stream was initialized with, if any.
  // 
  // Equivalent to the `src_addr` out parameter of `recvfrom`.
  udp_ip_socket_address_t   remote_address;
} udp_incoming_datagram_t;

typedef struct {
  bool is_some;
  udp_ip_socket_address_t val;
} udp_option_ip_socket_address_t;

// A datagram to be sent out.
typedef struct udp_outgoing_datagram_t {
  // The payload.
  wasip2_list_u8_t   data;
  // The destination address.
  // 
  // The requirements on this field depend on how the stream was initialized:
  // - with a remote address: this field must be None or match the stream's remote address exactly.
  // - without a remote address: this field is required.
  // 
  // If this value is None, the send operation is equivalent to `send` in POSIX. Otherwise it is equivalent to `sendto`.
  udp_option_ip_socket_address_t   remote_address;
} udp_outgoing_datagram_t;

typedef struct udp_own_udp_socket_t {
  int32_t __handle;
} udp_own_udp_socket_t;

typedef struct udp_borrow_udp_socket_t {
  int32_t __handle;
} udp_borrow_udp_socket_t;

typedef struct udp_own_incoming_datagram_stream_t {
  int32_t __handle;
} udp_own_incoming_datagram_stream_t;

typedef struct udp_borrow_incoming_datagram_stream_t {
  int32_t __handle;
} udp_borrow_incoming_datagram_stream_t;

typedef struct udp_own_outgoing_datagram_stream_t {
  int32_t __handle;
} udp_own_outgoing_datagram_stream_t;

typedef struct udp_borrow_outgoing_datagram_stream_t {
  int32_t __handle;
} udp_borrow_outgoing_datagram_stream_t;

typedef network_borrow_network_t udp_borrow_network_t;

typedef struct {
  bool is_err;
  union {
    udp_error_code_t err;
  } val;
} udp_result_void_error_code_t;

typedef struct {
  udp_own_incoming_datagram_stream_t f0;
  udp_own_outgoing_datagram_stream_t f1;
} udp_tuple2_own_incoming_datagram_stream_own_outgoing_datagram_stream_t;

typedef struct {
  bool is_err;
  union {
    udp_tuple2_own_incoming_datagram_stream_own_outgoing_datagram_stream_t ok;
    udp_error_code_t err;
  } val;
} udp_result_tuple2_own_incoming_datagram_stream_own_outgoing_datagram_stream_error_code_t;

typedef struct {
  bool is_err;
  union {
    udp_ip_socket_address_t ok;
    udp_error_code_t err;
  } val;
} udp_result_ip_socket_address_error_code_t;

typedef struct {
  bool is_err;
  union {
    uint8_t ok;
    udp_error_code_t err;
  } val;
} udp_result_u8_error_code_t;

typedef struct {
  bool is_err;
  union {
    uint64_t ok;
    udp_error_code_t err;
  } val;
} udp_result_u64_error_code_t;

typedef poll_own_pollable_t udp_own_pollable_t;

typedef struct {
  udp_incoming_datagram_t *ptr;
  size_t len;
} udp_list_incoming_datagram_t;

typedef struct {
  bool is_err;
  union {
    udp_list_incoming_datagram_t ok;
    udp_error_code_t err;
  } val;
} udp_result_list_incoming_datagram_error_code_t;

typedef struct {
  udp_outgoing_datagram_t *ptr;
  size_t len;
} udp_list_outgoing_datagram_t;

typedef network_error_code_t udp_create_socket_error_code_t;

typedef network_ip_address_family_t udp_create_socket_ip_address_family_t;

typedef udp_own_udp_socket_t udp_create_socket_own_udp_socket_t;

typedef struct {
  bool is_err;
  union {
    udp_create_socket_own_udp_socket_t ok;
    udp_create_socket_error_code_t err;
  } val;
} udp_create_socket_result_own_udp_socket_error_code_t;

typedef monotonic_clock_duration_t tcp_duration_t;

typedef network_error_code_t tcp_error_code_t;

typedef network_ip_socket_address_t tcp_ip_socket_address_t;

typedef network_ip_address_family_t tcp_ip_address_family_t;

typedef uint8_t tcp_shutdown_type_t;

// Similar to `SHUT_RD` in POSIX.
#define TCP_SHUTDOWN_TYPE_RECEIVE 0
// Similar to `SHUT_WR` in POSIX.
#define TCP_SHUTDOWN_TYPE_SEND 1
// Similar to `SHUT_RDWR` in POSIX.
#define TCP_SHUTDOWN_TYPE_BOTH 2

typedef struct tcp_own_tcp_socket_t {
  int32_t __handle;
} tcp_own_tcp_socket_t;

typedef struct tcp_borrow_tcp_socket_t {
  int32_t __handle;
} tcp_borrow_tcp_socket_t;

typedef network_borrow_network_t tcp_borrow_network_t;

typedef struct {
  bool is_err;
  union {
    tcp_error_code_t err;
  } val;
} tcp_result_void_error_code_t;

typedef streams_own_input_stream_t tcp_own_input_stream_t;

typedef streams_own_output_stream_t tcp_own_output_stream_t;

typedef struct {
  tcp_own_input_stream_t f0;
  tcp_own_output_stream_t f1;
} tcp_tuple2_own_input_stream_own_output_stream_t;

typedef struct {
  bool is_err;
  union {
    tcp_tuple2_own_input_stream_own_output_stream_t ok;
    tcp_error_code_t err;
  } val;
} tcp_result_tuple2_own_input_stream_own_output_stream_error_code_t;

typedef struct {
  tcp_own_tcp_socket_t f0;
  tcp_own_input_stream_t f1;
  tcp_own_output_stream_t f2;
} tcp_tuple3_own_tcp_socket_own_input_stream_own_output_stream_t;

typedef struct {
  bool is_err;
  union {
    tcp_tuple3_own_tcp_socket_own_input_stream_own_output_stream_t ok;
    tcp_error_code_t err;
  } val;
} tcp_result_tuple3_own_tcp_socket_own_input_stream_own_output_stream_error_code_t;

typedef struct {
  bool is_err;
  union {
    tcp_ip_socket_address_t ok;
    tcp_error_code_t err;
  } val;
} tcp_result_ip_socket_address_error_code_t;

typedef struct {
  bool is_err;
  union {
    bool ok;
    tcp_error_code_t err;
  } val;
} tcp_result_bool_error_code_t;

typedef struct {
  bool is_err;
  union {
    tcp_duration_t ok;
    tcp_error_code_t err;
  } val;
} tcp_result_duration_error_code_t;

typedef struct {
  bool is_err;
  union {
    uint32_t ok;
    tcp_error_code_t err;
  } val;
} tcp_result_u32_error_code_t;

typedef struct {
  bool is_err;
  union {
    uint8_t ok;
    tcp_error_code_t err;
  } val;
} tcp_result_u8_error_code_t;

typedef struct {
  bool is_err;
  union {
    uint64_t ok;
    tcp_error_code_t err;
  } val;
} tcp_result_u64_error_code_t;

typedef poll_own_pollable_t tcp_own_pollable_t;

typedef network_error_code_t tcp_create_socket_error_code_t;

typedef network_ip_address_family_t tcp_create_socket_ip_address_family_t;

typedef tcp_own_tcp_socket_t tcp_create_socket_own_tcp_socket_t;

typedef struct {
  bool is_err;
  union {
    tcp_create_socket_own_tcp_socket_t ok;
    tcp_create_socket_error_code_t err;
  } val;
} tcp_create_socket_result_own_tcp_socket_error_code_t;

typedef network_error_code_t ip_name_lookup_error_code_t;

typedef network_ip_address_t ip_name_lookup_ip_address_t;

typedef struct ip_name_lookup_own_resolve_address_stream_t {
  int32_t __handle;
} ip_name_lookup_own_resolve_address_stream_t;

typedef struct ip_name_lookup_borrow_resolve_address_stream_t {
  int32_t __handle;
} ip_name_lookup_borrow_resolve_address_stream_t;

typedef struct {
  bool is_some;
  ip_name_lookup_ip_address_t val;
} ip_name_lookup_option_ip_address_t;

typedef struct {
  bool is_err;
  union {
    ip_name_lookup_option_ip_address_t ok;
    ip_name_lookup_error_code_t err;
  } val;
} ip_name_lookup_result_option_ip_address_error_code_t;

typedef poll_own_pollable_t ip_name_lookup_own_pollable_t;

typedef network_borrow_network_t ip_name_lookup_borrow_network_t;

typedef struct {
  bool is_err;
  union {
    ip_name_lookup_own_resolve_address_stream_t ok;
    ip_name_lookup_error_code_t err;
  } val;
} ip_name_lookup_result_own_resolve_address_stream_error_code_t;

typedef struct {
  uint64_t f0;
  uint64_t f1;
} wasip2_tuple2_u64_u64_t;

// Imported Functions from `wasi:cli/environment@0.2.0`
// Get the POSIX-style environment variables.
// 
// Each environment variable is provided as a pair of string variable names
// and string value.
// 
// Morally, these are a value import, but until value imports are available
// in the component model, this import function should return the same
// values each time it is called.
extern void environment_get_environment(wasip2_list_tuple2_string_string_t *ret);
// Get the POSIX-style arguments to the program.
extern void environment_get_arguments(wasip2_list_string_t *ret);
// Return a path that programs should use as their initial current working
// directory, interpreting `.` as shorthand for this.
extern bool environment_initial_cwd(wasip2_string_t *ret);

// Imported Functions from `wasi:cli/exit@0.2.0`
// Exit the current instance and any linked instances.
_Noreturn extern void exit_exit(exit_result_void_void_t *status);

// Imported Functions from `wasi:io/error@0.2.0`
// Returns a string that is suitable to assist humans in debugging
// this error.
// 
// WARNING: The returned string should not be consumed mechanically!
// It may change across platforms, hosts, or other implementation
// details. Parsing this string is a major platform-compatibility
// hazard.
extern void io_error_method_error_to_debug_string(io_error_borrow_error_t self, wasip2_string_t *ret);

// Imported Functions from `wasi:io/poll@0.2.0`
// Return the readiness of a pollable. This function never blocks.
// 
// Returns `true` when the pollable is ready, and `false` otherwise.
extern bool poll_method_pollable_ready(poll_borrow_pollable_t self);
// `block` returns immediately if the pollable is ready, and otherwise
// blocks until ready.
// 
// This function is equivalent to calling `poll.poll` on a list
// containing only this pollable.
extern void poll_method_pollable_block(poll_borrow_pollable_t self);
// Poll for completion on a set of pollables.
// 
// This function takes a list of pollables, which identify I/O sources of
// interest, and waits until one or more of the events is ready for I/O.
// 
// The result `list<u32>` contains one or more indices of handles in the
// argument list that is ready for I/O.
// 
// If the list contains more elements than can be indexed with a `u32`
// value, this function traps.
// 
// A timeout can be implemented by adding a pollable from the
// wasi-clocks API to the list.
// 
// This function does not return a `result`; polling in itself does not
// do any I/O so it doesn't fail. If any of the I/O sources identified by
// the pollables has an error, it is indicated by marking the source as
// being reaedy for I/O.
extern void poll_poll(poll_list_borrow_pollable_t *in, wasip2_list_u32_t *ret);

// Imported Functions from `wasi:io/streams@0.2.0`
// Perform a non-blocking read from the stream.
// 
// When the source of a `read` is binary data, the bytes from the source
// are returned verbatim. When the source of a `read` is known to the
// implementation to be text, bytes containing the UTF-8 encoding of the
// text are returned.
// 
// This function returns a list of bytes containing the read data,
// when successful. The returned list will contain up to `len` bytes;
// it may return fewer than requested, but not more. The list is
// empty when no bytes are available for reading at this time. The
// pollable given by `subscribe` will be ready when more bytes are
// available.
// 
// This function fails with a `stream-error` when the operation
// encounters an error, giving `last-operation-failed`, or when the
// stream is closed, giving `closed`.
// 
// When the caller gives a `len` of 0, it represents a request to
// read 0 bytes. If the stream is still open, this call should
// succeed and return an empty list, or otherwise fail with `closed`.
// 
// The `len` parameter is a `u64`, which could represent a list of u8 which
// is not possible to allocate in wasm32, or not desirable to allocate as
// as a return value by the callee. The callee may return a list of bytes
// less than `len` in size while more bytes are available for reading.
extern bool streams_method_input_stream_read(streams_borrow_input_stream_t self, uint64_t len, wasip2_list_u8_t *ret, streams_stream_error_t *err);
// Read bytes from a stream, after blocking until at least one byte can
// be read. Except for blocking, behavior is identical to `read`.
extern bool streams_method_input_stream_blocking_read(streams_borrow_input_stream_t self, uint64_t len, wasip2_list_u8_t *ret, streams_stream_error_t *err);
// Skip bytes from a stream. Returns number of bytes skipped.
// 
// Behaves identical to `read`, except instead of returning a list
// of bytes, returns the number of bytes consumed from the stream.
extern bool streams_method_input_stream_skip(streams_borrow_input_stream_t self, uint64_t len, uint64_t *ret, streams_stream_error_t *err);
// Skip bytes from a stream, after blocking until at least one byte
// can be skipped. Except for blocking behavior, identical to `skip`.
extern bool streams_method_input_stream_blocking_skip(streams_borrow_input_stream_t self, uint64_t len, uint64_t *ret, streams_stream_error_t *err);
// Create a `pollable` which will resolve once either the specified stream
// has bytes available to read or the other end of the stream has been
// closed.
// The created `pollable` is a child resource of the `input-stream`.
// Implementations may trap if the `input-stream` is dropped before
// all derived `pollable`s created with this function are dropped.
extern streams_own_pollable_t streams_method_input_stream_subscribe(streams_borrow_input_stream_t self);
// Check readiness for writing. This function never blocks.
// 
// Returns the number of bytes permitted for the next call to `write`,
// or an error. Calling `write` with more bytes than this function has
// permitted will trap.
// 
// When this function returns 0 bytes, the `subscribe` pollable will
// become ready when this function will report at least 1 byte, or an
// error.
extern bool streams_method_output_stream_check_write(streams_borrow_output_stream_t self, uint64_t *ret, streams_stream_error_t *err);
// Perform a write. This function never blocks.
// 
// When the destination of a `write` is binary data, the bytes from
// `contents` are written verbatim. When the destination of a `write` is
// known to the implementation to be text, the bytes of `contents` are
// transcoded from UTF-8 into the encoding of the destination and then
// written.
// 
// Precondition: check-write gave permit of Ok(n) and contents has a
// length of less than or equal to n. Otherwise, this function will trap.
// 
// returns Err(closed) without writing if the stream has closed since
// the last call to check-write provided a permit.
extern bool streams_method_output_stream_write(streams_borrow_output_stream_t self, wasip2_list_u8_t *contents, streams_stream_error_t *err);
// Perform a write of up to 4096 bytes, and then flush the stream. Block
// until all of these operations are complete, or an error occurs.
// 
// This is a convenience wrapper around the use of `check-write`,
// `subscribe`, `write`, and `flush`, and is implemented with the
// following pseudo-code:
// 
// ```text
// let pollable = this.subscribe();
// while !contents.is_empty() {
// // Wait for the stream to become writable
// pollable.block();
// let Ok(n) = this.check-write(); // eliding error handling
// let len = min(n, contents.len());
// let (chunk, rest) = contents.split_at(len);
// this.write(chunk  );            // eliding error handling
// contents = rest;
// }
// this.flush();
// // Wait for completion of `flush`
// pollable.block();
// // Check for any errors that arose during `flush`
// let _ = this.check-write();         // eliding error handling
// ```
extern bool streams_method_output_stream_blocking_write_and_flush(streams_borrow_output_stream_t self, wasip2_list_u8_t *contents, streams_stream_error_t *err);
// Request to flush buffered output. This function never blocks.
// 
// This tells the output-stream that the caller intends any buffered
// output to be flushed. the output which is expected to be flushed
// is all that has been passed to `write` prior to this call.
// 
// Upon calling this function, the `output-stream` will not accept any
// writes (`check-write` will return `ok(0)`) until the flush has
// completed. The `subscribe` pollable will become ready when the
// flush has completed and the stream can accept more writes.
extern bool streams_method_output_stream_flush(streams_borrow_output_stream_t self, streams_stream_error_t *err);
// Request to flush buffered output, and block until flush completes
// and stream is ready for writing again.
extern bool streams_method_output_stream_blocking_flush(streams_borrow_output_stream_t self, streams_stream_error_t *err);
// Create a `pollable` which will resolve once the output-stream
// is ready for more writing, or an error has occured. When this
// pollable is ready, `check-write` will return `ok(n)` with n>0, or an
// error.
// 
// If the stream is closed, this pollable is always ready immediately.
// 
// The created `pollable` is a child resource of the `output-stream`.
// Implementations may trap if the `output-stream` is dropped before
// all derived `pollable`s created with this function are dropped.
extern streams_own_pollable_t streams_method_output_stream_subscribe(streams_borrow_output_stream_t self);
// Write zeroes to a stream.
// 
// This should be used precisely like `write` with the exact same
// preconditions (must use check-write first), but instead of
// passing a list of bytes, you simply pass the number of zero-bytes
// that should be written.
extern bool streams_method_output_stream_write_zeroes(streams_borrow_output_stream_t self, uint64_t len, streams_stream_error_t *err);
// Perform a write of up to 4096 zeroes, and then flush the stream.
// Block until all of these operations are complete, or an error
// occurs.
// 
// This is a convenience wrapper around the use of `check-write`,
// `subscribe`, `write-zeroes`, and `flush`, and is implemented with
// the following pseudo-code:
// 
// ```text
// let pollable = this.subscribe();
// while num_zeroes != 0 {
// // Wait for the stream to become writable
// pollable.block();
// let Ok(n) = this.check-write(); // eliding error handling
// let len = min(n, num_zeroes);
// this.write-zeroes(len);         // eliding error handling
// num_zeroes -= len;
// }
// this.flush();
// // Wait for completion of `flush`
// pollable.block();
// // Check for any errors that arose during `flush`
// let _ = this.check-write();         // eliding error handling
// ```
extern bool streams_method_output_stream_blocking_write_zeroes_and_flush(streams_borrow_output_stream_t self, uint64_t len, streams_stream_error_t *err);
// Read from one stream and write to another.
// 
// The behavior of splice is equivelant to:
// 1. calling `check-write` on the `output-stream`
// 2. calling `read` on the `input-stream` with the smaller of the
// `check-write` permitted length and the `len` provided to `splice`
// 3. calling `write` on the `output-stream` with that read data.
// 
// Any error reported by the call to `check-write`, `read`, or
// `write` ends the splice and reports that error.
// 
// This function returns the number of bytes transferred; it may be less
// than `len`.
extern bool streams_method_output_stream_splice(streams_borrow_output_stream_t self, streams_borrow_input_stream_t src, uint64_t len, uint64_t *ret, streams_stream_error_t *err);
// Read from one stream and write to another, with blocking.
// 
// This is similar to `splice`, except that it blocks until the
// `output-stream` is ready for writing, and the `input-stream`
// is ready for reading, before performing the `splice`.
extern bool streams_method_output_stream_blocking_splice(streams_borrow_output_stream_t self, streams_borrow_input_stream_t src, uint64_t len, uint64_t *ret, streams_stream_error_t *err);

// Imported Functions from `wasi:cli/stdin@0.2.0`
extern stdin_own_input_stream_t stdin_get_stdin(void);

// Imported Functions from `wasi:cli/stdout@0.2.0`
extern stdout_own_output_stream_t stdout_get_stdout(void);

// Imported Functions from `wasi:cli/stderr@0.2.0`
extern stderr_own_output_stream_t stderr_get_stderr(void);

// Imported Functions from `wasi:cli/terminal-stdin@0.2.0`
// If stdin is connected to a terminal, return a `terminal-input` handle
// allowing further interaction with it.
extern bool terminal_stdin_get_terminal_stdin(terminal_stdin_own_terminal_input_t *ret);

// Imported Functions from `wasi:cli/terminal-stdout@0.2.0`
// If stdout is connected to a terminal, return a `terminal-output` handle
// allowing further interaction with it.
extern bool terminal_stdout_get_terminal_stdout(terminal_stdout_own_terminal_output_t *ret);

// Imported Functions from `wasi:cli/terminal-stderr@0.2.0`
// If stderr is connected to a terminal, return a `terminal-output` handle
// allowing further interaction with it.
extern bool terminal_stderr_get_terminal_stderr(terminal_stderr_own_terminal_output_t *ret);

// Imported Functions from `wasi:clocks/monotonic-clock@0.2.0`
// Read the current value of the clock.
// 
// The clock is monotonic, therefore calling this function repeatedly will
// produce a sequence of non-decreasing values.
extern monotonic_clock_instant_t monotonic_clock_now(void);
// Query the resolution of the clock. Returns the duration of time
// corresponding to a clock tick.
extern monotonic_clock_duration_t monotonic_clock_resolution(void);
// Create a `pollable` which will resolve once the specified instant
// occured.
extern monotonic_clock_own_pollable_t monotonic_clock_subscribe_instant(monotonic_clock_instant_t when);
// Create a `pollable` which will resolve once the given duration has
// elapsed, starting at the time at which this function was called.
// occured.
extern monotonic_clock_own_pollable_t monotonic_clock_subscribe_duration(monotonic_clock_duration_t when);

// Imported Functions from `wasi:clocks/wall-clock@0.2.0`
// Read the current value of the clock.
// 
// This clock is not monotonic, therefore calling this function repeatedly
// will not necessarily produce a sequence of non-decreasing values.
// 
// The returned timestamps represent the number of seconds since
// 1970-01-01T00:00:00Z, also known as [POSIX's Seconds Since the Epoch],
// also known as [Unix Time].
// 
// The nanoseconds field of the output is always less than 1000000000.
// 
// [POSIX's Seconds Since the Epoch]: https://pubs.opengroup.org/onlinepubs/9699919799/xrat/V4_xbd_chap04.html#tag_21_04_16
// [Unix Time]: https://en.wikipedia.org/wiki/Unix_time
extern void wall_clock_now(wall_clock_datetime_t *ret);
// Query the resolution of the clock.
// 
// The nanoseconds field of the output is always less than 1000000000.
extern void wall_clock_resolution(wall_clock_datetime_t *ret);

// Imported Functions from `wasi:filesystem/types@0.2.0`
// Return a stream for reading from a file, if available.
// 
// May fail with an error-code describing why the file cannot be read.
// 
// Multiple read, write, and append streams may be active on the same open
// file and they do not interfere with each other.
// 
// Note: This allows using `read-stream`, which is similar to `read` in POSIX.
extern bool filesystem_method_descriptor_read_via_stream(filesystem_borrow_descriptor_t self, filesystem_filesize_t offset, filesystem_own_input_stream_t *ret, filesystem_error_code_t *err);
// Return a stream for writing to a file, if available.
// 
// May fail with an error-code describing why the file cannot be written.
// 
// Note: This allows using `write-stream`, which is similar to `write` in
// POSIX.
extern bool filesystem_method_descriptor_write_via_stream(filesystem_borrow_descriptor_t self, filesystem_filesize_t offset, filesystem_own_output_stream_t *ret, filesystem_error_code_t *err);
// Return a stream for appending to a file, if available.
// 
// May fail with an error-code describing why the file cannot be appended.
// 
// Note: This allows using `write-stream`, which is similar to `write` with
// `O_APPEND` in in POSIX.
extern bool filesystem_method_descriptor_append_via_stream(filesystem_borrow_descriptor_t self, filesystem_own_output_stream_t *ret, filesystem_error_code_t *err);
// Provide file advisory information on a descriptor.
// 
// This is similar to `posix_fadvise` in POSIX.
extern bool filesystem_method_descriptor_advise(filesystem_borrow_descriptor_t self, filesystem_filesize_t offset, filesystem_filesize_t length, filesystem_advice_t advice, filesystem_error_code_t *err);
// Synchronize the data of a file to disk.
// 
// This function succeeds with no effect if the file descriptor is not
// opened for writing.
// 
// Note: This is similar to `fdatasync` in POSIX.
extern bool filesystem_method_descriptor_sync_data(filesystem_borrow_descriptor_t self, filesystem_error_code_t *err);
// Get flags associated with a descriptor.
// 
// Note: This returns similar flags to `fcntl(fd, F_GETFL)` in POSIX.
// 
// Note: This returns the value that was the `fs_flags` value returned
// from `fdstat_get` in earlier versions of WASI.
extern bool filesystem_method_descriptor_get_flags(filesystem_borrow_descriptor_t self, filesystem_descriptor_flags_t *ret, filesystem_error_code_t *err);
// Get the dynamic type of a descriptor.
// 
// Note: This returns the same value as the `type` field of the `fd-stat`
// returned by `stat`, `stat-at` and similar.
// 
// Note: This returns similar flags to the `st_mode & S_IFMT` value provided
// by `fstat` in POSIX.
// 
// Note: This returns the value that was the `fs_filetype` value returned
// from `fdstat_get` in earlier versions of WASI.
extern bool filesystem_method_descriptor_get_type(filesystem_borrow_descriptor_t self, filesystem_descriptor_type_t *ret, filesystem_error_code_t *err);
// Adjust the size of an open file. If this increases the file's size, the
// extra bytes are filled with zeros.
// 
// Note: This was called `fd_filestat_set_size` in earlier versions of WASI.
extern bool filesystem_method_descriptor_set_size(filesystem_borrow_descriptor_t self, filesystem_filesize_t size, filesystem_error_code_t *err);
// Adjust the timestamps of an open file or directory.
// 
// Note: This is similar to `futimens` in POSIX.
// 
// Note: This was called `fd_filestat_set_times` in earlier versions of WASI.
extern bool filesystem_method_descriptor_set_times(filesystem_borrow_descriptor_t self, filesystem_new_timestamp_t *data_access_timestamp, filesystem_new_timestamp_t *data_modification_timestamp, filesystem_error_code_t *err);
// Read from a descriptor, without using and updating the descriptor's offset.
// 
// This function returns a list of bytes containing the data that was
// read, along with a bool which, when true, indicates that the end of the
// file was reached. The returned list will contain up to `length` bytes; it
// may return fewer than requested, if the end of the file is reached or
// if the I/O operation is interrupted.
// 
// In the future, this may change to return a `stream<u8, error-code>`.
// 
// Note: This is similar to `pread` in POSIX.
extern bool filesystem_method_descriptor_read(filesystem_borrow_descriptor_t self, filesystem_filesize_t length, filesystem_filesize_t offset, wasip2_tuple2_list_u8_bool_t *ret, filesystem_error_code_t *err);
// Write to a descriptor, without using and updating the descriptor's offset.
// 
// It is valid to write past the end of a file; the file is extended to the
// extent of the write, with bytes between the previous end and the start of
// the write set to zero.
// 
// In the future, this may change to take a `stream<u8, error-code>`.
// 
// Note: This is similar to `pwrite` in POSIX.
extern bool filesystem_method_descriptor_write(filesystem_borrow_descriptor_t self, wasip2_list_u8_t *buffer, filesystem_filesize_t offset, filesystem_filesize_t *ret, filesystem_error_code_t *err);
// Read directory entries from a directory.
// 
// On filesystems where directories contain entries referring to themselves
// and their parents, often named `.` and `..` respectively, these entries
// are omitted.
// 
// This always returns a new stream which starts at the beginning of the
// directory. Multiple streams may be active on the same directory, and they
// do not interfere with each other.
extern bool filesystem_method_descriptor_read_directory(filesystem_borrow_descriptor_t self, filesystem_own_directory_entry_stream_t *ret, filesystem_error_code_t *err);
// Synchronize the data and metadata of a file to disk.
// 
// This function succeeds with no effect if the file descriptor is not
// opened for writing.
// 
// Note: This is similar to `fsync` in POSIX.
extern bool filesystem_method_descriptor_sync(filesystem_borrow_descriptor_t self, filesystem_error_code_t *err);
// Create a directory.
// 
// Note: This is similar to `mkdirat` in POSIX.
extern bool filesystem_method_descriptor_create_directory_at(filesystem_borrow_descriptor_t self, wasip2_string_t *path, filesystem_error_code_t *err);
// Return the attributes of an open file or directory.
// 
// Note: This is similar to `fstat` in POSIX, except that it does not return
// device and inode information. For testing whether two descriptors refer to
// the same underlying filesystem object, use `is-same-object`. To obtain
// additional data that can be used do determine whether a file has been
// modified, use `metadata-hash`.
// 
// Note: This was called `fd_filestat_get` in earlier versions of WASI.
extern bool filesystem_method_descriptor_stat(filesystem_borrow_descriptor_t self, filesystem_descriptor_stat_t *ret, filesystem_error_code_t *err);
// Return the attributes of a file or directory.
// 
// Note: This is similar to `fstatat` in POSIX, except that it does not
// return device and inode information. See the `stat` description for a
// discussion of alternatives.
// 
// Note: This was called `path_filestat_get` in earlier versions of WASI.
extern bool filesystem_method_descriptor_stat_at(filesystem_borrow_descriptor_t self, filesystem_path_flags_t path_flags, wasip2_string_t *path, filesystem_descriptor_stat_t *ret, filesystem_error_code_t *err);
// Adjust the timestamps of a file or directory.
// 
// Note: This is similar to `utimensat` in POSIX.
// 
// Note: This was called `path_filestat_set_times` in earlier versions of
// WASI.
extern bool filesystem_method_descriptor_set_times_at(filesystem_borrow_descriptor_t self, filesystem_path_flags_t path_flags, wasip2_string_t *path, filesystem_new_timestamp_t *data_access_timestamp, filesystem_new_timestamp_t *data_modification_timestamp, filesystem_error_code_t *err);
// Create a hard link.
// 
// Note: This is similar to `linkat` in POSIX.
extern bool filesystem_method_descriptor_link_at(filesystem_borrow_descriptor_t self, filesystem_path_flags_t old_path_flags, wasip2_string_t *old_path, filesystem_borrow_descriptor_t new_descriptor, wasip2_string_t *new_path, filesystem_error_code_t *err);
// Open a file or directory.
// 
// The returned descriptor is not guaranteed to be the lowest-numbered
// descriptor not currently open/ it is randomized to prevent applications
// from depending on making assumptions about indexes, since this is
// error-prone in multi-threaded contexts. The returned descriptor is
// guaranteed to be less than 2**31.
// 
// If `flags` contains `descriptor-flags::mutate-directory`, and the base
// descriptor doesn't have `descriptor-flags::mutate-directory` set,
// `open-at` fails with `error-code::read-only`.
// 
// If `flags` contains `write` or `mutate-directory`, or `open-flags`
// contains `truncate` or `create`, and the base descriptor doesn't have
// `descriptor-flags::mutate-directory` set, `open-at` fails with
// `error-code::read-only`.
// 
// Note: This is similar to `openat` in POSIX.
extern bool filesystem_method_descriptor_open_at(filesystem_borrow_descriptor_t self, filesystem_path_flags_t path_flags, wasip2_string_t *path, filesystem_open_flags_t open_flags, filesystem_descriptor_flags_t flags, filesystem_own_descriptor_t *ret, filesystem_error_code_t *err);
// Read the contents of a symbolic link.
// 
// If the contents contain an absolute or rooted path in the underlying
// filesystem, this function fails with `error-code::not-permitted`.
// 
// Note: This is similar to `readlinkat` in POSIX.
extern bool filesystem_method_descriptor_readlink_at(filesystem_borrow_descriptor_t self, wasip2_string_t *path, wasip2_string_t *ret, filesystem_error_code_t *err);
// Remove a directory.
// 
// Return `error-code::not-empty` if the directory is not empty.
// 
// Note: This is similar to `unlinkat(fd, path, AT_REMOVEDIR)` in POSIX.
extern bool filesystem_method_descriptor_remove_directory_at(filesystem_borrow_descriptor_t self, wasip2_string_t *path, filesystem_error_code_t *err);
// Rename a filesystem object.
// 
// Note: This is similar to `renameat` in POSIX.
extern bool filesystem_method_descriptor_rename_at(filesystem_borrow_descriptor_t self, wasip2_string_t *old_path, filesystem_borrow_descriptor_t new_descriptor, wasip2_string_t *new_path, filesystem_error_code_t *err);
// Create a symbolic link (also known as a "symlink").
// 
// If `old-path` starts with `/`, the function fails with
// `error-code::not-permitted`.
// 
// Note: This is similar to `symlinkat` in POSIX.
extern bool filesystem_method_descriptor_symlink_at(filesystem_borrow_descriptor_t self, wasip2_string_t *old_path, wasip2_string_t *new_path, filesystem_error_code_t *err);
// Unlink a filesystem object that is not a directory.
// 
// Return `error-code::is-directory` if the path refers to a directory.
// Note: This is similar to `unlinkat(fd, path, 0)` in POSIX.
extern bool filesystem_method_descriptor_unlink_file_at(filesystem_borrow_descriptor_t self, wasip2_string_t *path, filesystem_error_code_t *err);
// Test whether two descriptors refer to the same filesystem object.
// 
// In POSIX, this corresponds to testing whether the two descriptors have the
// same device (`st_dev`) and inode (`st_ino` or `d_ino`) numbers.
// wasi-filesystem does not expose device and inode numbers, so this function
// may be used instead.
extern bool filesystem_method_descriptor_is_same_object(filesystem_borrow_descriptor_t self, filesystem_borrow_descriptor_t other);
// Return a hash of the metadata associated with a filesystem object referred
// to by a descriptor.
// 
// This returns a hash of the last-modification timestamp and file size, and
// may also include the inode number, device number, birth timestamp, and
// other metadata fields that may change when the file is modified or
// replaced. It may also include a secret value chosen by the
// implementation and not otherwise exposed.
// 
// Implementations are encourated to provide the following properties:
// 
// - If the file is not modified or replaced, the computed hash value should
// usually not change.
// - If the object is modified or replaced, the computed hash value should
// usually change.
// - The inputs to the hash should not be easily computable from the
// computed hash.
// 
// However, none of these is required.
extern bool filesystem_method_descriptor_metadata_hash(filesystem_borrow_descriptor_t self, filesystem_metadata_hash_value_t *ret, filesystem_error_code_t *err);
// Return a hash of the metadata associated with a filesystem object referred
// to by a directory descriptor and a relative path.
// 
// This performs the same hash computation as `metadata-hash`.
extern bool filesystem_method_descriptor_metadata_hash_at(filesystem_borrow_descriptor_t self, filesystem_path_flags_t path_flags, wasip2_string_t *path, filesystem_metadata_hash_value_t *ret, filesystem_error_code_t *err);
// Read a single directory entry from a `directory-entry-stream`.
extern bool filesystem_method_directory_entry_stream_read_directory_entry(filesystem_borrow_directory_entry_stream_t self, filesystem_option_directory_entry_t *ret, filesystem_error_code_t *err);
// Attempts to extract a filesystem-related `error-code` from the stream
// `error` provided.
// 
// Stream operations which return `stream-error::last-operation-failed`
// have a payload with more information about the operation that failed.
// This payload can be passed through to this function to see if there's
// filesystem-related information about the error to return.
// 
// Note that this function is fallible because not all stream-related
// errors are filesystem-related errors.
extern bool filesystem_filesystem_error_code(filesystem_borrow_error_t err_, filesystem_error_code_t *ret);

// Imported Functions from `wasi:filesystem/preopens@0.2.0`
// Return the set of preopened directories, and their path.
extern void filesystem_preopens_get_directories(filesystem_preopens_list_tuple2_own_descriptor_string_t *ret);

// Imported Functions from `wasi:sockets/instance-network@0.2.0`
// Get a handle to the default network.
extern instance_network_own_network_t instance_network_instance_network(void);

// Imported Functions from `wasi:sockets/udp@0.2.0`
// Bind the socket to a specific network on the provided IP address and port.
// 
// If the IP address is zero (`0.0.0.0` in IPv4, `::` in IPv6), it is left to the implementation to decide which
// network interface(s) to bind to.
// If the port is zero, the socket will be bound to a random free port.
// 
// # Typical errors
// - `invalid-argument`:          The `local-address` has the wrong address family. (EAFNOSUPPORT, EFAULT on Windows)
// - `invalid-state`:             The socket is already bound. (EINVAL)
// - `address-in-use`:            No ephemeral ports available. (EADDRINUSE, ENOBUFS on Windows)
// - `address-in-use`:            Address is already in use. (EADDRINUSE)
// - `address-not-bindable`:      `local-address` is not an address that the `network` can bind to. (EADDRNOTAVAIL)
// - `not-in-progress`:           A `bind` operation is not in progress.
// - `would-block`:               Can't finish the operation, it is still in progress. (EWOULDBLOCK, EAGAIN)
// 
// # Implementors note
// Unlike in POSIX, in WASI the bind operation is async. This enables
// interactive WASI hosts to inject permission prompts. Runtimes that
// don't want to make use of this ability can simply call the native
// `bind` as part of either `start-bind` or `finish-bind`.
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/bind.html>
// - <https://man7.org/linux/man-pages/man2/bind.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-bind>
// - <https://man.freebsd.org/cgi/man.cgi?query=bind&sektion=2&format=html>
extern bool udp_method_udp_socket_start_bind(udp_borrow_udp_socket_t self, udp_borrow_network_t network, udp_ip_socket_address_t *local_address, udp_error_code_t *err);
extern bool udp_method_udp_socket_finish_bind(udp_borrow_udp_socket_t self, udp_error_code_t *err);
// Set up inbound & outbound communication channels, optionally to a specific peer.
// 
// This function only changes the local socket configuration and does not generate any network traffic.
// On success, the `remote-address` of the socket is updated. The `local-address` may be updated as well,
// based on the best network path to `remote-address`.
// 
// When a `remote-address` is provided, the returned streams are limited to communicating with that specific peer:
// - `send` can only be used to send to this destination.
// - `receive` will only return datagrams sent from the provided `remote-address`.
// 
// This method may be called multiple times on the same socket to change its association, but
// only the most recently returned pair of streams will be operational. Implementations may trap if
// the streams returned by a previous invocation haven't been dropped yet before calling `stream` again.
// 
// The POSIX equivalent in pseudo-code is:
// ```text
// if (was previously connected) {
// connect(s, AF_UNSPEC)
// }
// if (remote_address is Some) {
// connect(s, remote_address)
// }
// ```
// 
// Unlike in POSIX, the socket must already be explicitly bound.
// 
// # Typical errors
// - `invalid-argument`:          The `remote-address` has the wrong address family. (EAFNOSUPPORT)
// - `invalid-argument`:          The IP address in `remote-address` is set to INADDR_ANY (`0.0.0.0` / `::`). (EDESTADDRREQ, EADDRNOTAVAIL)
// - `invalid-argument`:          The port in `remote-address` is set to 0. (EDESTADDRREQ, EADDRNOTAVAIL)
// - `invalid-state`:             The socket is not bound.
// - `address-in-use`:            Tried to perform an implicit bind, but there were no ephemeral ports available. (EADDRINUSE, EADDRNOTAVAIL on Linux, EAGAIN on BSD)
// - `remote-unreachable`:        The remote address is not reachable. (ECONNRESET, ENETRESET, EHOSTUNREACH, EHOSTDOWN, ENETUNREACH, ENETDOWN, ENONET)
// - `connection-refused`:        The connection was refused. (ECONNREFUSED)
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/connect.html>
// - <https://man7.org/linux/man-pages/man2/connect.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-connect>
// - <https://man.freebsd.org/cgi/man.cgi?connect>
extern bool udp_method_udp_socket_stream(udp_borrow_udp_socket_t self, udp_ip_socket_address_t *maybe_remote_address, udp_tuple2_own_incoming_datagram_stream_own_outgoing_datagram_stream_t *ret, udp_error_code_t *err);
// Get the current bound address.
// 
// POSIX mentions:
// > If the socket has not been bound to a local name, the value
// > stored in the object pointed to by `address` is unspecified.
// 
// WASI is stricter and requires `local-address` to return `invalid-state` when the socket hasn't been bound yet.
// 
// # Typical errors
// - `invalid-state`: The socket is not bound to any local address.
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getsockname.html>
// - <https://man7.org/linux/man-pages/man2/getsockname.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-getsockname>
// - <https://man.freebsd.org/cgi/man.cgi?getsockname>
extern bool udp_method_udp_socket_local_address(udp_borrow_udp_socket_t self, udp_ip_socket_address_t *ret, udp_error_code_t *err);
// Get the address the socket is currently streaming to.
// 
// # Typical errors
// - `invalid-state`: The socket is not streaming to a specific remote address. (ENOTCONN)
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getpeername.html>
// - <https://man7.org/linux/man-pages/man2/getpeername.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-getpeername>
// - <https://man.freebsd.org/cgi/man.cgi?query=getpeername&sektion=2&n=1>
extern bool udp_method_udp_socket_remote_address(udp_borrow_udp_socket_t self, udp_ip_socket_address_t *ret, udp_error_code_t *err);
// Whether this is a IPv4 or IPv6 socket.
// 
// Equivalent to the SO_DOMAIN socket option.
extern udp_ip_address_family_t udp_method_udp_socket_address_family(udp_borrow_udp_socket_t self);
// Equivalent to the IP_TTL & IPV6_UNICAST_HOPS socket options.
// 
// If the provided value is 0, an `invalid-argument` error is returned.
// 
// # Typical errors
// - `invalid-argument`:     (set) The TTL value must be 1 or higher.
extern bool udp_method_udp_socket_unicast_hop_limit(udp_borrow_udp_socket_t self, uint8_t *ret, udp_error_code_t *err);
extern bool udp_method_udp_socket_set_unicast_hop_limit(udp_borrow_udp_socket_t self, uint8_t value, udp_error_code_t *err);
// The kernel buffer space reserved for sends/receives on this socket.
// 
// If the provided value is 0, an `invalid-argument` error is returned.
// Any other value will never cause an error, but it might be silently clamped and/or rounded.
// I.e. after setting a value, reading the same setting back may return a different value.
// 
// Equivalent to the SO_RCVBUF and SO_SNDBUF socket options.
// 
// # Typical errors
// - `invalid-argument`:     (set) The provided value was 0.
extern bool udp_method_udp_socket_receive_buffer_size(udp_borrow_udp_socket_t self, uint64_t *ret, udp_error_code_t *err);
extern bool udp_method_udp_socket_set_receive_buffer_size(udp_borrow_udp_socket_t self, uint64_t value, udp_error_code_t *err);
extern bool udp_method_udp_socket_send_buffer_size(udp_borrow_udp_socket_t self, uint64_t *ret, udp_error_code_t *err);
extern bool udp_method_udp_socket_set_send_buffer_size(udp_borrow_udp_socket_t self, uint64_t value, udp_error_code_t *err);
// Create a `pollable` which will resolve once the socket is ready for I/O.
// 
// Note: this function is here for WASI Preview2 only.
// It's planned to be removed when `future` is natively supported in Preview3.
extern udp_own_pollable_t udp_method_udp_socket_subscribe(udp_borrow_udp_socket_t self);
// Receive messages on the socket.
// 
// This function attempts to receive up to `max-results` datagrams on the socket without blocking.
// The returned list may contain fewer elements than requested, but never more.
// 
// This function returns successfully with an empty list when either:
// - `max-results` is 0, or:
// - `max-results` is greater than 0, but no results are immediately available.
// This function never returns `error(would-block)`.
// 
// # Typical errors
// - `remote-unreachable`: The remote address is not reachable. (ECONNRESET, ENETRESET on Windows, EHOSTUNREACH, EHOSTDOWN, ENETUNREACH, ENETDOWN, ENONET)
// - `connection-refused`: The connection was refused. (ECONNREFUSED)
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/recvfrom.html>
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/recvmsg.html>
// - <https://man7.org/linux/man-pages/man2/recv.2.html>
// - <https://man7.org/linux/man-pages/man2/recvmmsg.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-recv>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-recvfrom>
// - <https://learn.microsoft.com/en-us/previous-versions/windows/desktop/legacy/ms741687(v=vs.85)>
// - <https://man.freebsd.org/cgi/man.cgi?query=recv&sektion=2>
extern bool udp_method_incoming_datagram_stream_receive(udp_borrow_incoming_datagram_stream_t self, uint64_t max_results, udp_list_incoming_datagram_t *ret, udp_error_code_t *err);
// Create a `pollable` which will resolve once the stream is ready to receive again.
// 
// Note: this function is here for WASI Preview2 only.
// It's planned to be removed when `future` is natively supported in Preview3.
extern udp_own_pollable_t udp_method_incoming_datagram_stream_subscribe(udp_borrow_incoming_datagram_stream_t self);
// Check readiness for sending. This function never blocks.
// 
// Returns the number of datagrams permitted for the next call to `send`,
// or an error. Calling `send` with more datagrams than this function has
// permitted will trap.
// 
// When this function returns ok(0), the `subscribe` pollable will
// become ready when this function will report at least ok(1), or an
// error.
// 
// Never returns `would-block`.
extern bool udp_method_outgoing_datagram_stream_check_send(udp_borrow_outgoing_datagram_stream_t self, uint64_t *ret, udp_error_code_t *err);
// Send messages on the socket.
// 
// This function attempts to send all provided `datagrams` on the socket without blocking and
// returns how many messages were actually sent (or queued for sending). This function never
// returns `error(would-block)`. If none of the datagrams were able to be sent, `ok(0)` is returned.
// 
// This function semantically behaves the same as iterating the `datagrams` list and sequentially
// sending each individual datagram until either the end of the list has been reached or the first error occurred.
// If at least one datagram has been sent successfully, this function never returns an error.
// 
// If the input list is empty, the function returns `ok(0)`.
// 
// Each call to `send` must be permitted by a preceding `check-send`. Implementations must trap if
// either `check-send` was not called or `datagrams` contains more items than `check-send` permitted.
// 
// # Typical errors
// - `invalid-argument`:        The `remote-address` has the wrong address family. (EAFNOSUPPORT)
// - `invalid-argument`:        The IP address in `remote-address` is set to INADDR_ANY (`0.0.0.0` / `::`). (EDESTADDRREQ, EADDRNOTAVAIL)
// - `invalid-argument`:        The port in `remote-address` is set to 0. (EDESTADDRREQ, EADDRNOTAVAIL)
// - `invalid-argument`:        The socket is in "connected" mode and `remote-address` is `some` value that does not match the address passed to `stream`. (EISCONN)
// - `invalid-argument`:        The socket is not "connected" and no value for `remote-address` was provided. (EDESTADDRREQ)
// - `remote-unreachable`:      The remote address is not reachable. (ECONNRESET, ENETRESET on Windows, EHOSTUNREACH, EHOSTDOWN, ENETUNREACH, ENETDOWN, ENONET)
// - `connection-refused`:      The connection was refused. (ECONNREFUSED)
// - `datagram-too-large`:      The datagram is too large. (EMSGSIZE)
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/sendto.html>
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/sendmsg.html>
// - <https://man7.org/linux/man-pages/man2/send.2.html>
// - <https://man7.org/linux/man-pages/man2/sendmmsg.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-send>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-sendto>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-wsasendmsg>
// - <https://man.freebsd.org/cgi/man.cgi?query=send&sektion=2>
extern bool udp_method_outgoing_datagram_stream_send(udp_borrow_outgoing_datagram_stream_t self, udp_list_outgoing_datagram_t *datagrams, uint64_t *ret, udp_error_code_t *err);
// Create a `pollable` which will resolve once the stream is ready to send again.
// 
// Note: this function is here for WASI Preview2 only.
// It's planned to be removed when `future` is natively supported in Preview3.
extern udp_own_pollable_t udp_method_outgoing_datagram_stream_subscribe(udp_borrow_outgoing_datagram_stream_t self);

// Imported Functions from `wasi:sockets/udp-create-socket@0.2.0`
// Create a new UDP socket.
// 
// Similar to `socket(AF_INET or AF_INET6, SOCK_DGRAM, IPPROTO_UDP)` in POSIX.
// On IPv6 sockets, IPV6_V6ONLY is enabled by default and can't be configured otherwise.
// 
// This function does not require a network capability handle. This is considered to be safe because
// at time of creation, the socket is not bound to any `network` yet. Up to the moment `bind` is called,
// the socket is effectively an in-memory configuration object, unable to communicate with the outside world.
// 
// All sockets are non-blocking. Use the wasi-poll interface to block on asynchronous operations.
// 
// # Typical errors
// - `not-supported`:     The specified `address-family` is not supported. (EAFNOSUPPORT)
// - `new-socket-limit`:  The new socket resource could not be created because of a system limit. (EMFILE, ENFILE)
// 
// # References:
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/socket.html>
// - <https://man7.org/linux/man-pages/man2/socket.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-wsasocketw>
// - <https://man.freebsd.org/cgi/man.cgi?query=socket&sektion=2>
extern bool udp_create_socket_create_udp_socket(udp_create_socket_ip_address_family_t address_family, udp_create_socket_own_udp_socket_t *ret, udp_create_socket_error_code_t *err);

// Imported Functions from `wasi:sockets/tcp@0.2.0`
// Bind the socket to a specific network on the provided IP address and port.
// 
// If the IP address is zero (`0.0.0.0` in IPv4, `::` in IPv6), it is left to the implementation to decide which
// network interface(s) to bind to.
// If the TCP/UDP port is zero, the socket will be bound to a random free port.
// 
// Bind can be attempted multiple times on the same socket, even with
// different arguments on each iteration. But never concurrently and
// only as long as the previous bind failed. Once a bind succeeds, the
// binding can't be changed anymore.
// 
// # Typical errors
// - `invalid-argument`:          The `local-address` has the wrong address family. (EAFNOSUPPORT, EFAULT on Windows)
// - `invalid-argument`:          `local-address` is not a unicast address. (EINVAL)
// - `invalid-argument`:          `local-address` is an IPv4-mapped IPv6 address. (EINVAL)
// - `invalid-state`:             The socket is already bound. (EINVAL)
// - `address-in-use`:            No ephemeral ports available. (EADDRINUSE, ENOBUFS on Windows)
// - `address-in-use`:            Address is already in use. (EADDRINUSE)
// - `address-not-bindable`:      `local-address` is not an address that the `network` can bind to. (EADDRNOTAVAIL)
// - `not-in-progress`:           A `bind` operation is not in progress.
// - `would-block`:               Can't finish the operation, it is still in progress. (EWOULDBLOCK, EAGAIN)
// 
// # Implementors note
// When binding to a non-zero port, this bind operation shouldn't be affected by the TIME_WAIT
// state of a recently closed socket on the same local address. In practice this means that the SO_REUSEADDR
// socket option should be set implicitly on all platforms, except on Windows where this is the default behavior
// and SO_REUSEADDR performs something different entirely.
// 
// Unlike in POSIX, in WASI the bind operation is async. This enables
// interactive WASI hosts to inject permission prompts. Runtimes that
// don't want to make use of this ability can simply call the native
// `bind` as part of either `start-bind` or `finish-bind`.
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/bind.html>
// - <https://man7.org/linux/man-pages/man2/bind.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-bind>
// - <https://man.freebsd.org/cgi/man.cgi?query=bind&sektion=2&format=html>
extern bool tcp_method_tcp_socket_start_bind(tcp_borrow_tcp_socket_t self, tcp_borrow_network_t network, tcp_ip_socket_address_t *local_address, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_finish_bind(tcp_borrow_tcp_socket_t self, tcp_error_code_t *err);
// Connect to a remote endpoint.
// 
// On success:
// - the socket is transitioned into the `connection` state.
// - a pair of streams is returned that can be used to read & write to the connection
// 
// After a failed connection attempt, the socket will be in the `closed`
// state and the only valid action left is to `drop` the socket. A single
// socket can not be used to connect more than once.
// 
// # Typical errors
// - `invalid-argument`:          The `remote-address` has the wrong address family. (EAFNOSUPPORT)
// - `invalid-argument`:          `remote-address` is not a unicast address. (EINVAL, ENETUNREACH on Linux, EAFNOSUPPORT on MacOS)
// - `invalid-argument`:          `remote-address` is an IPv4-mapped IPv6 address. (EINVAL, EADDRNOTAVAIL on Illumos)
// - `invalid-argument`:          The IP address in `remote-address` is set to INADDR_ANY (`0.0.0.0` / `::`). (EADDRNOTAVAIL on Windows)
// - `invalid-argument`:          The port in `remote-address` is set to 0. (EADDRNOTAVAIL on Windows)
// - `invalid-argument`:          The socket is already attached to a different network. The `network` passed to `connect` must be identical to the one passed to `bind`.
// - `invalid-state`:             The socket is already in the `connected` state. (EISCONN)
// - `invalid-state`:             The socket is already in the `listening` state. (EOPNOTSUPP, EINVAL on Windows)
// - `timeout`:                   Connection timed out. (ETIMEDOUT)
// - `connection-refused`:        The connection was forcefully rejected. (ECONNREFUSED)
// - `connection-reset`:          The connection was reset. (ECONNRESET)
// - `connection-aborted`:        The connection was aborted. (ECONNABORTED)
// - `remote-unreachable`:        The remote address is not reachable. (EHOSTUNREACH, EHOSTDOWN, ENETUNREACH, ENETDOWN, ENONET)
// - `address-in-use`:            Tried to perform an implicit bind, but there were no ephemeral ports available. (EADDRINUSE, EADDRNOTAVAIL on Linux, EAGAIN on BSD)
// - `not-in-progress`:           A connect operation is not in progress.
// - `would-block`:               Can't finish the operation, it is still in progress. (EWOULDBLOCK, EAGAIN)
// 
// # Implementors note
// The POSIX equivalent of `start-connect` is the regular `connect` syscall.
// Because all WASI sockets are non-blocking this is expected to return
// EINPROGRESS, which should be translated to `ok()` in WASI.
// 
// The POSIX equivalent of `finish-connect` is a `poll` for event `POLLOUT`
// with a timeout of 0 on the socket descriptor. Followed by a check for
// the `SO_ERROR` socket option, in case the poll signaled readiness.
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/connect.html>
// - <https://man7.org/linux/man-pages/man2/connect.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-connect>
// - <https://man.freebsd.org/cgi/man.cgi?connect>
extern bool tcp_method_tcp_socket_start_connect(tcp_borrow_tcp_socket_t self, tcp_borrow_network_t network, tcp_ip_socket_address_t *remote_address, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_finish_connect(tcp_borrow_tcp_socket_t self, tcp_tuple2_own_input_stream_own_output_stream_t *ret, tcp_error_code_t *err);
// Start listening for new connections.
// 
// Transitions the socket into the `listening` state.
// 
// Unlike POSIX, the socket must already be explicitly bound.
// 
// # Typical errors
// - `invalid-state`:             The socket is not bound to any local address. (EDESTADDRREQ)
// - `invalid-state`:             The socket is already in the `connected` state. (EISCONN, EINVAL on BSD)
// - `invalid-state`:             The socket is already in the `listening` state.
// - `address-in-use`:            Tried to perform an implicit bind, but there were no ephemeral ports available. (EADDRINUSE)
// - `not-in-progress`:           A listen operation is not in progress.
// - `would-block`:               Can't finish the operation, it is still in progress. (EWOULDBLOCK, EAGAIN)
// 
// # Implementors note
// Unlike in POSIX, in WASI the listen operation is async. This enables
// interactive WASI hosts to inject permission prompts. Runtimes that
// don't want to make use of this ability can simply call the native
// `listen` as part of either `start-listen` or `finish-listen`.
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/listen.html>
// - <https://man7.org/linux/man-pages/man2/listen.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-listen>
// - <https://man.freebsd.org/cgi/man.cgi?query=listen&sektion=2>
extern bool tcp_method_tcp_socket_start_listen(tcp_borrow_tcp_socket_t self, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_finish_listen(tcp_borrow_tcp_socket_t self, tcp_error_code_t *err);
// Accept a new client socket.
// 
// The returned socket is bound and in the `connected` state. The following properties are inherited from the listener socket:
// - `address-family`
// - `keep-alive-enabled`
// - `keep-alive-idle-time`
// - `keep-alive-interval`
// - `keep-alive-count`
// - `hop-limit`
// - `receive-buffer-size`
// - `send-buffer-size`
// 
// On success, this function returns the newly accepted client socket along with
// a pair of streams that can be used to read & write to the connection.
// 
// # Typical errors
// - `invalid-state`:      Socket is not in the `listening` state. (EINVAL)
// - `would-block`:        No pending connections at the moment. (EWOULDBLOCK, EAGAIN)
// - `connection-aborted`: An incoming connection was pending, but was terminated by the client before this listener could accept it. (ECONNABORTED)
// - `new-socket-limit`:   The new socket resource could not be created because of a system limit. (EMFILE, ENFILE)
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/accept.html>
// - <https://man7.org/linux/man-pages/man2/accept.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-accept>
// - <https://man.freebsd.org/cgi/man.cgi?query=accept&sektion=2>
extern bool tcp_method_tcp_socket_accept(tcp_borrow_tcp_socket_t self, tcp_tuple3_own_tcp_socket_own_input_stream_own_output_stream_t *ret, tcp_error_code_t *err);
// Get the bound local address.
// 
// POSIX mentions:
// > If the socket has not been bound to a local name, the value
// > stored in the object pointed to by `address` is unspecified.
// 
// WASI is stricter and requires `local-address` to return `invalid-state` when the socket hasn't been bound yet.
// 
// # Typical errors
// - `invalid-state`: The socket is not bound to any local address.
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getsockname.html>
// - <https://man7.org/linux/man-pages/man2/getsockname.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-getsockname>
// - <https://man.freebsd.org/cgi/man.cgi?getsockname>
extern bool tcp_method_tcp_socket_local_address(tcp_borrow_tcp_socket_t self, tcp_ip_socket_address_t *ret, tcp_error_code_t *err);
// Get the remote address.
// 
// # Typical errors
// - `invalid-state`: The socket is not connected to a remote address. (ENOTCONN)
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getpeername.html>
// - <https://man7.org/linux/man-pages/man2/getpeername.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-getpeername>
// - <https://man.freebsd.org/cgi/man.cgi?query=getpeername&sektion=2&n=1>
extern bool tcp_method_tcp_socket_remote_address(tcp_borrow_tcp_socket_t self, tcp_ip_socket_address_t *ret, tcp_error_code_t *err);
// Whether the socket is in the `listening` state.
// 
// Equivalent to the SO_ACCEPTCONN socket option.
extern bool tcp_method_tcp_socket_is_listening(tcp_borrow_tcp_socket_t self);
// Whether this is a IPv4 or IPv6 socket.
// 
// Equivalent to the SO_DOMAIN socket option.
extern tcp_ip_address_family_t tcp_method_tcp_socket_address_family(tcp_borrow_tcp_socket_t self);
// Hints the desired listen queue size. Implementations are free to ignore this.
// 
// If the provided value is 0, an `invalid-argument` error is returned.
// Any other value will never cause an error, but it might be silently clamped and/or rounded.
// 
// # Typical errors
// - `not-supported`:        (set) The platform does not support changing the backlog size after the initial listen.
// - `invalid-argument`:     (set) The provided value was 0.
// - `invalid-state`:        (set) The socket is in the `connect-in-progress` or `connected` state.
extern bool tcp_method_tcp_socket_set_listen_backlog_size(tcp_borrow_tcp_socket_t self, uint64_t value, tcp_error_code_t *err);
// Enables or disables keepalive.
// 
// The keepalive behavior can be adjusted using:
// - `keep-alive-idle-time`
// - `keep-alive-interval`
// - `keep-alive-count`
// These properties can be configured while `keep-alive-enabled` is false, but only come into effect when `keep-alive-enabled` is true.
// 
// Equivalent to the SO_KEEPALIVE socket option.
extern bool tcp_method_tcp_socket_keep_alive_enabled(tcp_borrow_tcp_socket_t self, bool *ret, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_set_keep_alive_enabled(tcp_borrow_tcp_socket_t self, bool value, tcp_error_code_t *err);
// Amount of time the connection has to be idle before TCP starts sending keepalive packets.
// 
// If the provided value is 0, an `invalid-argument` error is returned.
// Any other value will never cause an error, but it might be silently clamped and/or rounded.
// I.e. after setting a value, reading the same setting back may return a different value.
// 
// Equivalent to the TCP_KEEPIDLE socket option. (TCP_KEEPALIVE on MacOS)
// 
// # Typical errors
// - `invalid-argument`:     (set) The provided value was 0.
extern bool tcp_method_tcp_socket_keep_alive_idle_time(tcp_borrow_tcp_socket_t self, tcp_duration_t *ret, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_set_keep_alive_idle_time(tcp_borrow_tcp_socket_t self, tcp_duration_t value, tcp_error_code_t *err);
// The time between keepalive packets.
// 
// If the provided value is 0, an `invalid-argument` error is returned.
// Any other value will never cause an error, but it might be silently clamped and/or rounded.
// I.e. after setting a value, reading the same setting back may return a different value.
// 
// Equivalent to the TCP_KEEPINTVL socket option.
// 
// # Typical errors
// - `invalid-argument`:     (set) The provided value was 0.
extern bool tcp_method_tcp_socket_keep_alive_interval(tcp_borrow_tcp_socket_t self, tcp_duration_t *ret, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_set_keep_alive_interval(tcp_borrow_tcp_socket_t self, tcp_duration_t value, tcp_error_code_t *err);
// The maximum amount of keepalive packets TCP should send before aborting the connection.
// 
// If the provided value is 0, an `invalid-argument` error is returned.
// Any other value will never cause an error, but it might be silently clamped and/or rounded.
// I.e. after setting a value, reading the same setting back may return a different value.
// 
// Equivalent to the TCP_KEEPCNT socket option.
// 
// # Typical errors
// - `invalid-argument`:     (set) The provided value was 0.
extern bool tcp_method_tcp_socket_keep_alive_count(tcp_borrow_tcp_socket_t self, uint32_t *ret, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_set_keep_alive_count(tcp_borrow_tcp_socket_t self, uint32_t value, tcp_error_code_t *err);
// Equivalent to the IP_TTL & IPV6_UNICAST_HOPS socket options.
// 
// If the provided value is 0, an `invalid-argument` error is returned.
// 
// # Typical errors
// - `invalid-argument`:     (set) The TTL value must be 1 or higher.
extern bool tcp_method_tcp_socket_hop_limit(tcp_borrow_tcp_socket_t self, uint8_t *ret, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_set_hop_limit(tcp_borrow_tcp_socket_t self, uint8_t value, tcp_error_code_t *err);
// The kernel buffer space reserved for sends/receives on this socket.
// 
// If the provided value is 0, an `invalid-argument` error is returned.
// Any other value will never cause an error, but it might be silently clamped and/or rounded.
// I.e. after setting a value, reading the same setting back may return a different value.
// 
// Equivalent to the SO_RCVBUF and SO_SNDBUF socket options.
// 
// # Typical errors
// - `invalid-argument`:     (set) The provided value was 0.
extern bool tcp_method_tcp_socket_receive_buffer_size(tcp_borrow_tcp_socket_t self, uint64_t *ret, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_set_receive_buffer_size(tcp_borrow_tcp_socket_t self, uint64_t value, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_send_buffer_size(tcp_borrow_tcp_socket_t self, uint64_t *ret, tcp_error_code_t *err);
extern bool tcp_method_tcp_socket_set_send_buffer_size(tcp_borrow_tcp_socket_t self, uint64_t value, tcp_error_code_t *err);
// Create a `pollable` which can be used to poll for, or block on,
// completion of any of the asynchronous operations of this socket.
// 
// When `finish-bind`, `finish-listen`, `finish-connect` or `accept`
// return `error(would-block)`, this pollable can be used to wait for
// their success or failure, after which the method can be retried.
// 
// The pollable is not limited to the async operation that happens to be
// in progress at the time of calling `subscribe` (if any). Theoretically,
// `subscribe` only has to be called once per socket and can then be
// (re)used for the remainder of the socket's lifetime.
// 
// See <https://github.com/WebAssembly/wasi-sockets/TcpSocketOperationalSemantics.md#Pollable-readiness>
// for a more information.
// 
// Note: this function is here for WASI Preview2 only.
// It's planned to be removed when `future` is natively supported in Preview3.
extern tcp_own_pollable_t tcp_method_tcp_socket_subscribe(tcp_borrow_tcp_socket_t self);
// Initiate a graceful shutdown.
// 
// - `receive`: The socket is not expecting to receive any data from
// the peer. The `input-stream` associated with this socket will be
// closed. Any data still in the receive queue at time of calling
// this method will be discarded.
// - `send`: The socket has no more data to send to the peer. The `output-stream`
// associated with this socket will be closed and a FIN packet will be sent.
// - `both`: Same effect as `receive` & `send` combined.
// 
// This function is idempotent. Shutting a down a direction more than once
// has no effect and returns `ok`.
// 
// The shutdown function does not close (drop) the socket.
// 
// # Typical errors
// - `invalid-state`: The socket is not in the `connected` state. (ENOTCONN)
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/shutdown.html>
// - <https://man7.org/linux/man-pages/man2/shutdown.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock/nf-winsock-shutdown>
// - <https://man.freebsd.org/cgi/man.cgi?query=shutdown&sektion=2>
extern bool tcp_method_tcp_socket_shutdown(tcp_borrow_tcp_socket_t self, tcp_shutdown_type_t shutdown_type, tcp_error_code_t *err);

// Imported Functions from `wasi:sockets/tcp-create-socket@0.2.0`
// Create a new TCP socket.
// 
// Similar to `socket(AF_INET or AF_INET6, SOCK_STREAM, IPPROTO_TCP)` in POSIX.
// On IPv6 sockets, IPV6_V6ONLY is enabled by default and can't be configured otherwise.
// 
// This function does not require a network capability handle. This is considered to be safe because
// at time of creation, the socket is not bound to any `network` yet. Up to the moment `bind`/`connect`
// is called, the socket is effectively an in-memory configuration object, unable to communicate with the outside world.
// 
// All sockets are non-blocking. Use the wasi-poll interface to block on asynchronous operations.
// 
// # Typical errors
// - `not-supported`:     The specified `address-family` is not supported. (EAFNOSUPPORT)
// - `new-socket-limit`:  The new socket resource could not be created because of a system limit. (EMFILE, ENFILE)
// 
// # References
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/socket.html>
// - <https://man7.org/linux/man-pages/man2/socket.2.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/winsock2/nf-winsock2-wsasocketw>
// - <https://man.freebsd.org/cgi/man.cgi?query=socket&sektion=2>
extern bool tcp_create_socket_create_tcp_socket(tcp_create_socket_ip_address_family_t address_family, tcp_create_socket_own_tcp_socket_t *ret, tcp_create_socket_error_code_t *err);

// Imported Functions from `wasi:sockets/ip-name-lookup@0.2.0`
// Returns the next address from the resolver.
// 
// This function should be called multiple times. On each call, it will
// return the next address in connection order preference. If all
// addresses have been exhausted, this function returns `none`.
// 
// This function never returns IPv4-mapped IPv6 addresses.
// 
// # Typical errors
// - `name-unresolvable`:          Name does not exist or has no suitable associated IP addresses. (EAI_NONAME, EAI_NODATA, EAI_ADDRFAMILY)
// - `temporary-resolver-failure`: A temporary failure in name resolution occurred. (EAI_AGAIN)
// - `permanent-resolver-failure`: A permanent failure in name resolution occurred. (EAI_FAIL)
// - `would-block`:                A result is not available yet. (EWOULDBLOCK, EAGAIN)
extern bool ip_name_lookup_method_resolve_address_stream_resolve_next_address(ip_name_lookup_borrow_resolve_address_stream_t self, ip_name_lookup_option_ip_address_t *ret, ip_name_lookup_error_code_t *err);
// Create a `pollable` which will resolve once the stream is ready for I/O.
// 
// Note: this function is here for WASI Preview2 only.
// It's planned to be removed when `future` is natively supported in Preview3.
extern ip_name_lookup_own_pollable_t ip_name_lookup_method_resolve_address_stream_subscribe(ip_name_lookup_borrow_resolve_address_stream_t self);
// Resolve an internet host name to a list of IP addresses.
// 
// Unicode domain names are automatically converted to ASCII using IDNA encoding.
// If the input is an IP address string, the address is parsed and returned
// as-is without making any external requests.
// 
// See the wasi-socket proposal README.md for a comparison with getaddrinfo.
// 
// This function never blocks. It either immediately fails or immediately
// returns successfully with a `resolve-address-stream` that can be used
// to (asynchronously) fetch the results.
// 
// # Typical errors
// - `invalid-argument`: `name` is a syntactically invalid domain name or IP address.
// 
// # References:
// - <https://pubs.opengroup.org/onlinepubs/9699919799/functions/getaddrinfo.html>
// - <https://man7.org/linux/man-pages/man3/getaddrinfo.3.html>
// - <https://learn.microsoft.com/en-us/windows/win32/api/ws2tcpip/nf-ws2tcpip-getaddrinfo>
// - <https://man.freebsd.org/cgi/man.cgi?query=getaddrinfo&sektion=3>
extern bool ip_name_lookup_resolve_addresses(ip_name_lookup_borrow_network_t network, wasip2_string_t *name, ip_name_lookup_own_resolve_address_stream_t *ret, ip_name_lookup_error_code_t *err);

// Imported Functions from `wasi:random/random@0.2.0`
// Return `len` cryptographically-secure random or pseudo-random bytes.
// 
// This function must produce data at least as cryptographically secure and
// fast as an adequately seeded cryptographically-secure pseudo-random
// number generator (CSPRNG). It must not block, from the perspective of
// the calling program, under any circumstances, including on the first
// request and on requests for numbers of bytes. The returned data must
// always be unpredictable.
// 
// This function must always return fresh data. Deterministic environments
// must omit this function, rather than implementing it with deterministic
// data.
extern void random_get_random_bytes(uint64_t len, wasip2_list_u8_t *ret);
// Return a cryptographically-secure random or pseudo-random `u64` value.
// 
// This function returns the same type of data as `get-random-bytes`,
// represented as a `u64`.
extern uint64_t random_get_random_u64(void);

// Imported Functions from `wasi:random/insecure@0.2.0`
// Return `len` insecure pseudo-random bytes.
// 
// This function is not cryptographically secure. Do not use it for
// anything related to security.
// 
// There are no requirements on the values of the returned bytes, however
// implementations are encouraged to return evenly distributed values with
// a long period.
extern void random_insecure_get_insecure_random_bytes(uint64_t len, wasip2_list_u8_t *ret);
// Return an insecure pseudo-random `u64` value.
// 
// This function returns the same type of pseudo-random data as
// `get-insecure-random-bytes`, represented as a `u64`.
extern uint64_t random_insecure_get_insecure_random_u64(void);

// Imported Functions from `wasi:random/insecure-seed@0.2.0`
// Return a 128-bit value that may contain a pseudo-random value.
// 
// The returned value is not required to be computed from a CSPRNG, and may
// even be entirely deterministic. Host implementations are encouraged to
// provide pseudo-random values to any program exposed to
// attacker-controlled content, to enable DoS protection built into many
// languages' hash-map implementations.
// 
// This function is intended to only be called once, by a source language
// to initialize Denial Of Service (DoS) protection in its hash-map
// implementation.
// 
// # Expected future evolution
// 
// This will likely be changed to a value import, to prevent it from being
// called multiple times and potentially used for purposes other than DoS
// protection.
extern void random_insecure_seed_insecure_seed(wasip2_tuple2_u64_u64_t *ret);

// Helper Functions

void wasip2_tuple2_string_string_free(wasip2_tuple2_string_string_t *ptr);

void wasip2_list_tuple2_string_string_free(wasip2_list_tuple2_string_string_t *ptr);

void wasip2_list_string_free(wasip2_list_string_t *ptr);

void wasip2_option_string_free(wasip2_option_string_t *ptr);

void exit_result_void_void_free(exit_result_void_void_t *ptr);

extern void io_error_error_drop_own(io_error_own_error_t handle);

extern io_error_borrow_error_t io_error_borrow_error(io_error_own_error_t handle);

extern void poll_pollable_drop_own(poll_own_pollable_t handle);

extern poll_borrow_pollable_t poll_borrow_pollable(poll_own_pollable_t handle);

void poll_list_borrow_pollable_free(poll_list_borrow_pollable_t *ptr);

void wasip2_list_u32_free(wasip2_list_u32_t *ptr);

void streams_stream_error_free(streams_stream_error_t *ptr);

extern void streams_input_stream_drop_own(streams_own_input_stream_t handle);

extern streams_borrow_input_stream_t streams_borrow_input_stream(streams_own_input_stream_t handle);

extern void streams_output_stream_drop_own(streams_own_output_stream_t handle);

extern streams_borrow_output_stream_t streams_borrow_output_stream(streams_own_output_stream_t handle);

void wasip2_list_u8_free(wasip2_list_u8_t *ptr);

void streams_result_list_u8_stream_error_free(streams_result_list_u8_stream_error_t *ptr);

void streams_result_u64_stream_error_free(streams_result_u64_stream_error_t *ptr);

void streams_result_void_stream_error_free(streams_result_void_stream_error_t *ptr);

extern void terminal_input_terminal_input_drop_own(terminal_input_own_terminal_input_t handle);

extern terminal_input_borrow_terminal_input_t terminal_input_borrow_terminal_input(terminal_input_own_terminal_input_t handle);

extern void terminal_output_terminal_output_drop_own(terminal_output_own_terminal_output_t handle);

extern terminal_output_borrow_terminal_output_t terminal_output_borrow_terminal_output(terminal_output_own_terminal_output_t handle);

void terminal_stdin_option_own_terminal_input_free(terminal_stdin_option_own_terminal_input_t *ptr);

void terminal_stdout_option_own_terminal_output_free(terminal_stdout_option_own_terminal_output_t *ptr);

void terminal_stderr_option_own_terminal_output_free(terminal_stderr_option_own_terminal_output_t *ptr);

void filesystem_option_datetime_free(filesystem_option_datetime_t *ptr);

void filesystem_descriptor_stat_free(filesystem_descriptor_stat_t *ptr);

void filesystem_new_timestamp_free(filesystem_new_timestamp_t *ptr);

void filesystem_directory_entry_free(filesystem_directory_entry_t *ptr);

extern void filesystem_descriptor_drop_own(filesystem_own_descriptor_t handle);

extern filesystem_borrow_descriptor_t filesystem_borrow_descriptor(filesystem_own_descriptor_t handle);

extern void filesystem_directory_entry_stream_drop_own(filesystem_own_directory_entry_stream_t handle);

extern filesystem_borrow_directory_entry_stream_t filesystem_borrow_directory_entry_stream(filesystem_own_directory_entry_stream_t handle);

void filesystem_result_own_input_stream_error_code_free(filesystem_result_own_input_stream_error_code_t *ptr);

void filesystem_result_own_output_stream_error_code_free(filesystem_result_own_output_stream_error_code_t *ptr);

void filesystem_result_void_error_code_free(filesystem_result_void_error_code_t *ptr);

void filesystem_result_descriptor_flags_error_code_free(filesystem_result_descriptor_flags_error_code_t *ptr);

void filesystem_result_descriptor_type_error_code_free(filesystem_result_descriptor_type_error_code_t *ptr);

void filesystem_result_tuple2_list_u8_bool_error_code_free(filesystem_result_tuple2_list_u8_bool_error_code_t *ptr);

void filesystem_result_filesize_error_code_free(filesystem_result_filesize_error_code_t *ptr);

void filesystem_result_own_directory_entry_stream_error_code_free(filesystem_result_own_directory_entry_stream_error_code_t *ptr);

void filesystem_result_descriptor_stat_error_code_free(filesystem_result_descriptor_stat_error_code_t *ptr);

void filesystem_result_own_descriptor_error_code_free(filesystem_result_own_descriptor_error_code_t *ptr);

void filesystem_result_string_error_code_free(filesystem_result_string_error_code_t *ptr);

void filesystem_result_metadata_hash_value_error_code_free(filesystem_result_metadata_hash_value_error_code_t *ptr);

void filesystem_option_directory_entry_free(filesystem_option_directory_entry_t *ptr);

void filesystem_result_option_directory_entry_error_code_free(filesystem_result_option_directory_entry_error_code_t *ptr);

void filesystem_option_error_code_free(filesystem_option_error_code_t *ptr);

void filesystem_preopens_tuple2_own_descriptor_string_free(filesystem_preopens_tuple2_own_descriptor_string_t *ptr);

void filesystem_preopens_list_tuple2_own_descriptor_string_free(filesystem_preopens_list_tuple2_own_descriptor_string_t *ptr);

extern void network_network_drop_own(network_own_network_t handle);

extern network_borrow_network_t network_borrow_network(network_own_network_t handle);

void network_ip_address_free(network_ip_address_t *ptr);

void network_ip_socket_address_free(network_ip_socket_address_t *ptr);

void udp_ip_socket_address_free(udp_ip_socket_address_t *ptr);

void udp_incoming_datagram_free(udp_incoming_datagram_t *ptr);

void udp_option_ip_socket_address_free(udp_option_ip_socket_address_t *ptr);

void udp_outgoing_datagram_free(udp_outgoing_datagram_t *ptr);

extern void udp_udp_socket_drop_own(udp_own_udp_socket_t handle);

extern udp_borrow_udp_socket_t udp_borrow_udp_socket(udp_own_udp_socket_t handle);

extern void udp_incoming_datagram_stream_drop_own(udp_own_incoming_datagram_stream_t handle);

extern udp_borrow_incoming_datagram_stream_t udp_borrow_incoming_datagram_stream(udp_own_incoming_datagram_stream_t handle);

extern void udp_outgoing_datagram_stream_drop_own(udp_own_outgoing_datagram_stream_t handle);

extern udp_borrow_outgoing_datagram_stream_t udp_borrow_outgoing_datagram_stream(udp_own_outgoing_datagram_stream_t handle);

void udp_result_void_error_code_free(udp_result_void_error_code_t *ptr);

void udp_result_tuple2_own_incoming_datagram_stream_own_outgoing_datagram_stream_error_code_free(udp_result_tuple2_own_incoming_datagram_stream_own_outgoing_datagram_stream_error_code_t *ptr);

void udp_result_ip_socket_address_error_code_free(udp_result_ip_socket_address_error_code_t *ptr);

void udp_result_u8_error_code_free(udp_result_u8_error_code_t *ptr);

void udp_result_u64_error_code_free(udp_result_u64_error_code_t *ptr);

void udp_list_incoming_datagram_free(udp_list_incoming_datagram_t *ptr);

void udp_result_list_incoming_datagram_error_code_free(udp_result_list_incoming_datagram_error_code_t *ptr);

void udp_list_outgoing_datagram_free(udp_list_outgoing_datagram_t *ptr);

void udp_create_socket_result_own_udp_socket_error_code_free(udp_create_socket_result_own_udp_socket_error_code_t *ptr);

void tcp_ip_socket_address_free(tcp_ip_socket_address_t *ptr);

extern void tcp_tcp_socket_drop_own(tcp_own_tcp_socket_t handle);

extern tcp_borrow_tcp_socket_t tcp_borrow_tcp_socket(tcp_own_tcp_socket_t handle);

void tcp_result_void_error_code_free(tcp_result_void_error_code_t *ptr);

void tcp_result_tuple2_own_input_stream_own_output_stream_error_code_free(tcp_result_tuple2_own_input_stream_own_output_stream_error_code_t *ptr);

void tcp_result_tuple3_own_tcp_socket_own_input_stream_own_output_stream_error_code_free(tcp_result_tuple3_own_tcp_socket_own_input_stream_own_output_stream_error_code_t *ptr);

void tcp_result_ip_socket_address_error_code_free(tcp_result_ip_socket_address_error_code_t *ptr);

void tcp_result_bool_error_code_free(tcp_result_bool_error_code_t *ptr);

void tcp_result_duration_error_code_free(tcp_result_duration_error_code_t *ptr);

void tcp_result_u32_error_code_free(tcp_result_u32_error_code_t *ptr);

void tcp_result_u8_error_code_free(tcp_result_u8_error_code_t *ptr);

void tcp_result_u64_error_code_free(tcp_result_u64_error_code_t *ptr);

void tcp_create_socket_result_own_tcp_socket_error_code_free(tcp_create_socket_result_own_tcp_socket_error_code_t *ptr);

void ip_name_lookup_ip_address_free(ip_name_lookup_ip_address_t *ptr);

extern void ip_name_lookup_resolve_address_stream_drop_own(ip_name_lookup_own_resolve_address_stream_t handle);

extern ip_name_lookup_borrow_resolve_address_stream_t ip_name_lookup_borrow_resolve_address_stream(ip_name_lookup_own_resolve_address_stream_t handle);

void ip_name_lookup_option_ip_address_free(ip_name_lookup_option_ip_address_t *ptr);

void ip_name_lookup_result_option_ip_address_error_code_free(ip_name_lookup_result_option_ip_address_error_code_t *ptr);

void ip_name_lookup_result_own_resolve_address_stream_error_code_free(ip_name_lookup_result_own_resolve_address_stream_error_code_t *ptr);

// Sets the string `ret` to reference the input string `s` without copying it
void wasip2_string_set(wasip2_string_t *ret, const char*s);

// Creates a copy of the input nul-terminated string `s` and
// stores it into the component model string `ret`.
void wasip2_string_dup(wasip2_string_t *ret, const char*s);

// Creates a copy of the input string `s` with length `len` and
// stores it into the component model string `ret`.
// The length is specified in code units (bytes for UTF-8, 16-bit values for UTF-16).
void wasip2_string_dup_n(wasip2_string_t *ret, const char*s, size_t len);

// Deallocates the string pointed to by `ret`, deallocating
// the memory behind the string.
void wasip2_string_free(wasip2_string_t *ret);

#ifdef __cplusplus
}
#endif
#endif
