*** Settings ***
Documentation       Check AP health.

Resource            ${CURDIR}${/}..${/}..${/}..${/}..${/}resources/import.resource

Test Timeout        120s
Test Setup          Ctn Generic Suite Setup

*** Variables ***
${CMD}      ${CENTREON_PLUGINS} --plugin=network::huawei::wlc::snmp::plugin


*** Test Cases ***
ap-health ${tc}
    [Tags]    network    snmp
    ${command}    Catenate
    ...    ${CMD}
    ...    --mode=ap-health
    ...    --hostname=${HOSTNAME}
    ...    --snmp-version=${SNMPVERSION}
    ...    --snmp-port=${SNMPPORT}
    ...    --snmp-community=network/huawei/wlc/snmp/slim_huawei_wlc
    ...    --snmp-timeout=1
    ...    ${extra_options}
 
    Ctn Run Command And Check Result As Strings    ${command}    ${expected_result}

    Examples:        tc    extra_options                                                                                                                             expected_result    --
            ...      1     --verbose --filter-name='Anonymized 065'                                                                                                  OK: access point 'Anonymized 065' data link state: run, power-supply: normal, access point temperature: 42.00 C, access point Anonymized 065 online time is: 1d 22h 48m 58s, access point bootcount total: 424, access point memory: 22.00 %, access point cpu: 1.00%, access point up-Port speed: 1000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 2 | 'Anonymized 065#ap.temperature.celsius'=42.00C;;;; 'Anonymized 065#ap.online.time'=168538;;;; 'Anonymized 065#ap.boot.total.count'=424;;;; 'Anonymized 065#ap.memory.used.percentage'=22.00%;;;; 'Anonymized 065#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 065#ap.up.port.bitspersecond'=1000b/s;;;; 'Anonymized 065#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 065#ap.online.user.count'=2;;;; checking access point 'Anonymized 065' data link state: run, power-supply: normal, access point temperature: 42.00 C, access point Anonymized 065 online time is: 1d 22h 48m 58s, access point bootcount total: 424, access point memory: 22.00 %, access point cpu: 1.00%, access point up-Port speed: 1000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 2
            ...      2     --filter-counters="" --filter-name='Anonymized 065'                                                                                       OK: access point 'Anonymized 065' data link state: run, power-supply: normal, access point temperature: 42.00 C, access point Anonymized 065 online time is: 1d 22h 48m 58s, access point bootcount total: 424, access point memory: 22.00 %, access point cpu: 1.00%, access point up-Port speed: 1000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 2 | 'Anonymized 065#ap.temperature.celsius'=42.00C;;;; 'Anonymized 065#ap.online.time'=168538;;;; 'Anonymized 065#ap.boot.total.count'=424;;;; 'Anonymized 065#ap.memory.used.percentage'=22.00%;;;; 'Anonymized 065#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 065#ap.up.port.bitspersecond'=1000b/s;;;; 'Anonymized 065#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 065#ap.online.user.count'=2;;;;
            ...      3     --filter-name='Anonymized 015'                                                                                                            OK: access point 'Anonymized 015' data link state: run, power-supply: normal, access point temperature: 39.00 C, access point Anonymized 015 online time is: 18d 5h 17m 15s, access point bootcount total: 26, access point memory: 24.00 %, access point cpu: 1.00%, access point up-Port speed: 18000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 1 | 'Anonymized 015#ap.temperature.celsius'=39.00C;;;; 'Anonymized 015#ap.online.time'=1574235;;;; 'Anonymized 015#ap.boot.total.count'=26;;;; 'Anonymized 015#ap.memory.used.percentage'=24.00%;;;; 'Anonymized 015#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 015#ap.up.port.bitspersecond'=18000b/s;;;; 'Anonymized 015#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 015#ap.online.user.count'=1;;;;
            ...      4     --filter-address='' --filter-name='Anonymized 015'                                                                                        OK: access point 'Anonymized 015' data link state: run, power-supply: normal, access point temperature: 39.00 C, access point Anonymized 015 online time is: 18d 5h 17m 15s, access point bootcount total: 26, access point memory: 24.00 %, access point cpu: 1.00%, access point up-Port speed: 18000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 1 | 'Anonymized 015#ap.temperature.celsius'=39.00C;;;; 'Anonymized 015#ap.online.time'=1574235;;;; 'Anonymized 015#ap.boot.total.count'=26;;;; 'Anonymized 015#ap.memory.used.percentage'=24.00%;;;; 'Anonymized 015#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 015#ap.up.port.bitspersecond'=18000b/s;;;; 'Anonymized 015#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 015#ap.online.user.count'=1;;;;
            ...      5     --filter-group="" --filter-name='Anonymized 075'                                                                                          OK: access point 'Anonymized 075' data link state: run, power-supply: normal, access point temperature: 42.00 C, access point Anonymized 075 online time is: 1d 22h 48m 55s, access point bootcount total: 297, access point memory: 22.00 %, access point cpu: 1.00%, access point up-Port speed: 6000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 7 | 'Anonymized 075#ap.temperature.celsius'=42.00C;;;; 'Anonymized 075#ap.online.time'=168535;;;; 'Anonymized 075#ap.boot.total.count'=297;;;; 'Anonymized 075#ap.memory.used.percentage'=22.00%;;;; 'Anonymized 075#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 075#ap.up.port.bitspersecond'=6000b/s;;;; 'Anonymized 075#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 075#ap.online.user.count'=7;;;;
            ...      6     --warning-status='\\\%{powersupply} eq "limited"' --filter-name='Anonymized 030'                                                          CRITICAL: access point 'Anonymized 030' data link state: run, power-supply: limited | 'Anonymized 030#ap.temperature.celsius'=49.00C;;;; 'Anonymized 030#ap.online.time'=5281831;;;; 'Anonymized 030#ap.boot.total.count'=9;;;; 'Anonymized 030#ap.memory.used.percentage'=42.00%;;;; 'Anonymized 030#ap.cpu.used.percentage'=12.00%;;;; 'Anonymized 030#ap.up.port.bitspersecond'=235000b/s;;;; 'Anonymized 030#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 030#ap.online.user.count'=8;;;;
            ...      7     --critical-status='\\\%{powersupply} =~ /insufficient|limited/ || \\\%{datalinkstate} !~ /run/' --filter-name='Anonymized 010'            OK: access point 'Anonymized 010' data link state: run, power-supply: normal, access point temperature: 46.00 C, access point Anonymized 010 online time is: 56d 6h 55m 39s, access point bootcount total: 84, access point memory: 23.00 %, access point cpu: 1.00%, access point up-Port speed: 9933000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 8 | 'Anonymized 010#ap.temperature.celsius'=46.00C;;;; 'Anonymized 010#ap.online.time'=4863339;;;; 'Anonymized 010#ap.boot.total.count'=84;;;; 'Anonymized 010#ap.memory.used.percentage'=23.00%;;;; 'Anonymized 010#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 010#ap.up.port.bitspersecond'=9933000b/s;;;; 'Anonymized 010#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 010#ap.online.user.count'=8;;;;
            ...      8     --warning-temperature=0 --critical-temperature=100 --filter-name='Anonymized 010'                                                         WARNING: access point 'Anonymized 010' access point temperature: 46.00 C | 'Anonymized 010#ap.temperature.celsius'=46.00C;0:0;0:100;; 'Anonymized 010#ap.online.time'=4863339;;;; 'Anonymized 010#ap.boot.total.count'=84;;;; 'Anonymized 010#ap.memory.used.percentage'=23.00%;;;; 'Anonymized 010#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 010#ap.up.port.bitspersecond'=9933000b/s;;;; 'Anonymized 010#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 010#ap.online.user.count'=8;;;;
            ...      9     --warning-bootcount-total=1 --critical-bootcount-total=2 --filter-name='Anonymized 010'                                                   CRITICAL: access point 'Anonymized 010' access point bootcount total: 84 | 'Anonymized 010#ap.temperature.celsius'=46.00C;;;; 'Anonymized 010#ap.online.time'=4863339;;;; 'Anonymized 010#ap.boot.total.count'=84;0:1;0:2;; 'Anonymized 010#ap.memory.used.percentage'=23.00%;;;; 'Anonymized 010#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 010#ap.up.port.bitspersecond'=9933000b/s;;;; 'Anonymized 010#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 010#ap.online.user.count'=8;;;;
            ...      10    --warning-memory=0 --critical-memory=0 --filter-name='Anonymized 000'                                                                     CRITICAL: access point 'Anonymized 000' access point memory: 23.00 % | 'Anonymized 000#ap.temperature.celsius'=45.00C;;;; 'Anonymized 000#ap.online.time'=2258619;;;; 'Anonymized 000#ap.boot.total.count'=115;;;; 'Anonymized 000#ap.memory.used.percentage'=23.00%;0:0;0:0;; 'Anonymized 000#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 000#ap.up.port.bitspersecond'=1000b/s;;;; 'Anonymized 000#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 000#ap.online.user.count'=0;;;;
            ...      11    --warning-cpu='10' --critical-cpu='0' --filter-name='Anonymized 000'                                                                      CRITICAL: access point 'Anonymized 000' access point cpu: 1.00% | 'Anonymized 000#ap.temperature.celsius'=45.00C;;;; 'Anonymized 000#ap.online.time'=2258619;;;; 'Anonymized 000#ap.boot.total.count'=115;;;; 'Anonymized 000#ap.memory.used.percentage'=23.00%;;;; 'Anonymized 000#ap.cpu.used.percentage'=1.00%;0:10;0:0;; 'Anonymized 000#ap.up.port.bitspersecond'=1000b/s;;;; 'Anonymized 000#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 000#ap.online.user.count'=0;;;;
            ...      12    --warning-up-port-speed=0 --critical-up-port-speed=0 --filter-name='Anonymized 001'                                                       CRITICAL: access point 'Anonymized 001' data link state: run, power-supply: limited, access point up-Port speed: 1000 b/s | 'Anonymized 001#ap.temperature.celsius'=41.00C;;;; 'Anonymized 001#ap.online.time'=1319610;;;; 'Anonymized 001#ap.boot.total.count'=1023;;;; 'Anonymized 001#ap.memory.used.percentage'=22.00%;;;; 'Anonymized 001#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 001#ap.up.port.bitspersecond'=1000b/s;0:0;0:0;; 'Anonymized 001#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 001#ap.online.user.count'=1;;;;
            ...      13    --warning-up-port-packet-err=0 --critical-up-port-packet-err=0 --filter-name='Anonymized 000'                                             OK: access point 'Anonymized 000' data link state: run, power-supply: normal, access point temperature: 45.00 C, access point Anonymized 000 online time is: 26d 3h 23m 39s, access point bootcount total: 115, access point memory: 23.00 %, access point cpu: 1.00%, access point up-Port speed: 1000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 0 | 'Anonymized 000#ap.temperature.celsius'=45.00C;;;; 'Anonymized 000#ap.online.time'=2258619;;;; 'Anonymized 000#ap.boot.total.count'=115;;;; 'Anonymized 000#ap.memory.used.percentage'=23.00%;;;; 'Anonymized 000#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 000#ap.up.port.bitspersecond'=1000b/s;;;; 'Anonymized 000#ap.up.port.package.error.percentage'=0.00;0:0;0:0;; 'Anonymized 000#ap.online.user.count'=0;;;;
            ...      14    --warning-online-user-num=0 --critical-online-user-num=0 --filter-name='Anonymized 000'                                                   OK: access point 'Anonymized 000' data link state: run, power-supply: normal, access point temperature: 45.00 C, access point Anonymized 000 online time is: 26d 3h 23m 39s, access point bootcount total: 115, access point memory: 23.00 %, access point cpu: 1.00%, access point up-Port speed: 1000 b/s, access point up-Port packet errors: 0.00%, access online user nums: 0 | 'Anonymized 000#ap.temperature.celsius'=45.00C;;;; 'Anonymized 000#ap.online.time'=2258619;;;; 'Anonymized 000#ap.boot.total.count'=115;;;; 'Anonymized 000#ap.memory.used.percentage'=23.00%;;;; 'Anonymized 000#ap.cpu.used.percentage'=1.00%;;;; 'Anonymized 000#ap.up.port.bitspersecond'=1000b/s;;;; 'Anonymized 000#ap.up.port.package.error.percentage'=0.00;;;; 'Anonymized 000#ap.online.user.count'=0;0:0;0:0;;