#!/usr/bin/env bats

setup() {
    load '/usr/lib/bats/bats-support/load.bash'
    load '/usr/lib/bats/bats-assert/load.bash'

    # Work around bug https://sourceforge.net/p/ktoblzcheck/bugs/25/
    # in ktoblzupdate causing a segfault if it doesn't exist
    mkdir -pv "$HOME/.local/share"
}

# Provision bankdata in $HOME/.local/share/ktoblzcheck
@test "Run 'ktoblzupdate' to provision some bankdata" {
    run ktoblzupdate
    assert_success
    assert_output --partial "Updated all databases successfully"
}

# Run the actual test
@test "Run 'ktoblzcheck 10000000 1' and check for expected output" {
    run ktoblzcheck 10000000 1
    assert_success
    assert_output --partial Bundesbank
    assert_output --partial Berlin
}
