% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistic-aucell.R
\name{run_aucell}
\alias{run_aucell}
\title{AUCell}
\usage{
run_aucell(
  mat,
  network,
  .source = source,
  .target = target,
  aucMaxRank = ceiling(0.05 * nrow(rankings)),
  nproc = availableCores(),
  seed = 42,
  minsize = 5
)
}
\arguments{
\item{mat}{Matrix to evaluate (e.g. expression matrix).
Target nodes in rows and conditions in columns.
\code{rownames(mat)} must have at least one intersection with the elements
in \code{network} \code{.target} column.}

\item{network}{Tibble or dataframe with edges and it's associated metadata.}

\item{.source}{Column with source nodes.}

\item{.target}{Column with target nodes.}

\item{aucMaxRank}{Threshold to calculate the AUC.}

\item{nproc}{Number of cores to use for computation.}

\item{seed}{A single value, interpreted as an integer, or NULL for random
number generation.}

\item{minsize}{Integer indicating the minimum number of targets per source.}
}
\description{
Calculates regulatory activities using AUCell.
}
\details{
AUCell (Aibar et al., 2017) uses the Area Under the Curve (AUC) to calculate
whether a set of targets is enriched within the molecular readouts of each
sample. To do so, AUCell first ranks the molecular features of each sample
from highest to lowest value, resolving ties randomly. Then, an AUC can be
calculated using by default the top 5\% molecular features in the ranking.
Therefore, this metric, \code{aucell}, represents the proportion of
abundant molecular features in the target set, and their relative abundance
value compared to the other features within the sample.

Aibar S. et al. (2017) Scenic: single-cell regulatory network inference and
clustering. Nat. Methods, 14, 1083–1086.
}
\examples{
inputs_dir <- system.file("testdata", "inputs", package = "decoupleR")

mat <- readRDS(file.path(inputs_dir, "mat.rds"))
net <- readRDS(file.path(inputs_dir, "net.rds"))

run_aucell(mat, net, minsize=0, nproc=1, aucMaxRank=3)
}
\seealso{
Other decoupleR statistics: 
\code{\link{decouple}()},
\code{\link{run_fgsea}()},
\code{\link{run_gsva}()},
\code{\link{run_mdt}()},
\code{\link{run_mlm}()},
\code{\link{run_ora}()},
\code{\link{run_udt}()},
\code{\link{run_ulm}()},
\code{\link{run_viper}()},
\code{\link{run_wmean}()},
\code{\link{run_wsum}()}
}
\concept{decoupleR statistics}
