% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepareDirectoryUpload.R
\name{prepareDirectoryUpload}
\alias{prepareDirectoryUpload}
\title{Prepare to upload a directory}
\usage{
prepareDirectoryUpload(
  directory,
  links = c("auto", "always", "never"),
  cache = cacheDirectory()
)
}
\arguments{
\item{directory}{String containing the path to a directory, the contents of which are to be uploaded via \code{\link{startUpload}}.}

\item{links}{String indicating how to handle symlinks in \code{directory}.
\itemize{
\item \code{"auto"} will attempt to convert symlinks into upload links.
If the conversion fails, a regular upload is performed.
\item \code{"always"} will attempt to convert symlinks into upload links.
If the conversion fails, an error is raised.
\item \code{"never"} will never attempt to convert symlinks into upload links.
All symlinked files are treated as regular uploads.
}}

\item{cache}{String containing a path to the cache directory, used to convert symlinks into upload links.}
}
\value{
List containing \code{files}, a character vector to be used as \code{files=} in \code{\link{startUpload}};
and \code{links}, a data frame to be used as \code{links=} in \code{\link{startUpload}}.
}
\description{
Prepare to upload a directory's contents via \code{\link{startUpload}}.
This goes through the directory to list its contents and convert symlinks to upload links.
}
\details{
Files in \code{directory} (that are not symlinks) are used as regular uploads, i.e., \code{files=} in \code{\link{startUpload}}.

If \code{directory} contains a symlink to a file in \code{cache}, 
we assume that it points to a file that was previously downloaded by, e.g., \code{\link{saveFile}} or \code{\link{saveVersion}}.
Thus, instead of performing a regular upload, we attempt to create an upload link, i.e., \code{links=} in \code{\link{startUpload}}.
This is achieved by examining the destination path of the symlink and inferring the link destination in the backend.
Note that this still works if the symlinks are dangling.

If a symlink cannot be converted into an upload link, it will be used as a regular upload,
i.e., the contents of the symlink destination will be uploaded by \code{\link{startUpload}}.
In this case, an error will be raised if the symlink is dangling as there is no file that can actually be uploaded.
If \code{links="always"}, an error is raised instead upon symlink conversion failure.

This function is intended to be used with \code{\link{cloneVersion}}, which creates symlinks to files in \code{cache}.
}
\examples{
tmp <- tempfile()
out <- cloneVersion("test-R", "basic", "v1", destination=tmp)
write(file=file.path(tmp, "heanna"), "sumire")
prepareDirectoryUpload(tmp)

}
\seealso{
\code{\link{startUpload}}, to actually start the upload.

\code{\link{cloneVersion}}, to prepare the symlinks.
}
