% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_layout.R
\name{channelHeatmap}
\alias{channelHeatmap}
\title{Create layout plot of flowcell}
\usage{
channelHeatmap(data, zValue)
}
\arguments{
\item{data}{A data.frame.  Should have at least two columns, 
one of which has the name 'channel'.}

\item{zValue}{Character string specifying the name of the column to be used 
for the colour scaling.}
}
\value{
Returns an object of \code{gg} representing the plot.
}
\description{
Creates a plot representing the layout of a MinION flow cell.  Each circle
represents an individual channel with the intensity relecting a specified 
sequencing metric.  This function is a more generalised version of 
\code{\link{layoutPlot}}, allowing the user to map any value the like on 
the channel layout.
}
\examples{
library(dplyr)
if( require(minionSummaryData) ) {
   data(s.typhi.rep2, package = 'minionSummaryData')
   ## calculate and plot the mean number of events recorded by each channel
   avgEvents <- left_join(readInfo(s.typhi.rep2), eventData(s.typhi.rep2), by = 'id') \%>\% 
   group_by(channel) \%>\% 
   summarise(mean_nevents = mean(num_events))
   channelHeatmap(avgEvents, zValue = 'mean_nevents')
}
}
