% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/averageGroupedStats.R
\name{averageGroupedStats}
\alias{averageGroupedStats}
\title{Average grouped statistics}
\usage{
averageGroupedStats(values, grouping, weights = NULL)
}
\arguments{
\item{values}{A numeric vector containing statistics for individual tests.}

\item{grouping}{A vector or factor of length equal to \code{p.values}, specifying the group to which each test is assigned.

Alternatively, an \link{rle} object where each run corresponds to a group and specifies the entries of \code{p.values} belonging to that group.
This assumes that \code{p.values} is ordered such that all entries in the same group are adjacent to each other.}

\item{weights}{A numeric vector of length equal to \code{p.values}, containing a positive weight for each test.
Alternatively \code{NULL}, in which case equal weights are assigned to all tests.}
}
\value{
A named numeric vector of (weighted) averages, of length equal to the number of unique levels in \code{grouping}.
}
\description{
Average grouped statistics with consideration of weights and protection from missing values.
}
\details{
If \code{weights} is supplied, a weighted average is computed for each group.
If \code{values} contains missing values, they are ignored and will not contribute to the average.
}
\examples{
grouping <- sample(LETTERS, 20, replace=TRUE)
averageGroupedStats(1:20, grouping)
averageGroupedStats(1:20, grouping, weights=runif(20))

}
\seealso{
\code{\link{averageParallelStats}}, for the parallel counterpart.
}
\author{
Aaron Lun
}
