% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut_type.R
\name{mut_type}
\alias{mut_type}
\title{Retrieve base substitution types from a VCF object}
\usage{
mut_type(vcf)
}
\arguments{
\item{vcf}{A CollapsedVCF object}
}
\value{
Character vector with base substitution types
}
\description{
A function to extract the base substitutions from a vcf and translate to
the 6 common base substitution types.
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
vcfs <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
  package = "MutationalPatterns"
))

mut_type(vcfs[[1]])
}
\seealso{
\code{\link{read_vcfs_as_granges}}
}
