% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut_type_occurrences.R
\name{mut_type_occurrences}
\alias{mut_type_occurrences}
\title{Count the occurrences of each base substitution type}
\usage{
mut_type_occurrences(vcf_list, ref_genome)
}
\arguments{
\item{vcf_list}{GRangesList or GRanges object.}

\item{ref_genome}{BSgenome reference genome object}
}
\value{
data.frame with counts of each base substitution type for
each sample in vcf_list
}
\description{
Count the occurrences of each base substitution type
}
\examples{
## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
vcfs <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
  package = "MutationalPatterns"
))

## Load a reference genome.
ref_genome <- "BSgenome.Hsapiens.UCSC.hg19"
library(ref_genome, character.only = TRUE)

## Get the type occurrences for all VCF objects.
type_occurrences <- mut_type_occurrences(vcfs, ref_genome)
}
\seealso{
\code{\link{read_vcfs_as_granges}},
}
