% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{ansi-styles}
\alias{ansi-styles}
\alias{bg_black}
\alias{bg_blue}
\alias{bg_cyan}
\alias{bg_green}
\alias{bg_magenta}
\alias{bg_red}
\alias{bg_white}
\alias{bg_yellow}
\alias{bg_none}
\alias{bg_br_black}
\alias{bg_br_blue}
\alias{bg_br_cyan}
\alias{bg_br_green}
\alias{bg_br_magenta}
\alias{bg_br_red}
\alias{bg_br_white}
\alias{bg_br_yellow}
\alias{col_black}
\alias{col_blue}
\alias{col_cyan}
\alias{col_green}
\alias{col_magenta}
\alias{col_red}
\alias{col_white}
\alias{col_yellow}
\alias{col_grey}
\alias{col_silver}
\alias{col_none}
\alias{col_br_black}
\alias{col_br_blue}
\alias{col_br_cyan}
\alias{col_br_green}
\alias{col_br_magenta}
\alias{col_br_red}
\alias{col_br_white}
\alias{col_br_yellow}
\alias{style_dim}
\alias{style_blurred}
\alias{style_bold}
\alias{style_hidden}
\alias{style_inverse}
\alias{style_italic}
\alias{style_reset}
\alias{style_strikethrough}
\alias{style_underline}
\alias{style_no_bold}
\alias{style_no_blurred}
\alias{style_no_dim}
\alias{style_no_italic}
\alias{style_no_underline}
\alias{style_no_inverse}
\alias{style_no_hidden}
\alias{style_no_strikethrough}
\alias{style_no_color}
\alias{style_no_bg_color}
\title{ANSI colored text}
\usage{
bg_black(...)

bg_blue(...)

bg_cyan(...)

bg_green(...)

bg_magenta(...)

bg_red(...)

bg_white(...)

bg_yellow(...)

bg_none(...)

bg_br_black(...)

bg_br_blue(...)

bg_br_cyan(...)

bg_br_green(...)

bg_br_magenta(...)

bg_br_red(...)

bg_br_white(...)

bg_br_yellow(...)

col_black(...)

col_blue(...)

col_cyan(...)

col_green(...)

col_magenta(...)

col_red(...)

col_white(...)

col_yellow(...)

col_grey(...)

col_silver(...)

col_none(...)

col_br_black(...)

col_br_blue(...)

col_br_cyan(...)

col_br_green(...)

col_br_magenta(...)

col_br_red(...)

col_br_white(...)

col_br_yellow(...)

style_dim(...)

style_blurred(...)

style_bold(...)

style_hidden(...)

style_inverse(...)

style_italic(...)

style_reset(...)

style_strikethrough(...)

style_underline(...)

style_no_bold(...)

style_no_blurred(...)

style_no_dim(...)

style_no_italic(...)

style_no_underline(...)

style_no_inverse(...)

style_no_hidden(...)

style_no_strikethrough(...)

style_no_color(...)

style_no_bg_color(...)
}
\arguments{
\item{...}{Character strings, they will be pasted together with
\code{paste0()}, before applying the style function.}
}
\value{
An ANSI string (class \code{cli_ansi_string}), that contains ANSI
sequences, if the current platform supports them. You can simply
use \code{cat()} to print them to the terminal.
}
\description{
cli has a number of functions to color and style text at the command
line. They provide a mode modern interface than the crayon package.
}
\details{
The \verb{col_*} functions change the (foreground) color to the text.
These are the eight original ANSI colors. Note that in some terminals,
they might actually look differently, as terminals have their own
settings for how to show them. \code{col_none()} is the default color, this
is useful in a substring of a colored string.

The \verb{col_br_*} functions are bright versions of the eight ANSI colors.
Note that on some terminal configurations and themes they might be the
same as the non-bright colors.

The \verb{bg_*} functions change the background color of the text.
These are the eight original ANSI background colors. These, too, can
vary in appearance, depending on terminal settings. \code{bg_none()} the
the default background color, this is useful in a substring of a
background-colored string.

The \verb{bg_br_*} functions are the bright versions of the eight ANSI
background colors. Note that on some terminal configurations and themes
they might be the same as the non-bright colors.

The \verb{style_*} functions apply other styling to the text. The currently
supported styling functions are:
\itemize{
\item \code{style_reset()} to remove any style, including color,
\item \code{style_bold()} for boldface / strong text, although some terminals
show a bright, high intensity text instead,
\item \code{style_dim()} (or \code{style_blurred()} reduced intensity text.
\item \code{style_italic()} (not widely supported).
\item \code{style_underline()},
\item \code{style_inverse()},
\item \code{style_hidden()},
\item \code{style_strikethrough()} (not widely supported).
}

The style functions take any number of character vectors as arguments,
and they concatenate them using \code{paste0()} before adding the style.

Styles can also be nested, and then inner style takes precedence, see
examples below.

Sometimes you want to revert back to the default text color, in the
middle of colored text, or you want to have a normal font in the middle
of italic text. You can use the \verb{style_no_*} functions for this. Every
\verb{style_*()} function has a \verb{style_no_*()} pair, which defends its
argument from taking on the style. See examples below.
}
\examples{
col_blue("Hello ", "world!")
cat(col_blue("Hello ", "world!"))

cat("... to highlight the", col_red("search term"),
    "in a block of text\n")

## Style stack properly
cat(col_green(
 "I am a green line ",
 col_blue(style_underline(style_bold("with a blue substring"))),
 " that becomes green again!"
))

error <- combine_ansi_styles("red", "bold")
warn <- combine_ansi_styles("magenta", "underline")
note <- col_cyan
cat(error("Error: subscript out of bounds!\n"))
cat(warn("Warning: shorter argument was recycled.\n"))
cat(note("Note: no such directory.\n"))

# style_no_* functions, note that the color is not removed
style_italic(col_green(paste0(
  "italic before, ",
  style_no_italic("normal here, "),
  "italic after"
)))

# avoiding  color for substring
style_italic(col_red(paste(
  "red before",
  col_none("not red between"),
  "red after"
)))
}
\seealso{
Other ANSI styling: 
\code{\link{combine_ansi_styles}()},
\code{\link{make_ansi_style}()},
\code{\link{num_ansi_colors}()}
}
\concept{ANSI styling}
