% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/replace_na.R
\name{replace_na.dtplyr_step}
\alias{replace_na.dtplyr_step}
\title{Replace NAs with specified values}
\usage{
\method{replace_na}{dtplyr_step}(data, replace = list())
}
\arguments{
\item{data}{A \code{\link[=lazy_dt]{lazy_dt()}}.}

\item{replace}{If \code{data} is a data frame, \code{replace} takes a list of values,
with one value for each column that has \code{NA} values to be replaced.

If \code{data} is a vector, \code{replace} takes a single value. This single value
replaces all of the \code{NA} values in the vector.}
}
\description{
This is a method for the tidyr \code{replace_na()} generic. It is translated to
\code{\link[data.table:coalesce]{data.table::fcoalesce()}}.

Note that unlike \code{tidyr::replace_na()}, \code{data.table::fcoalesce()} cannot
replace \code{NULL} values in lists.
}
\examples{
library(tidyr)

# Replace NAs in a data frame
dt <- lazy_dt(tibble(x = c(1, 2, NA), y = c("a", NA, "b")))
dt \%>\% replace_na(list(x = 0, y = "unknown"))

# Replace NAs using `dplyr::mutate()`
dt \%>\% dplyr::mutate(x = replace_na(x, 0))
}
