% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggpairs.R
\name{ggduo}
\alias{ggduo}
\title{\pkg{ggplot2} generalized pairs plot for two columns sets of data}
\usage{
ggduo(
  data,
  mapping = NULL,
  columnsX = 1:ncol(data),
  columnsY = 1:ncol(data),
  title = NULL,
  types = list(continuous = "smooth_loess", comboVertical = "box_no_facet",
    comboHorizontal = "facethist", discrete = "count"),
  axisLabels = c("show", "none"),
  columnLabelsX = colnames(data[columnsX]),
  columnLabelsY = colnames(data[columnsY]),
  labeller = "label_value",
  switch = NULL,
  xlab = NULL,
  ylab = NULL,
  showStrips = NULL,
  legend = NULL,
  cardinality_threshold = 15,
  progress = NULL,
  xProportions = NULL,
  yProportions = NULL,
  legends = stop("deprecated")
)
}
\arguments{
\item{data}{data set using.  Can have both numerical and categorical data.}

\item{mapping}{aesthetic mapping (besides \code{x} and \code{y}).  See \code{\link[ggplot2]{aes}()}.  If \code{mapping} is numeric, \code{columns} will be set to the \code{mapping} value and \code{mapping} will be set to \code{NULL}.}

\item{columnsX, columnsY}{which columns are used to make plots.  Defaults to all columns.}

\item{title, xlab, ylab}{title, x label, and y label for the graph}

\item{types}{see Details}

\item{axisLabels}{either "show" to display axisLabels or "none" for no axis labels}

\item{columnLabelsX, columnLabelsY}{label names to be displayed.  Defaults to names of columns being used.}

\item{labeller}{labeller for facets. See \code{\link[ggplot2]{labellers}}. Common values are \code{"label_value"} (default) and \code{"label_parsed"}.}

\item{switch}{switch parameter for facet_grid. See \code{ggplot2::\link[ggplot2]{facet_grid}}.  By default, the labels are displayed on the top and right of the plot. If \code{"x"}, the top labels will be displayed to the bottom. If \code{"y"}, the right-hand side labels will be displayed to the left. Can also be set to \code{"both"}}

\item{showStrips}{boolean to determine if each plot's strips should be displayed. \code{NULL} will default to the top and right side plots only. \code{TRUE} or \code{FALSE} will turn all strips on or off respectively.}

\item{legend}{May be the two objects described below or the default \code{NULL} value.  The legend position can be moved by using ggplot2's theme element \code{pm + theme(legend.position = "bottom")} \describe{\item{a numeric vector of length 2}{provides the location of the plot to use the legend for the plot matrix's legend. Such as \code{legend = c(3,5)} which will use the legend from the plot in the third row and fifth column}\item{a single numeric value}{provides the location of a plot according to the display order. Such as \code{legend = 3} in a plot matrix with 2 rows and 5 columns displayed by column will return the plot in position \code{c(1,2)}}\item{a object from \code{\link{grab_legend}()}}{a predetermined plot legend that will be displayed directly}}}

\item{cardinality_threshold}{maximum number of levels allowed in a character / factor column.  Set this value to NULL to not check factor columns. Defaults to 15}

\item{progress}{\code{NULL} (default) for a progress bar in interactive sessions with more than 15 plots, \code{TRUE} for a progress bar, \code{FALSE} for no progress bar, or a function that accepts at least a plot matrix and returns a new \code{progress::\link[progress]{progress_bar}}.  See \code{\link{ggmatrix_progress}}.}

\item{xProportions, yProportions}{Value to change how much area is given for each plot. Either \code{NULL} (default), numeric value matching respective length, \code{grid::\link[grid]{unit}} object with matching respective length or \code{"auto"} for automatic relative proportions based on the number of levels for categorical variables.}

\item{legends}{deprecated}
}
\description{
Make a matrix of plots with a given data set with two different column sets
}
\details{
\code{types} is a list that may contain the variables
'continuous', 'combo', 'discrete', and 'na'. Each element of the list may be a function or a string.  If a string is supplied, If a string is supplied, it must be a character string representing the tail end of a \code{ggally_NAME} function. The list of current valid \code{ggally_NAME} functions is visible in a dedicated vignette.
\describe{
\item{continuous}{This option is used for continuous X and Y data.}
\item{comboHorizontal}{This option is used for either continuous X and categorical Y data or categorical X and continuous Y data.}
\item{comboVertical}{This option is used for either continuous X and categorical Y data or categorical X and continuous Y data.}
\item{discrete}{This option is used for categorical X and Y data.}
\item{na}{This option is used when all X data is \code{NA}, all Y data is \code{NA}, or either all X or Y data is \code{NA}.}
}

If 'blank' is ever chosen as an option, then ggduo will produce an empty plot.

If a function is supplied as an option, it should implement the function api of \code{function(data, mapping, ...){#make ggplot2 plot}}.  If a specific function needs its parameters set, \code{\link{wrap}(fn, param1 = val1, param2 = val2)} the function with its parameters.
}
\examples{
 # small function to display plots only if it's interactive
 p_ <- GGally::print_if_interactive

 data(baseball, package = "plyr")

 # Keep players from 1990-1995 with at least one at bat
 # Add how many singles a player hit
 # (must do in two steps as X1b is used in calculations)
 dt <- transform(
   subset(baseball, year >= 1990 & year <= 1995 & ab > 0),
   X1b = h - X2b - X3b - hr
 )
 # Add
 #  the player's batting average,
 #  the player's slugging percentage,
 #  and the player's on base percentage
 # Make factor a year, as each season is discrete
 dt <- transform(
   dt,
   batting_avg = h / ab,
   slug = (X1b + 2*X2b + 3*X3b + 4*hr) / ab,
   on_base = (h + bb + hbp) / (ab + bb + hbp),
   year = as.factor(year)
 )


 pm <- ggduo(
   dt,
   c("year", "g", "ab", "lg"),
   c("batting_avg", "slug", "on_base"),
   mapping = ggplot2::aes(color = lg)
 )
 # Prints, but
 #   there is severe over plotting in the continuous plots
 #   the labels could be better
 #   want to add more hitting information
 p_(pm)

 # address overplotting issues and add a title
 pm <- ggduo(
   dt,
   c("year", "g", "ab", "lg"),
   c("batting_avg", "slug", "on_base"),
   columnLabelsX = c("year", "player game count", "player at bat count", "league"),
   columnLabelsY = c("batting avg", "slug \%", "on base \%"),
   title = "Baseball Hitting Stats from 1990-1995",
   mapping = ggplot2::aes(color = lg),
   types = list(
     # change the shape and add some transparency to the points
     continuous = wrap("smooth_loess", alpha = 0.50, shape = "+")
   ),
   showStrips = FALSE
 )

 p_(pm)

# Use "auto" to adapt width of the sub-plots
 pm <- ggduo(
   dt,
   c("year", "g", "ab", "lg"),
   c("batting_avg", "slug", "on_base"),
   mapping = ggplot2::aes(color = lg),
   xProportions = "auto"
 )

 p_(pm)

 # Custom widths & heights of the sub-plots
 pm <- ggduo(
   dt,
   c("year", "g", "ab", "lg"),
   c("batting_avg", "slug", "on_base"),
   mapping = ggplot2::aes(color = lg),
   xProportions = c(6, 4, 3, 2),
   yProportions = c(1, 2, 1)
 )

 p_(pm)

# Example derived from:
## R Data Analysis Examples | Canonical Correlation Analysis.  UCLA: Institute for Digital
##   Research and Education.
##   from http://www.stats.idre.ucla.edu/r/dae/canonical-correlation-analysis
##   (accessed May 22, 2017).
# "Example 1. A researcher has collected data on three psychological variables, four
#  academic variables (standardized test scores) and gender for 600 college freshman.
#  She is interested in how the set of psychological variables relates to the academic
#  variables and gender. In particular, the researcher is interested in how many
#  dimensions (canonical variables) are necessary to understand the association between
#  the two sets of variables."
data(psychademic)
summary(psychademic)

(psych_variables <- attr(psychademic, "psychology"))
(academic_variables <- attr(psychademic, "academic"))

## Within correlation
p_(ggpairs(psychademic, columns = psych_variables))
p_(ggpairs(psychademic, columns = academic_variables))

## Between correlation
loess_with_cor <- function(data, mapping, ..., method = "pearson") {
  x <- eval_data_col(data, mapping$x)
  y <- eval_data_col(data, mapping$y)
  cor <- cor(x, y, method = method)
  ggally_smooth_loess(data, mapping, ...) +
    ggplot2::geom_label(
      data = data.frame(
        x = min(x, na.rm = TRUE),
        y = max(y, na.rm = TRUE),
        lab = round(cor, digits = 3)
      ),
      mapping = ggplot2::aes(x = x, y = y, label = lab),
      hjust = 0, vjust = 1,
      size = 5, fontface = "bold",
      inherit.aes = FALSE # do not inherit anything from the ...
    )
}
pm <- ggduo(
  psychademic,
  rev(psych_variables), academic_variables,
  types = list(continuous = loess_with_cor),
  showStrips = FALSE
)
suppressWarnings(p_(pm)) # ignore warnings from loess

# add color according to sex
pm <- ggduo(
  psychademic,
  mapping = ggplot2::aes(color = sex),
  rev(psych_variables), academic_variables,
  types = list(continuous = loess_with_cor),
  showStrips = FALSE,
  legend = c(5,2)
)
suppressWarnings(p_(pm))


# add color according to sex
pm <- ggduo(
  psychademic,
  mapping = ggplot2::aes(color = motivation),
  rev(psych_variables), academic_variables,
  types = list(continuous = loess_with_cor),
  showStrips = FALSE,
  legend = c(5,2)
) +
  ggplot2::theme(legend.position = "bottom")
suppressWarnings(p_(pm))
}
