% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edges.R
\name{get_edges}
\alias{get_edges}
\title{Create edge extractor function}
\usage{
get_edges(format = "short", collapse = "none", ...)
}
\arguments{
\item{format}{Either \code{'short'} (the default) or \code{'long'}. See
details for a descriptions of the differences}

\item{collapse}{Either \code{'none'} (the default), \code{'all'} or
\code{'direction'}. Specifies whether parallel edges should be merged. See
details for more information}

\item{...}{Additional data that will be cbind'ed together with the returned
edge data.}
}
\value{
A data.frame with columns dependent on format as well as the graph
type. In addition to the columns discussed in the details section,
the data.frame will always contain the columns \code{from}, \code{to} and
\code{circular}, the two former giving the indexes of the start and end node
and the latter if the layout is circular (needed for correct formatting of
some \verb{geom_edge_*}). The graph dependent information is:

\describe{
\item{dendrogram}{A \code{label} column will hold the value of the
\code{edgetext} attribute. In addition any value stored in the
\code{edgePar} attribute will be added. Lastly a \code{direction} column
will hold the relative position between the start and end nodes (needed for
correct formatting of \code{\link[=geom_edge_elbow]{geom_edge_elbow()}}).}
\item{igraph}{All edge attributes of the original graph object is added as
columns to the data.frame}
}
}
\description{
This function returns another function that can extract edges from a
ggraph_layout object. The functionality of the returned function is decided
by the arguments to \code{get_edges}. The need for \code{get_edges} is mainly to
pass to the \code{data} argument of the different \verb{geom_edge_*}
functions in order to present them with the right kind of data. In general
each \verb{geom_edge_*} has the default set correctly so there is only need
to modify the data argument if parallel edges should be collapsed.
}
\details{
There are two types of return formats possible for the result of the returned
function:

\describe{
\item{short}{In this format each edge is described in one line in the
format expected for \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment()}}, that is, the start
node position is encoded in the \code{x} and \code{y} column and the end
node position is encoded in the \code{xend} and \code{yend} column. If node
parameters are added to the edge the name of the parameters will be
prefixed with \code{node1.} for the start node and \code{node2.} for the
end node.}
\item{long}{In this format each edge consists of two rows with matching
\code{edge.id} value. The start and end position are both encoded in the
\code{x} and \code{y} column. The relative position of the rows determines
which is the start and end node, the first occurring being the start node.
If node parameters are added to the edge data the name of the parameters
will be prefixed with \code{node.}.}
}

Node parameters are automatically added so it is possible to format edge
aesthetics according to start or end node parameters, or interpolate edge
aesthetics between start and end node parameters. Node parameters will be
prefixed to avoid name clash with edge parameters. The prefix depends on the
format (see above).

If the graph is not simple (it contains at most one edge between each node
pair) it can be collapsed so either all edges between two nodes or all edges
of the same direction between two nodes are merged. The edge parameters are
taken from the first occurring edge, so if some more sophisticated summary is
needed it is suggested that the graph be tidied up before plotting with
ggraph.
}
\seealso{
Other extractors: 
\code{\link{get_con}()},
\code{\link{get_nodes}()}
}
\concept{extractors}
