% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp.R
\name{response}
\alias{response}
\title{Create a new HTTP response}
\usage{
response(
  status_code = 200,
  url = "https://example.com",
  method = "GET",
  headers = list(),
  body = raw()
)
}
\arguments{
\item{status_code}{HTTP status code. Must be a single integer.}

\item{url}{URL response came from; might not be the same as the URL in
the request if there were any redirects.}

\item{method}{HTTP method used to retrieve the response.}

\item{headers}{HTTP headers. Can be supplied as a raw or character vector
which will be parsed using the standard rules, or a named list.}

\item{body}{Response, if any, contained in the response body.}
}
\value{
An HTTP response: an S3 list with class \code{httr2_response}.
}
\description{
Generally, you should not need to call this function directly; you'll
get a real HTTP response by calling \code{\link[=req_perform]{req_perform()}} and friends. This
function is provided primarily for testing, and a place to describe
the key components of a response.
}
\examples{
response()
response(404, method = "POST")
response(headers = c("Content-Type: text/html", "Content-Length: 300"))
}
\keyword{internal}
