% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{sendData}
\alias{sendData}
\title{Send data to a web page}
\usage{
sendData(
  variableName,
  variable,
  keepAsVector = FALSE,
  rowwise = TRUE,
  sessionId = NULL,
  wait = 0
)
}
\arguments{
\item{variableName}{Name that the variable will have on the web page.}

\item{variable}{Variable to send.}

\item{keepAsVector}{If \code{TRUE}, variables with length 1 will be saved as arrays on the web page, otherwise they 
will be converted to atomic types.}

\item{rowwise}{If \code{TRUE}, matrices and data.frames will be transformed into JavaScript objects or arrays
row wise (e.g. a matrix will become an Array of its rows).}

\item{sessionId}{An ID of the session to which the data should be sent. Can also be a vector of multiple session IDs.
If \code{NULL}, the data will be sent to all currently active sessions.}

\item{wait}{If \code{wait > 0}, after sending the message, R will wait for a reply for a given number of seconds. 
For this time (or until the reply is received), execution of other commands will be halted. Any incoming message 
from the session will be considered as a reply.}
}
\description{
Sends a variable to a web page, where it is saved under a specified name. This function
is a wrapper around \code{sendData} method of class \code{\link{Session}}.
}
\details{
To send data back from the web page to the current R session one should use\code{jrc.sendData(variableName, variable, internal)}.
Its arguments are:

\describe{
   \item{\code{variableName}}{
      Name that the variable will have in the R session. If variable name hasn't been previously added to the list
      of allowed variables (see \code{\link{allowVariables}} or \code{allowedVariables} argument of the \code{\link{openPage}}
      function), attempt to assign it from a web page will require manual authorization on the R side.
   }
   \item{\code{variable}}{
      Variable to send.
   }
   \item{\code{internal} (optional)}{
      Whether this variable should be used only by the session that sent it. If \code{true}, variable will be stored
      in the session-specific environment and can be accessed from the outside with \code{\link{getSessionVariable}}
      function. If \code{false}, variable will be saved to the outer environment of the app (see \code{\link{setEnvironment}}).
      By default, uses \code{true} for variables that already exist in the session specific environment 
      (see \code{\link{setSessionVariables}} or \code{sessionVariables} argument of the \code{\link{openPage}} function.)
      and \code{false} otherwise.
   }
}
}
\examples{
\dontrun{
# to run this example an installed web browser is required
openPage()
x <- 1:100
sendData("x", x)
sendCommand("console.log(x);")
sendCommand("jrc.sendData('x', x.filter(function(e) {return e \% 2 == 0}))")
closePage()}

}
\seealso{
\code{\link{authorize}}, \code{\link{allowVariables}}, \code{\link{sendCommand}},
\code{\link{callFunction}}, \code{\link{sendHTML}}, \code{\link{openPage}}, \code{\link{getSessionIds}}.
}
