% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_source_expressions.R
\name{get_source_expressions}
\alias{get_source_expressions}
\title{Parsed sourced file from a filename}
\usage{
get_source_expressions(filename, lines = NULL)
}
\arguments{
\item{filename}{the file to be parsed.}

\item{lines}{a character vector of lines.
If \code{NULL}, then \code{filename} will be read.}
}
\value{
A \code{list} with three components:
\describe{
\item{expressions}{a \code{list} of
\code{n+1} objects. The first \code{n} elements correspond to each expression in
\code{filename}, and consist of a list of 8 elements:
\itemize{
\item{\code{filename} (\code{character}) the name of the file.}
\item{\code{line} (\code{integer}) the line in the file where this expression begins.}
\item{\code{column} (\code{integer}) the column in the file where this expression begins.}
\item{\code{lines} (named \code{character}) vector of all lines spanned by this
expression, named with the corresponding line numbers.}
\item{\code{parsed_content} (\code{data.frame}) as given by \code{\link[utils:getParseData]{utils::getParseData()}} for this expression.}
\item{\code{xml_parsed_content} (\code{xml_document}) the XML parse tree of this expression as given by
\code{\link[xmlparsedata:xml_parse_data]{xmlparsedata::xml_parse_data()}}.}
\item{\code{content} (\code{character}) the same as \code{lines} as a single string (not split across lines).}
\item{\code{xml_find_function_calls(function_names)} (\code{function}) a function that returns all \code{SYMBOL_FUNCTION_CALL}
XML nodes from \code{xml_parsed_content} with specified function names.}
}

The final element of \code{expressions} is a list corresponding to the full file
consisting of 7 elements:
\itemize{
\item{\code{filename} (\code{character}) the name of this file.}
\item{\code{file_lines} (\code{character}) the \code{\link[=readLines]{readLines()}} output for this file.}
\item{\code{content} (\code{character}) for .R files, the same as \code{file_lines};
for .Rmd or .qmd scripts, this is the extracted R source code (as text).}
\item{\code{full_parsed_content} (\code{data.frame}) as given by
\code{\link[utils:getParseData]{utils::getParseData()}} for the full content.}
\item{\code{full_xml_parsed_content} (\code{xml_document}) the XML parse tree of all
expressions as given by \code{\link[xmlparsedata:xml_parse_data]{xmlparsedata::xml_parse_data()}}.}
\item{\code{terminal_newline} (\code{logical}) records whether \code{filename} has a terminal
newline (as determined by \code{\link[=readLines]{readLines()}} producing a corresponding warning).}
\item{\code{xml_find_function_calls(function_names)} (\code{function}) a function that returns all \code{SYMBOL_FUNCTION_CALL}
XML nodes from \code{full_xml_parsed_content} with specified function names.}
}
}
\item{error}{A \code{Lint} object describing any parsing error.}
\item{warning}{A \code{lints} object describing any parsing warning.}
\item{lines}{The \code{\link[=readLines]{readLines()}} output for this file.}
}
}
\description{
This object is given as input to each linter.
}
\details{
The file is read using the \code{encoding} setting.
This setting is found by taking the first valid result from the following locations
\enumerate{
\item The \code{encoding} key from the usual lintr configuration settings.
\item The \code{Encoding} field from a Package \code{DESCRIPTION} file in a parent directory.
\item The \code{Encoding} field from an R Project \code{.Rproj} file in a parent directory.
\item \code{"UTF-8"} as a fallback.
}
}
\examples{
tmp <- tempfile()
writeLines(c("x <- 1", "y <- x + 1"), tmp)
get_source_expressions(tmp)
unlink(tmp)
}
