% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.regression.R
\name{BinAugmentCifstrata}
\alias{BinAugmentCifstrata}
\title{Augmentation for Binomial regression based on stratified NPMLE Cif (Aalen-Johansen)}
\usage{
BinAugmentCifstrata(
  formula,
  data = data,
  cause = 1,
  cens.code = 0,
  km = TRUE,
  time = NULL,
  weights = NULL,
  offset = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with 'Event', strata model for CIF given by strata, and strataC specifies censoring strata}

\item{data}{data frame}

\item{cause}{of interest}

\item{cens.code}{code of censoring}

\item{km}{to use Kaplan-Meier}

\item{time}{of interest}

\item{weights}{weights for estimating equations}

\item{offset}{offsets for logistic regression}

\item{...}{Additional arguments to binreg function.}
}
\description{
Computes  the augmentation term for each individual as well as the sum
\deqn{
A = \int_0^t H(u,X) \frac{1}{S^*(u,s)} \frac{1}{G_c(u)} dM_c(u)
}
with 
\deqn{
H(u,X) = F_1^*(t,s) - F_1^*(u,s)
}
using a KM for \deqn{G_c(t)} and a working model for cumulative baseline
related to \deqn{F_1^*(t,s)} and \deqn{s} is strata, \deqn{S^*(t,s) = 1 - F_1^*(t,s) - F_2^*(t,s)}.
}
\details{
Standard errors computed under assumption of correct \deqn{G_c(s)} model.

Augmentation term only computed for standard FG model, since strata is used to 
specify working models for CIF's.
}
\examples{
data(bmt)
dcut(bmt,breaks=2) <- ~age 
out1<-BinAugmentCifstrata(Event(time,cause)~platelet+agecat.2+
		  strata(platelet,agecat.2),data=bmt,cause=1,time=40)
summary(out1)

out2<-BinAugmentCifstrata(Event(time,cause)~platelet+agecat.2+
    strata(platelet,agecat.2)+strataC(platelet),data=bmt,cause=1,time=40)
summary(out2)
}
\author{
Thomas Scheike
}
