% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyDat_conversion.R
\name{phyDat}
\alias{phyDat}
\alias{as.phyDat.character}
\alias{as.phyDat.data.frame}
\alias{as.phyDat.matrix}
\alias{as.MultipleAlignment}
\alias{as.MultipleAlignment.phyDat}
\alias{as.StringSet}
\alias{as.StringSet.phyDat}
\alias{acgt2ry}
\alias{phyDat2MultipleAlignment}
\alias{as.phyDat}
\alias{as.phyDat.factor}
\alias{as.phyDat.DNAbin}
\alias{as.phyDat.AAbin}
\alias{as.phyDat.alignment}
\alias{phyDat2alignment}
\alias{as.phyDat.MultipleAlignment}
\alias{as.phyDat.AAStringSet}
\alias{as.phyDat.DNAStringSet}
\alias{as.character.phyDat}
\alias{as.data.frame.phyDat}
\alias{as.DNAbin.phyDat}
\alias{as.AAbin.phyDat}
\alias{genlight2phyDat}
\title{Conversion among Sequence Formats}
\usage{
phyDat(data, type = "DNA", levels = NULL, return.index = TRUE, ...)

as.phyDat(x, ...)

\method{as.phyDat}{factor}(x, ...)

\method{as.phyDat}{DNAbin}(x, ...)

\method{as.phyDat}{AAbin}(x, ...)

\method{as.phyDat}{alignment}(x, type = "DNA", ...)

phyDat2alignment(x)

\method{as.phyDat}{MultipleAlignment}(x, ...)

\method{as.phyDat}{AAStringSet}(x, ...)

\method{as.phyDat}{DNAStringSet}(x, ...)

as.StringSet(x, ...)

\method{as.StringSet}{phyDat}(x, ...)

\method{as.MultipleAlignment}{phyDat}(x, ...)

\method{as.character}{phyDat}(x, allLevels = TRUE, ...)

\method{as.data.frame}{phyDat}(x, ...)

\method{as.DNAbin}{phyDat}(x, ...)

\method{as.AAbin}{phyDat}(x, ...)

genlight2phyDat(x, ambiguity = NA)

acgt2ry(obj)
}
\arguments{
\item{data}{An object containing sequences.}

\item{type}{Type of sequences ("DNA", "AA", "CODON" or "USER").}

\item{levels}{Level attributes.}

\item{return.index}{If TRUE returns a index of the site patterns.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{An object containing sequences.}

\item{allLevels}{return original data.}

\item{ambiguity}{character for ambiguous character and no contrast is
provided.}

\item{obj}{as object of class phyDat}
}
\value{
The functions return an object of class \code{phyDat}.
}
\description{
These functions transform several DNA formats into the \code{phyDat} format.
\code{allSitePattern} generates an alignment of all possible site patterns.
}
\details{
If \code{type} "USER" a vector has to be give to \code{levels}. For example
c("a", "c", "g", "t", "-") would create a data object that can be used in
phylogenetic analysis with gaps as fifth state.  There is a more detailed
example for specifying "USER" defined data formats in the vignette
"phangorn-specials".

\code{acgt2ry} converts a \code{phyDat} object of nucleotides into an binary
ry-coded dataset.
}
\examples{

data(Laurasiatherian)
class(Laurasiatherian)
Laurasiatherian
# transform as characters
LauraChar <- as.character(Laurasiatherian)
# and back
Laura <- phyDat(LauraChar)
all.equal(Laurasiatherian, Laura)
LauraDNAbin <- as.DNAbin(Laurasiatherian)
all.equal(Laurasiatherian, as.phyDat(LauraDNAbin))

}
\seealso{
\code{\link[ape]{DNAbin}}, \code{\link[ape]{as.DNAbin}},
\code{\link{baseFreq}}, \code{\link{glance.phyDat}},
\code{\link[ape]{read.dna}}, \code{\link[ape]{read.nexus.data}}
and the chapter 1 in the \code{vignette("phangorn-specials",
package="phangorn")} and the example of \code{\link{pmlMix}} for the use of
\code{allSitePattern}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
