% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pillar.R
\name{pillar}
\alias{pillar}
\title{Format a vector suitable for tabular display}
\usage{
pillar(x, title = NULL, width = NULL, ...)
}
\arguments{
\item{x}{A vector to format.}

\item{title}{An optional title for the column. The title will be
used "as is", no quoting will be applied.}

\item{width}{Default width, optional.}

\item{...}{Passed on to \code{\link[=pillar_shaft]{pillar_shaft()}}.}
}
\description{
\ifelse{html}{\out{<a href='https://www.tidyverse.org/lifecycle/#stable'><img src='figures/lifecycle-stable.svg' alt='Stable lifecycle'></a>}}{\strong{Stable}}

\code{pillar()} formats a vector using one row for a title (if given),
one row for the type, and \code{length(x)} rows for the data.
}
\details{
A pillar consists of a \emph{capital} and a \emph{shaft}.

The capital is constructed using the (currently internal)
\code{pillar_capital()} function, which uses the \code{title} argument
and calls \code{\link[=type_sum]{type_sum()}} to format the type.

For the shaft, the \code{\link[=pillar_shaft]{pillar_shaft()}} generic is called with the object.
The returned value is stored and processed with \code{\link[=format]{format()}} when displaying the pillar.
The call to \code{format()} has a valid \code{width} argument.
Depending on the implementation,
the output representation can be computed eagerly right away (as done with \code{\link[=new_pillar_shaft_simple]{new_pillar_shaft_simple()}}),
or only when \code{format()} is called.
The latter allows for adaptive shortening of the output depending on the available width,
see \code{pillar:::pillar_shaft.numeric} for an example.
}
\examples{
x <- 123456789 * (10 ^ c(-1, -3, -5, NA, -8, -10))
pillar(x)
pillar(-x)
pillar(runif(10))
pillar(rcauchy(20))

# Special values are highlighted
pillar(c(runif(5), NA, NaN, Inf, -Inf))

# Very wide ranges will be displayed in scientific format
pillar(c(1e10, 1e-10), width = 20)
pillar(c(1e10, 1e-10))

x <- c(FALSE, NA, FALSE, FALSE, TRUE, FALSE, FALSE, TRUE, FALSE, TRUE)
pillar(x)

x <- c("This is string is rather long", NA, "?", "Short")
pillar(x)
pillar(x, width = 30)
pillar(x, width = 5)

date <- as.Date("2017-05-15")
pillar(date + c(1, NA, 3:5))
pillar(as.POSIXct(date) + c(30, NA, 600, 3600, 86400))
}
