% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Units.R
\name{Units}
\alias{Units}
\title{Add units to data set}
\usage{
Units(object, units)
}
\arguments{
\item{object}{A data.frame or data.table}

\item{units}{Named list of units. Names are variable names. If omitted, show existing units.}
}
\value{
The object augmented with attribute \code{"units"}
}
\description{
Add variable units to data.frame (or data.table).
}
\details{
If the object has units existing units are replaced by given units.
}
\examples{
data(Diabetes)
Diabetes <- Units(Diabetes,list(BMI="kg/m^2"))
Units(Diabetes)
Diabetes <- Units(Diabetes,list(bp.1s="mm Hg",bp.2s="mm Hg"))
Units(Diabetes)
}
\author{
Thomas A. Gerds <tag@biostat.ku.dk>
}
