% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stereo.R
\name{get.stereo.types}
\alias{get.stereo.types}
\title{Obtain the stereocenter type for atom.}
\usage{
get.stereo.types(mol)
}
\arguments{
\item{mol}{A \code{jObjRef} representing an \code{IAtomContainer}}
}
\value{
A factor of length equal in length to the number of atoms indicating the stereocenter type.
}
\description{
Supported stereo center types are
\describe{
\item{True}{the atom has constitutionally different neighbors}
\item{Para}{the atom resembles a stereo centre but has constitutionally equivalent neighbors (e.g. inositol, decalin). The stereocenter depends on the configuration of one or more stereocenters.}
\item{Potential}{the atom can supported stereo chemistry but has not be shown ot be a true or para center}
\item{Non}{the atom is not a stereocenter (e.g. methane)}
}
}
\seealso{
\code{\link{get.stereocenters}}, \code{\link{get.element.types}}
}
\author{
Rajarshi Guha \email{rajarshi.guha@gmail.com}
}
