% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locator.R
\name{locate_function}
\alias{locate_function}
\alias{locate_prefixed_function}
\title{Locate a function with a given name and return it and its environment.}
\usage{
locate_function(name, env = globalenv(), ...)

locate_prefixed_function(
  name,
  prefix,
  errname,
  env = globalenv(),
  ...,
  call. = FALSE
)
}
\arguments{
\item{name}{a character string giving the function's name.}

\item{env}{an \code{\link{environment}} where it should search first.}

\item{...}{additional arguments to the warning and error warning messages. See Details.}

\item{prefix}{a character string giving the prefix, so the
searched-for function is \code{prefix.name}.}

\item{errname}{a character string; if given, if the function is not
found an error is raised, with \code{errname} prepended to the error
message.}

\item{call.}{a logical, whether the call
(\code{locate_prefixed_function}) should be a part of the error
message; defaults to \code{FALSE} (which is different from \code{\link[=stop]{stop()}}'s
default).}
}
\value{
If the function is found, an unevaluated call of the form
\code{ENVNAME:::FUNNAME}, which can then be used to call the function
even if it is unexported. If the environment does not have a
name, or is \code{GlobalEnv}, only \code{FUNNAME} is returned. Otherwise,
\code{NULL} is returned.
}
\description{
These functions first search the given environment, then search all
loaded environments, including those where the function is not
exported. If found, they return an unambiguous reference to the
function.
}
\details{
If the initial search fails, a search using
\code{\link[=getAnywhere]{getAnywhere()}} is attempted, with exported ("visible") functions
with the specified name preferred over those that are not. When
multiple equally qualified functions are available, a warning is
printed and an arbitrary one is returned.

Because \code{\link[=getAnywhere]{getAnywhere()}} can be slow, past searches are cached.
}
\section{Functions}{
\itemize{
\item \code{locate_function()}: a low-level function returning the
reference to the function named \code{name}, or \code{NULL} if not found.

\item \code{locate_prefixed_function()}: a helper function that searches for a
function of the form \code{prefix.name} and produces an informative
error message if not found.

}}
\examples{

# Locate a random function in base.
locate_function(".row_names_info")

}
