% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-that.R
\name{test_that}
\alias{test_that}
\title{Create a test.}
\usage{
test_that(desc, code)
}
\arguments{
\item{desc}{test name.  Names should be kept as brief as possible, as they
are often used as line prefixes.}

\item{code}{test code containing expectations.  Braces (\code{{}}) should always be
used in order to get accurate location data for test failures.}
}
\description{
A test encapsulates a series of expectations about small, self-contained
set of functionality. Each test is contained in a \link{context} and
contains multiple expectations.
}
\details{
Tests are evaluated in their own environments, and should not affect
global state.

When run from the command line, tests return \code{NULL} if all
expectations are met, otherwise it raises an error.
}
\examples{
test_that("trigonometric functions match identities", {
  expect_equal(sin(pi / 4), 1 / sqrt(2))
  expect_equal(cos(pi / 4), 1 / sqrt(2))
  expect_equal(tan(pi / 4), 1)
})
# Failing test:
\dontrun{
test_that("trigonometric functions match identities", {
  expect_equal(sin(pi / 4), 1)
})
}
}
