% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{find_globals}
\alias{find_globals}
\alias{find_locals}
\title{Find global/local variables in R code}
\usage{
find_globals(code, envir = parent.frame())

find_locals(code)
}
\arguments{
\item{code}{Either a character vector of R source code, or an R expression.}

\item{envir}{The global environment in which global variables are to be
found.}
}
\value{
A character vector of the variable names. If the source code contains
syntax errors, an empty character vector will be returned.
}
\description{
Use \code{\link[codetools:findGlobals]{codetools::findGlobals()}} and \code{\link[codetools:codetools]{codetools::findLocalsList()}} to find
global and local variables in a piece of code. Global variables are defined
outside the code, and local variables are created inside the code.
}
\note{
Due to the flexibility of creating and getting variables in R, these
functions are not guaranteed to find all possible variables in the code
(e.g., when the code is hidden behind \code{eval()}).
}
\examples{
x = 2
xfun::find_globals("y = x + 1")
xfun::find_globals("y = get('x') + 1")  # x is not recognized
xfun::find_globals("y = zzz + 1")  # zzz doesn't exist

xfun::find_locals("y = x + 1")
xfun::find_locals("assign('y', x + 1)")  # it works
xfun::find_locals("assign('y', x + 1, new.env())")  # still smart
xfun::find_locals("eval(parse(text = 'y = x + 1'))")  # no way
}
