# SPDX-License-Identifier: BSD-3-Clause
#
# Copyright 2022 Raritan Inc. All rights reserved.
#
# This is an auto-generated file.

#
# Section generated by IdlC from "PortFuse.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.portsmodel


# interface
class PortFuse(Interface):
    idlType = "portsmodel.PortFuse:1.0.1"

    # enumeration
    class Status(Enumeration):
        idlType = "portsmodel.PortFuse_1_0_1.Status:1.0.0"
        values = ["UNKNOWN", "TRIPPED", "GOOD"]

    Status.UNKNOWN = Status(0)
    Status.TRIPPED = Status(1)
    Status.GOOD = Status(2)

    # value object
    class StatusChangedEvent(raritan.rpc.idl.Event):
        idlType = "portsmodel.PortFuse_1_0_1.StatusChangedEvent:1.0.0"

        def __init__(self, oldStatus, newStatus, source):
            super(raritan.rpc.portsmodel.PortFuse.StatusChangedEvent, self).__init__(source)
            typecheck.is_enum(oldStatus, raritan.rpc.portsmodel.PortFuse.Status, AssertionError)
            typecheck.is_enum(newStatus, raritan.rpc.portsmodel.PortFuse.Status, AssertionError)

            self.oldStatus = oldStatus
            self.newStatus = newStatus

        def encode(self):
            json = super(raritan.rpc.portsmodel.PortFuse.StatusChangedEvent, self).encode()
            json['oldStatus'] = raritan.rpc.portsmodel.PortFuse.Status.encode(self.oldStatus)
            json['newStatus'] = raritan.rpc.portsmodel.PortFuse.Status.encode(self.newStatus)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldStatus = raritan.rpc.portsmodel.PortFuse.Status.decode(json['oldStatus']),
                newStatus = raritan.rpc.portsmodel.PortFuse.Status.decode(json['newStatus']),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldStatus", "newStatus"]
            elements = elements + super(raritan.rpc.portsmodel.PortFuse.StatusChangedEvent, self).listElements()
            return elements

    class _getStatus(Interface.Method):
        name = 'getStatus'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.portsmodel.PortFuse.Status.decode(rsp['_ret_'])
            typecheck.is_enum(_ret_, raritan.rpc.portsmodel.PortFuse.Status, DecodeException)
            return _ret_

    class _reset(Interface.Method):
        name = 'reset'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _getTripCount(Interface.Method):
        name = 'getTripCount'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(PortFuse, self).__init__(target, agent)
        self.getStatus = PortFuse._getStatus(self)
        self.reset = PortFuse._reset(self)
        self.getTripCount = PortFuse._getTripCount(self)

#
# Section generated by IdlC from "Port.idl"
#

import raritan.rpc
from raritan.rpc import Interface, Structure, ValueObject, Enumeration, typecheck, DecodeException
import raritan.rpc.idl

import raritan.rpc.portsmodel


# interface
class Port(Interface):
    idlType = "portsmodel.Port:2.0.3"

    NO_ERROR = 0

    ERR_INVALID_PARAM = 1

    ERR_DEVICE_BUSY = 2

    # enumeration
    class DetectionType(Enumeration):
        idlType = "portsmodel.Port_2_0_3.DetectionType:1.0.0"
        values = ["AUTO", "PINNED", "DISABLED"]

    DetectionType.AUTO = DetectionType(0)
    DetectionType.PINNED = DetectionType(1)
    DetectionType.DISABLED = DetectionType(2)

    # structure
    class DetectionMode(Structure):
        idlType = "portsmodel.Port_2_0_3.DetectionMode:1.0.0"
        elements = ["type", "pinnedDeviceType"]

        def __init__(self, type, pinnedDeviceType):
            typecheck.is_enum(type, raritan.rpc.portsmodel.Port.DetectionType, AssertionError)
            typecheck.is_string(pinnedDeviceType, AssertionError)

            self.type = type
            self.pinnedDeviceType = pinnedDeviceType

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                type = raritan.rpc.portsmodel.Port.DetectionType.decode(json['type']),
                pinnedDeviceType = json['pinnedDeviceType'],
            )
            return obj

        def encode(self):
            json = {}
            json['type'] = raritan.rpc.portsmodel.Port.DetectionType.encode(self.type)
            json['pinnedDeviceType'] = self.pinnedDeviceType
            return json

    # structure
    class Properties(Structure):
        idlType = "portsmodel.Port_2_0_3.Properties:1.0.0"
        elements = ["name", "label", "mode", "detectedDeviceType", "detectedDeviceName"]

        def __init__(self, name, label, mode, detectedDeviceType, detectedDeviceName):
            typecheck.is_string(name, AssertionError)
            typecheck.is_string(label, AssertionError)
            typecheck.is_struct(mode, raritan.rpc.portsmodel.Port.DetectionMode, AssertionError)
            typecheck.is_string(detectedDeviceType, AssertionError)
            typecheck.is_string(detectedDeviceName, AssertionError)

            self.name = name
            self.label = label
            self.mode = mode
            self.detectedDeviceType = detectedDeviceType
            self.detectedDeviceName = detectedDeviceName

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                name = json['name'],
                label = json['label'],
                mode = raritan.rpc.portsmodel.Port.DetectionMode.decode(json['mode'], agent),
                detectedDeviceType = json['detectedDeviceType'],
                detectedDeviceName = json['detectedDeviceName'],
            )
            return obj

        def encode(self):
            json = {}
            json['name'] = self.name
            json['label'] = self.label
            json['mode'] = raritan.rpc.portsmodel.Port.DetectionMode.encode(self.mode)
            json['detectedDeviceType'] = self.detectedDeviceType
            json['detectedDeviceName'] = self.detectedDeviceName
            return json

    # value object
    class PropertiesChangedEvent(raritan.rpc.idl.Event):
        idlType = "portsmodel.Port_2_0_3.PropertiesChangedEvent:1.0.0"

        def __init__(self, oldProperties, newProperties, source):
            super(raritan.rpc.portsmodel.Port.PropertiesChangedEvent, self).__init__(source)
            typecheck.is_struct(oldProperties, raritan.rpc.portsmodel.Port.Properties, AssertionError)
            typecheck.is_struct(newProperties, raritan.rpc.portsmodel.Port.Properties, AssertionError)

            self.oldProperties = oldProperties
            self.newProperties = newProperties

        def encode(self):
            json = super(raritan.rpc.portsmodel.Port.PropertiesChangedEvent, self).encode()
            json['oldProperties'] = raritan.rpc.portsmodel.Port.Properties.encode(self.oldProperties)
            json['newProperties'] = raritan.rpc.portsmodel.Port.Properties.encode(self.newProperties)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldProperties = raritan.rpc.portsmodel.Port.Properties.decode(json['oldProperties'], agent),
                newProperties = raritan.rpc.portsmodel.Port.Properties.decode(json['newProperties'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldProperties", "newProperties"]
            elements = elements + super(raritan.rpc.portsmodel.Port.PropertiesChangedEvent, self).listElements()
            return elements

    # value object
    class DeviceChangedEvent(raritan.rpc.idl.Event):
        idlType = "portsmodel.Port_2_0_3.DeviceChangedEvent:1.0.0"

        def __init__(self, oldDevice, newDevice, source):
            super(raritan.rpc.portsmodel.Port.DeviceChangedEvent, self).__init__(source)
            typecheck.is_remote_obj(oldDevice, AssertionError)
            typecheck.is_remote_obj(newDevice, AssertionError)

            self.oldDevice = oldDevice
            self.newDevice = newDevice

        def encode(self):
            json = super(raritan.rpc.portsmodel.Port.DeviceChangedEvent, self).encode()
            json['oldDevice'] = Interface.encode(self.oldDevice)
            json['newDevice'] = Interface.encode(self.newDevice)
            return json

        @classmethod
        def decode(cls, json, agent):
            obj = cls(
                oldDevice = Interface.decode(json['oldDevice'], agent),
                newDevice = Interface.decode(json['newDevice'], agent),
                # for idl.Event
                source = Interface.decode(json['source'], agent),
            )
            return obj

        def listElements(self):
            elements = ["oldDevice", "newDevice"]
            elements = elements + super(raritan.rpc.portsmodel.Port.DeviceChangedEvent, self).listElements()
            return elements

    class _getProperties(Interface.Method):
        name = 'getProperties'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = raritan.rpc.portsmodel.Port.Properties.decode(rsp['_ret_'], agent)
            typecheck.is_struct(_ret_, raritan.rpc.portsmodel.Port.Properties, DecodeException)
            return _ret_

    class _setName(Interface.Method):
        name = 'setName'

        @staticmethod
        def encode(name):
            typecheck.is_string(name, AssertionError)
            args = {}
            args['name'] = name
            return args

        @staticmethod
        def decode(rsp, agent):
            return None

    class _setDetectionMode(Interface.Method):
        name = 'setDetectionMode'

        @staticmethod
        def encode(mode):
            typecheck.is_struct(mode, raritan.rpc.portsmodel.Port.DetectionMode, AssertionError)
            args = {}
            args['mode'] = raritan.rpc.portsmodel.Port.DetectionMode.encode(mode)
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = rsp['_ret_']
            typecheck.is_int(_ret_, DecodeException)
            return _ret_

    class _getDetectableDevices(Interface.Method):
        name = 'getDetectableDevices'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = [x0 for x0 in rsp['_ret_']]
            for x0 in _ret_:
                typecheck.is_string(x0, DecodeException)
            return _ret_

    class _getDevice(Interface.Method):
        name = 'getDevice'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_remote_obj(_ret_, DecodeException)
            return _ret_

    class _getDeviceConfig(Interface.Method):
        name = 'getDeviceConfig'

        @staticmethod
        def encode(deviceType):
            typecheck.is_string(deviceType, AssertionError)
            args = {}
            args['deviceType'] = deviceType
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_remote_obj(_ret_, DecodeException)
            return _ret_

    class _getFuse(Interface.Method):
        name = 'getFuse'

        @staticmethod
        def encode():
            args = {}
            return args

        @staticmethod
        def decode(rsp, agent):
            _ret_ = Interface.decode(rsp['_ret_'], agent)
            typecheck.is_interface(_ret_, raritan.rpc.portsmodel.PortFuse, DecodeException)
            return _ret_
    def __init__(self, target, agent):
        super(Port, self).__init__(target, agent)
        self.getProperties = Port._getProperties(self)
        self.setName = Port._setName(self)
        self.setDetectionMode = Port._setDetectionMode(self)
        self.getDetectableDevices = Port._getDetectableDevices(self)
        self.getDevice = Port._getDevice(self)
        self.getDeviceConfig = Port._getDeviceConfig(self)
        self.getFuse = Port._getFuse(self)
