/* prefix-input-stream.c generated by valac 0.56.18, the Vala compiler
 * generated from prefix-input-stream.vala, do not modify */

/* PrefixInputStream: present some bytes followed by an InputStream as an*/
/* InputStream.*/
/**/
/* © 2025 Alistair Turnbull <apt1002@mupsych.org>*/
/**/
/* This program is free software; you can redistribute it and/or modify*/
/* it under the terms of the GNU General Public License as published by*/
/* the Free Software Foundation; either version 3, or (at your option)*/
/* any later version.*/
/**/
/* This program is distributed in the hope that it will be useful,*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/* GNU General Public License for more details.*/
/**/
/* You should have received a copy of the GNU General Public License*/
/* along with this program; if not, see <https://www.gnu.org/licenses/>.*/

#include <gio/gio.h>
#include <glib-object.h>
#include <glib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_PREFIX_INPUT_STREAM (prefix_input_stream_get_type ())
#define PREFIX_INPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFIX_INPUT_STREAM, PrefixInputStream))
#define PREFIX_INPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFIX_INPUT_STREAM, PrefixInputStreamClass))
#define IS_PREFIX_INPUT_STREAM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFIX_INPUT_STREAM))
#define IS_PREFIX_INPUT_STREAM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFIX_INPUT_STREAM))
#define PREFIX_INPUT_STREAM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFIX_INPUT_STREAM, PrefixInputStreamClass))

typedef struct _PrefixInputStream PrefixInputStream;
typedef struct _PrefixInputStreamClass PrefixInputStreamClass;
typedef struct _PrefixInputStreamPrivate PrefixInputStreamPrivate;
enum  {
	PREFIX_INPUT_STREAM_0_PROPERTY,
	PREFIX_INPUT_STREAM_NUM_PROPERTIES
};
static GParamSpec* prefix_input_stream_properties[PREFIX_INPUT_STREAM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _PrefixInputStream {
	GFilterInputStream parent_instance;
	PrefixInputStreamPrivate * priv;
};

struct _PrefixInputStreamClass {
	GFilterInputStreamClass parent_class;
};

struct _PrefixInputStreamPrivate {
	guint8* prefix;
	gint prefix_length1;
	gint _prefix_size_;
	gsize read_ptr;
};

static gint PrefixInputStream_private_offset;
static gpointer prefix_input_stream_parent_class = NULL;

VALA_EXTERN GType prefix_input_stream_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PrefixInputStream, g_object_unref)
VALA_EXTERN PrefixInputStream* prefix_input_stream_new (guint8* prefix,
                                            gint prefix_length1,
                                            GInputStream* base_stream);
VALA_EXTERN PrefixInputStream* prefix_input_stream_construct (GType object_type,
                                                  guint8* prefix,
                                                  gint prefix_length1,
                                                  GInputStream* base_stream);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
static gboolean prefix_input_stream_real_close (GInputStream* base,
                                         GCancellable* cancellable,
                                         GError** error);
static gssize prefix_input_stream_real_read (GInputStream* base,
                                      guint8* buffer,
                                      gsize buffer_length1,
                                      GCancellable* cancellable,
                                      GError** error);
static void prefix_input_stream_finalize (GObject * obj);
static GType prefix_input_stream_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
prefix_input_stream_get_instance_private (PrefixInputStream* self)
{
	return G_STRUCT_MEMBER_P (self, PrefixInputStream_private_offset);
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
#line 27 "prefix-input-stream.vala"
	if (length > 0) {
#line 27 "prefix-input-stream.vala"
		return _vala_memdup2 (self, length * sizeof (guint8));
#line 120 "prefix-input-stream.c"
	}
#line 27 "prefix-input-stream.vala"
	return NULL;
#line 124 "prefix-input-stream.c"
}

PrefixInputStream*
prefix_input_stream_construct (GType object_type,
                               guint8* prefix,
                               gint prefix_length1,
                               GInputStream* base_stream)
{
	PrefixInputStream * self = NULL;
	guint8* _tmp0_;
	gint _tmp0__length1;
#line 25 "prefix-input-stream.vala"
	g_return_val_if_fail (base_stream != NULL, NULL);
#line 26 "prefix-input-stream.vala"
	self = (PrefixInputStream*) g_object_new (object_type, "base-stream", base_stream, "close-base-stream", TRUE, NULL);
#line 27 "prefix-input-stream.vala"
	_tmp0_ = (prefix != NULL) ? _vala_array_dup2 (prefix, prefix_length1) : prefix;
#line 27 "prefix-input-stream.vala"
	_tmp0__length1 = prefix_length1;
#line 27 "prefix-input-stream.vala"
	self->priv->prefix = (g_free (self->priv->prefix), NULL);
#line 27 "prefix-input-stream.vala"
	self->priv->prefix = _tmp0_;
#line 27 "prefix-input-stream.vala"
	self->priv->prefix_length1 = _tmp0__length1;
#line 27 "prefix-input-stream.vala"
	self->priv->_prefix_size_ = self->priv->prefix_length1;
#line 28 "prefix-input-stream.vala"
	self->priv->read_ptr = (gsize) 0;
#line 25 "prefix-input-stream.vala"
	_g_object_unref0 (base_stream);
#line 25 "prefix-input-stream.vala"
	return self;
#line 158 "prefix-input-stream.c"
}

PrefixInputStream*
prefix_input_stream_new (guint8* prefix,
                         gint prefix_length1,
                         GInputStream* base_stream)
{
#line 25 "prefix-input-stream.vala"
	return prefix_input_stream_construct (TYPE_PREFIX_INPUT_STREAM, prefix, prefix_length1, base_stream);
#line 168 "prefix-input-stream.c"
}

static gboolean
prefix_input_stream_real_close (GInputStream* base,
                                GCancellable* cancellable,
                                GError** error)
{
	PrefixInputStream * self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	GError* _inner_error0_ = NULL;
	gboolean result;
#line 31 "prefix-input-stream.vala"
	self = (PrefixInputStream*) base;
#line 32 "prefix-input-stream.vala"
	_tmp0_ = g_filter_input_stream_get_close_base_stream ((GFilterInputStream*) self);
#line 32 "prefix-input-stream.vala"
	_tmp1_ = _tmp0_;
#line 32 "prefix-input-stream.vala"
	if (_tmp1_) {
#line 189 "prefix-input-stream.c"
		gboolean _tmp2_ = FALSE;
		GInputStream* _tmp3_;
		GInputStream* _tmp4_;
#line 33 "prefix-input-stream.vala"
		_tmp3_ = g_filter_input_stream_get_base_stream ((GFilterInputStream*) self);
#line 33 "prefix-input-stream.vala"
		_tmp4_ = _tmp3_;
#line 33 "prefix-input-stream.vala"
		_tmp2_ = g_input_stream_close (_tmp4_, NULL, &_inner_error0_);
#line 33 "prefix-input-stream.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 33 "prefix-input-stream.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 203 "prefix-input-stream.c"
				gboolean _tmp5_ = FALSE;
#line 33 "prefix-input-stream.vala"
				g_propagate_error (error, _inner_error0_);
#line 33 "prefix-input-stream.vala"
				return _tmp5_;
#line 209 "prefix-input-stream.c"
			} else {
				gboolean _tmp6_ = FALSE;
#line 33 "prefix-input-stream.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 33 "prefix-input-stream.vala"
				g_clear_error (&_inner_error0_);
#line 33 "prefix-input-stream.vala"
				return _tmp6_;
#line 218 "prefix-input-stream.c"
			}
		}
#line 33 "prefix-input-stream.vala"
		result = _tmp2_;
#line 33 "prefix-input-stream.vala"
		return result;
#line 225 "prefix-input-stream.c"
	}
#line 35 "prefix-input-stream.vala"
	result = TRUE;
#line 35 "prefix-input-stream.vala"
	return result;
#line 231 "prefix-input-stream.c"
}

static gssize
prefix_input_stream_real_read (GInputStream* base,
                               guint8* buffer,
                               gsize buffer_length1,
                               GCancellable* cancellable,
                               GError** error)
{
	PrefixInputStream * self;
	guint8* _tmp0_;
	gint _tmp0__length1;
	GError* _inner_error0_ = NULL;
	gssize result;
#line 38 "prefix-input-stream.vala"
	self = (PrefixInputStream*) base;
#line 39 "prefix-input-stream.vala"
	_tmp0_ = self->priv->prefix;
#line 39 "prefix-input-stream.vala"
	_tmp0__length1 = self->priv->prefix_length1;
#line 39 "prefix-input-stream.vala"
	if (self->priv->read_ptr < ((gsize) _tmp0__length1)) {
#line 254 "prefix-input-stream.c"
		gsize ret = 0UL;
		guint8* _tmp1_;
		gint _tmp1__length1;
		guint8* _tmp2_;
		gint _tmp2__length1;
		guint8* _tmp3_;
		gint _tmp3__length1;
#line 41 "prefix-input-stream.vala"
		_tmp1_ = self->priv->prefix;
#line 41 "prefix-input-stream.vala"
		_tmp1__length1 = self->priv->prefix_length1;
#line 41 "prefix-input-stream.vala"
		ret = MIN (_tmp1__length1 - self->priv->read_ptr, (gsize) buffer_length1);
#line 42 "prefix-input-stream.vala"
		_tmp2_ = self->priv->prefix;
#line 42 "prefix-input-stream.vala"
		_tmp2__length1 = self->priv->prefix_length1;
#line 42 "prefix-input-stream.vala"
		_tmp3_ = self->priv->prefix;
#line 42 "prefix-input-stream.vala"
		_tmp3__length1 = self->priv->prefix_length1;
#line 42 "prefix-input-stream.vala"
		memmove (buffer, _tmp3_ + ((gint) self->priv->read_ptr), ret);
#line 43 "prefix-input-stream.vala"
		self->priv->read_ptr = self->priv->read_ptr + ret;
#line 44 "prefix-input-stream.vala"
		result = (gssize) ret;
#line 44 "prefix-input-stream.vala"
		return result;
#line 284 "prefix-input-stream.c"
	} else {
		gssize _tmp4_ = 0L;
		GInputStream* _tmp5_;
		GInputStream* _tmp6_;
#line 47 "prefix-input-stream.vala"
		_tmp5_ = g_filter_input_stream_get_base_stream ((GFilterInputStream*) self);
#line 47 "prefix-input-stream.vala"
		_tmp6_ = _tmp5_;
#line 47 "prefix-input-stream.vala"
		_tmp4_ = g_input_stream_read (_tmp6_, buffer, (gsize) buffer_length1, cancellable, &_inner_error0_);
#line 47 "prefix-input-stream.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 47 "prefix-input-stream.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 299 "prefix-input-stream.c"
				gssize _tmp7_ = -1L;
#line 47 "prefix-input-stream.vala"
				g_propagate_error (error, _inner_error0_);
#line 47 "prefix-input-stream.vala"
				return _tmp7_;
#line 305 "prefix-input-stream.c"
			} else {
				gssize _tmp8_ = -1L;
#line 47 "prefix-input-stream.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 47 "prefix-input-stream.vala"
				g_clear_error (&_inner_error0_);
#line 47 "prefix-input-stream.vala"
				return _tmp8_;
#line 314 "prefix-input-stream.c"
			}
		}
#line 47 "prefix-input-stream.vala"
		result = _tmp4_;
#line 47 "prefix-input-stream.vala"
		return result;
#line 321 "prefix-input-stream.c"
	}
}

static void
prefix_input_stream_class_init (PrefixInputStreamClass * klass,
                                gpointer klass_data)
{
#line 20 "prefix-input-stream.vala"
	prefix_input_stream_parent_class = g_type_class_peek_parent (klass);
#line 20 "prefix-input-stream.vala"
	g_type_class_adjust_private_offset (klass, &PrefixInputStream_private_offset);
#line 20 "prefix-input-stream.vala"
	((GInputStreamClass *) klass)->close_fn = (gboolean (*) (GInputStream*, GCancellable*, GError**)) prefix_input_stream_real_close;
#line 20 "prefix-input-stream.vala"
	((GInputStreamClass *) klass)->read_fn = (gssize (*) (GInputStream*, guint8*, gsize, GCancellable*, GError**)) prefix_input_stream_real_read;
#line 20 "prefix-input-stream.vala"
	G_OBJECT_CLASS (klass)->finalize = prefix_input_stream_finalize;
#line 339 "prefix-input-stream.c"
}

static void
prefix_input_stream_instance_init (PrefixInputStream * self,
                                   gpointer klass)
{
#line 20 "prefix-input-stream.vala"
	self->priv = prefix_input_stream_get_instance_private (self);
#line 348 "prefix-input-stream.c"
}

static void
prefix_input_stream_finalize (GObject * obj)
{
	PrefixInputStream * self;
#line 20 "prefix-input-stream.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFIX_INPUT_STREAM, PrefixInputStream);
#line 22 "prefix-input-stream.vala"
	self->priv->prefix = (g_free (self->priv->prefix), NULL);
#line 20 "prefix-input-stream.vala"
	G_OBJECT_CLASS (prefix_input_stream_parent_class)->finalize (obj);
#line 361 "prefix-input-stream.c"
}

static GType
prefix_input_stream_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrefixInputStreamClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prefix_input_stream_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrefixInputStream), 0, (GInstanceInitFunc) prefix_input_stream_instance_init, NULL };
	GType prefix_input_stream_type_id;
	prefix_input_stream_type_id = g_type_register_static (g_filter_input_stream_get_type (), "PrefixInputStream", &g_define_type_info, 0);
	PrefixInputStream_private_offset = g_type_add_instance_private (prefix_input_stream_type_id, sizeof (PrefixInputStreamPrivate));
	return prefix_input_stream_type_id;
}

GType
prefix_input_stream_get_type (void)
{
	static volatile gsize prefix_input_stream_type_id__once = 0;
	if (g_once_init_enter (&prefix_input_stream_type_id__once)) {
		GType prefix_input_stream_type_id;
		prefix_input_stream_type_id = prefix_input_stream_get_type_once ();
		g_once_init_leave (&prefix_input_stream_type_id__once, prefix_input_stream_type_id);
	}
	return prefix_input_stream_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

